/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.common.ResourceUtility;
import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.common.TextUtility;
import com.wudsn.thecart.repository.Action;
import com.wudsn.thecart.repository.DataType;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public final class ElementFactory {
    private ElementFactory() {
    }

    public static ImageIcon createImageIcon(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 'path' must not be null.");
        }
        byte[] imageData = ResourceUtility.loadResourceAsByteArray(path);
        if (imageData == null) {
            throw new IllegalArgumentException("No icon found for path '" + path + "'.");
        }
        ImageIcon imageIcon = new ImageIcon(imageData);
        return imageIcon;
    }

    public static JButton createButton(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        JButton result = new JButton();
        ElementFactory.setButtonTextAndMnemonic(result, action);
        return result;
    }

    public static JMenu createMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        JMenu result = new JMenu();
        ElementFactory.setButtonTextAndMnemonic(result, action);
        return result;
    }

    public static JMenuItem createMenuItem(Action action, String actionCommand) {
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        if (actionCommand == null) {
            throw new IllegalArgumentException("Parameter 'actionCommand' must not be null.");
        }
        JMenuItem result = new JMenuItem();
        result.setIconTextGap(0);
        ElementFactory.setButtonTextAndMnemonic(result, action);
        result.setActionCommand(actionCommand);
        return result;
    }

    public static void createTab(JTabbedPane tabbedPane, Action action, JComponent component) {
        if (tabbedPane == null) {
            throw new IllegalArgumentException("Parameter 'tabbedPane' must not be null.");
        }
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        if (component == null) {
            throw new IllegalArgumentException("Parameter 'component' must not be null.");
        }
        int index = tabbedPane.getTabCount();
        String toolTip = action.getToolTip();
        if (StringUtility.isEmpty(toolTip)) {
            toolTip = null;
        }
        tabbedPane.insertTab(action.getLabel(), null, component, toolTip, index);
    }

    public static void setButtonTextAndMnemonic(AbstractButton abstractButton, String label, String toolTip) {
        if (abstractButton == null) {
            throw new IllegalArgumentException("Parameter 'abstractButton' must not be null.");
        }
        if (label == null) {
            throw new IllegalArgumentException("Parameter 'label' must not be null.");
        }
        if (toolTip == null) {
            throw new IllegalArgumentException("Parameter 'toolTip' must not be null.");
        }
        int index = label.indexOf(38);
        if (index == -1) {
            throw new RuntimeException("No '&' contained in menu text '" + label + "'.");
        }
        char c = label.charAt(index + 1);
        if (!((c = Character.toUpperCase(c)) >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
            throw new RuntimeException("Mmnemonic character '" + c + "' contained in menu text '" + label + "' if not between 'A' and 'Z' or '0' and '9'.");
        }
        label = String.valueOf(label.substring(0, index)) + label.substring(index + 1, label.length());
        abstractButton.setMnemonic(c);
        abstractButton.setText(label);
        if (StringUtility.isEmpty(toolTip)) {
            toolTip = null;
        }
        abstractButton.setToolTipText(toolTip);
    }

    public static void setButtonTextAndMnemonic(AbstractButton abstractButton, Action action) {
        if (abstractButton == null) {
            throw new IllegalArgumentException("Parameter 'abstractButton' must not be null.");
        }
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        ElementFactory.setButtonTextAndMnemonic(abstractButton, action.getLabel(), action.getToolTip());
    }

    public static JLabel createLabel(DataType dataType, JComponent field) {
        if (dataType == null) {
            throw new IllegalArgumentException("Parameter 'dataType' must not be null.");
        }
        if (field == null) {
            throw new IllegalArgumentException("Parameter 'field' must not be null.");
        }
        String text = dataType.getLabel();
        int index = text.indexOf(38);
        if (index == -1) {
            throw new RuntimeException("No '&' contained in menu text '" + text + "'.");
        }
        char c = text.charAt(index + 1);
        if ((c = Character.toUpperCase(c)) < 'A' || c > 'Z') {
            throw new RuntimeException("Mmnemonic character '" + c + "' contained in menu text '" + text + "' if not between 'A' and 'Z'.");
        }
        text = dataType.getLabelWithoutMnemonics();
        JLabel result = new JLabel(text);
        result.setDisplayedMnemonic(c);
        result.setDisplayedMnemonicIndex(index);
        result.setLabelFor(field);
        String toolTip = dataType.getToolTip();
        if (StringUtility.isSpecified(toolTip)) {
            result.setToolTipText(dataType.getToolTip());
        }
        return result;
    }

    public static Box createButtonBar() {
        Box buttonBar = Box.createHorizontalBox();
        buttonBar.add(Box.createHorizontalGlue());
        buttonBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        return buttonBar;
    }

    public static void setDialogDefaultButtons(JRootPane rootPane, JButton okButton, javax.swing.Action cancelAction) {
        if (rootPane == null) {
            throw new IllegalArgumentException("Parameter 'rootPane' must not be null.");
        }
        if (okButton == null) {
            throw new IllegalArgumentException("Parameter 'okButton' must not be null.");
        }
        if (cancelAction == null) {
            throw new IllegalArgumentException("Parameter 'cancelAction' must not be null.");
        }
        rootPane.setDefaultButton(okButton);
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        rootPane.getActionMap().put("CANCEL", cancelAction);
    }

    public static TableCellRenderer createNumberTableCellRenderer() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                long longValue = ((Number)value).longValue();
                this.setText(TextUtility.formatAsDecimal(longValue));
            }
        };
        renderer.setHorizontalAlignment(4);
        return renderer;
    }

    public static TableCellRenderer createMemorySizeTableCellRenderer() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                long memorySize = ((Number)value).longValue();
                this.setText(TextUtility.formatAsMemorySize(memorySize));
            }
        };
        renderer.setHorizontalAlignment(4);
        return renderer;
    }
}

