/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.common.FileUtility;
import com.wudsn.thecart.common.StringUtility;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public abstract class FileChooser {
    public static FileChooser createInstance() {
        boolean useFileChooser = false;
        FileChooser result = useFileChooser ? new FileChooserWrapper() : new FileDialogWrapper();
        return result;
    }

    public abstract void setDialogTitle(String var1);

    public abstract void setMultiSelectionEnabled(boolean var1);

    public abstract void setCurrentDirectory(File var1);

    public abstract File getCurrentDirectory();

    public abstract void setSelectedFile(File var1);

    public abstract void setFileFilter(FileFilter var1);

    public abstract File getSelectedFile();

    public abstract File[] getSelectedFiles();

    public abstract int showOpenDialog(JFrame var1);

    public abstract int showSaveDialog(JFrame var1);

    private static final class FileChooserWrapper
    extends FileChooser {
        private JFileChooser fileChooser = new JFileChooser();

        @Override
        public void setDialogTitle(String dialogTitle) {
            this.fileChooser.setDialogTitle(dialogTitle);
        }

        @Override
        public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
            this.fileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        }

        @Override
        public void setCurrentDirectory(File dir) {
            this.fileChooser.setCurrentDirectory(dir);
        }

        @Override
        public File getCurrentDirectory() {
            File result = this.fileChooser.getCurrentDirectory();
            return result;
        }

        @Override
        public void setSelectedFile(File file) {
            this.fileChooser.setSelectedFile(file);
        }

        @Override
        public void setFileFilter(FileFilter filefilter) {
            this.fileChooser.setFileFilter(filefilter);
        }

        @Override
        public File getSelectedFile() {
            File result = this.fileChooser.getSelectedFile();
            return result;
        }

        @Override
        public File[] getSelectedFiles() {
            File[] result = this.fileChooser.getSelectedFiles();
            return result;
        }

        @Override
        public int showOpenDialog(JFrame parent) {
            int result = this.fileChooser.showOpenDialog(parent);
            return result;
        }

        @Override
        public int showSaveDialog(JFrame parent) {
            int result = this.fileChooser.showSaveDialog(parent);
            return result;
        }
    }

    private static final class FileDialogWrapper
    extends FileChooser {
        private String dialogTitle;
        private boolean multiSelectionEnabled;
        private File currentDirectory;
        FileFilter fileFilter;
        private File selectedFile;
        private File[] selectedFiles;

        @Override
        public void setDialogTitle(String dialogTitle) {
            this.dialogTitle = dialogTitle;
        }

        @Override
        public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
            this.multiSelectionEnabled = multiSelectionEnabled;
        }

        @Override
        public void setCurrentDirectory(File currentDirectory) {
            this.currentDirectory = currentDirectory;
        }

        @Override
        public File getCurrentDirectory() {
            if (this.currentDirectory == null) {
                this.currentDirectory = new File(System.getProperty("user.home"));
            }
            return this.currentDirectory;
        }

        @Override
        public void setSelectedFile(File selectedFile) {
            this.selectedFile = selectedFile;
        }

        @Override
        public void setFileFilter(FileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        public File getSelectedFile() {
            return this.selectedFile;
        }

        @Override
        public File[] getSelectedFiles() {
            return this.selectedFiles;
        }

        @Override
        public int showOpenDialog(JFrame parent) {
            return this.showDialog(parent, 0);
        }

        @Override
        public int showSaveDialog(JFrame parent) {
            return this.showDialog(parent, 1);
        }

        private int showDialog(JFrame parent, int mode) {
            FileDialog fileDialog = new FileDialog((Frame)parent, this.dialogTitle, mode);
            fileDialog.setMultipleMode(this.multiSelectionEnabled);
            FilenameFilter fileNameFilter = null;
            if (this.fileFilter != null) {
                fileNameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        boolean result = FileDialogWrapper.this.fileFilter.accept(new File(dir, name));
                        return result;
                    }
                };
            }
            fileDialog.setFilenameFilter(fileNameFilter);
            File currentDirectory = this.getCurrentDirectory();
            if (currentDirectory != null) {
                fileDialog.setDirectory(currentDirectory.getAbsolutePath());
            } else {
                fileDialog.setDirectory(null);
            }
            if (this.selectedFile != null) {
                fileDialog.setFile(this.selectedFile.getName());
            } else if (this.fileFilter instanceof FileUtility.FileExtensionFileFilter) {
                FileUtility.FileExtensionFileFilter fileExtensionFileFilter = (FileUtility.FileExtensionFileFilter)this.fileFilter;
                fileDialog.setFile("*" + fileExtensionFileFilter.getFileExtension());
            } else {
                fileDialog.setFile(null);
            }
            int result = 1;
            fileDialog.setVisible(true);
            String currentDirectoryPath = fileDialog.getDirectory();
            if (currentDirectoryPath == null || StringUtility.isEmpty(currentDirectoryPath)) {
                this.setCurrentDirectory(null);
            } else {
                this.setCurrentDirectory(new File(currentDirectoryPath));
            }
            this.selectedFile = null;
            this.selectedFiles = null;
            if (this.multiSelectionEnabled) {
                this.selectedFiles = fileDialog.getFiles();
                if (this.selectedFiles.length > 0) {
                    result = 0;
                }
            } else {
                String selectedFileName = fileDialog.getFile();
                if (selectedFileName != null) {
                    result = 0;
                    this.selectedFile = new File(currentDirectoryPath, selectedFileName);
                }
            }
            return result;
        }
    }
}

