/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.model.Preferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;

public final class MainWindow {
    JFrame frame = new JFrame();
    int state = 0;
    Point actualLocation = null;
    Dimension actualSize = new Dimension();

    public MainWindow() {
        this.frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                MainWindow.this.state = e.getNewState();
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (MainWindow.this.actualLocation == null) {
                    MainWindow.this.actualLocation = MainWindow.this.frame.getLocation();
                }
                if ((MainWindow.this.state & 1) == 1) {
                    return;
                }
                if (MainWindow.this.frame.getLocation().x < 0 || MainWindow.this.frame.getLocation().y < 0) {
                    return;
                }
                if ((MainWindow.this.state & 2) == 0) {
                    MainWindow.this.actualLocation.x = MainWindow.this.frame.getLocation().x;
                }
                if ((MainWindow.this.state & 4) == 0) {
                    MainWindow.this.actualLocation.y = MainWindow.this.frame.getLocation().y;
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if ((MainWindow.this.state & 1) == 1) {
                    return;
                }
                if ((MainWindow.this.state & 2) == 0) {
                    MainWindow.this.actualSize.width = MainWindow.this.frame.getWidth();
                }
                if ((MainWindow.this.state & 4) == 0) {
                    MainWindow.this.actualSize.height = MainWindow.this.frame.getHeight();
                }
            }
        });
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void dispose() {
        this.frame.dispose();
    }

    public void setWindowFromPreferences(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
        }
        this.frame.setExtendedState(preferences.getMainWindowExtendedState() & 0xFFFFFFFE);
        this.actualLocation = preferences.getMainWindowLocation();
        this.actualSize = preferences.getMainWindowSize();
        this.frame.setSize(this.actualSize);
        if (this.actualLocation != null) {
            this.frame.setLocation(preferences.getMainWindowLocation());
        } else {
            this.frame.setLocationRelativeTo(null);
        }
    }

    public void setPreferencesFromWindow(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
        }
        preferences.setMainWindowExtendedState(this.frame.getExtendedState());
        preferences.setMainWindowLocation(this.actualLocation);
        preferences.setMainWindowSize(this.actualSize);
    }
}

