/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.Actions;
import com.wudsn.thecart.gui.ElementFactory;
import com.wudsn.thecart.repository.Action;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class StandardDialog {
    public static final int CHOICE_ACTION = 0;
    public static final int BUTTON_ACTION = 1;

    public static Action[] showConfirmation(Component parentComponent, String title, String message, Action[] choices, Action[] actions, Action defaultAction, Action closeAction) {
        if (parentComponent == null) {
            throw new IllegalArgumentException("Parameter 'parentComponent' must not be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Parameter 'actions' must not be null.");
        }
        if (defaultAction == null) {
            throw new IllegalArgumentException("Parameter 'defaultAction' must not be null.");
        }
        if (closeAction == null) {
            throw new IllegalArgumentException("Parameter 'closeAction' must not be null.");
        }
        return StandardDialog.showInternal(parentComponent, title, 3, message, choices, actions, defaultAction, closeAction);
    }

    public static void showErrorMessage(Component parentComponent, String message, String title) {
        if (parentComponent == null) {
            throw new IllegalArgumentException("Parameter 'parentComponent' must not be null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        StandardDialog.showInternal(parentComponent, title, 0, message, null, new Action[]{Actions.ButtonBar_OK}, Actions.ButtonBar_OK, Actions.ButtonBar_OK);
    }

    private static Action[] showInternal(Component parentComponent, String title, int messageType, String message, Action[] choices, Action[] actions, Action defaultAction, Action closeAction) {
        JRadioButton[] choiceButtons;
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(message), "North");
        ButtonGroup buttomGroup = new ButtonGroup();
        if (choices != null) {
            choiceButtons = new JRadioButton[choices.length];
            Box box = Box.createVerticalBox();
            panel.add((Component)box, "West");
            int i = 0;
            while (i < choices.length) {
                JRadioButton button = new JRadioButton();
                button.setSelected(i == 0);
                ElementFactory.setButtonTextAndMnemonic(button, choices[i]);
                box.add(button);
                buttomGroup.add(button);
                choiceButtons[i] = button;
                ++i;
            }
        } else {
            choiceButtons = null;
        }
        Object[] buttons = new JButton[actions.length];
        JButton defaultButton = null;
        int i = 0;
        while (i < actions.length) {
            Action action = actions[i];
            JButton button = ElementFactory.createButton(action);
            if (action == defaultAction) {
                defaultButton = button;
            }
            buttons[i] = button;
            ++i;
        }
        JOptionPane optionsPane = new JOptionPane(panel, messageType, -1, null, buttons, defaultButton);
        JDialog dialog = optionsPane.createDialog(parentComponent, title);
        int i2 = 0;
        while (i2 < buttons.length) {
            ((AbstractButton)buttons[i2]).addActionListener(new ButtonActionListener(optionsPane, dialog, actions[i2]));
            ++i2;
        }
        dialog.setVisible(true);
        Object value = optionsPane.getValue();
        if (value == null || Integer.valueOf(-1).equals(value)) {
            Action[] actionArray = new Action[2];
            actionArray[1] = closeAction;
            return actionArray;
        }
        Action choice = null;
        if (choices != null && choiceButtons != null) {
            int i3 = 0;
            while (i3 < buttons.length && choice == null) {
                if (choiceButtons[i3].isSelected()) {
                    choice = choices[i3];
                }
                ++i3;
            }
        }
        return new Action[]{choice, (Action)optionsPane.getValue()};
    }

    private static final class ButtonActionListener
    implements ActionListener {
        private JOptionPane optionsPane;
        private JDialog dialog;
        private Action action;

        public ButtonActionListener(JOptionPane optionsPane, JDialog dialog, Action action) {
            if (optionsPane == null) {
                throw new IllegalArgumentException("Parameter 'optionsPane' must not be null.");
            }
            if (dialog == null) {
                throw new IllegalArgumentException("Parameter 'dialog' must not be null.");
            }
            if (action == null) {
                throw new IllegalArgumentException("Parameter 'action' must not be null.");
            }
            this.optionsPane = optionsPane;
            this.dialog = dialog;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.optionsPane.setValue(this.action);
            this.dialog.setVisible(false);
        }
    }
}

