/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.gui;

import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.common.MessageQueueEntry;
import com.wudsn.thecart.common.MessageQueueRenderer;
import com.wudsn.thecart.gui.ElementFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class StatusBar
implements MessageQueueRenderer {
    private Icon iconInfo = ElementFactory.createImageIcon("icons/status-info-16x16.png");
    private Icon iconError = ElementFactory.createImageIcon("icons/status-error-16x16.png");
    private JLabel label = new JLabel();

    public StatusBar() {
        this.label.setHorizontalAlignment(10);
    }

    public JComponent getComponent() {
        return this.label;
    }

    @Override
    public void displayMessageQueue(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (messageQueue.containsError()) {
            this.setStatus(messageQueue.getFirstError());
        } else if (messageQueue.containsInfo()) {
            this.setStatus(messageQueue.getFirstInfo());
        } else {
            this.setStatus(null);
        }
    }

    @Override
    public void displayStatusMessage(MessageQueueEntry messageQueueEntry) {
        if (messageQueueEntry == null) {
            throw new IllegalArgumentException("Parameter 'messageQueueEntry' must not be null.");
        }
        this.setStatus(messageQueueEntry);
    }

    private void setStatus(MessageQueueEntry messageQueueEntry) {
        if (messageQueueEntry == null) {
            this.label.setIcon(null);
            this.label.setText(" ");
        } else {
            Icon icon;
            int severity = messageQueueEntry.getMessage().getSeverity();
            switch (severity) {
                case 1: {
                    icon = this.iconInfo;
                    break;
                }
                case 2: {
                    icon = this.iconInfo;
                    break;
                }
                case 3: {
                    icon = this.iconError;
                    break;
                }
                default: {
                    throw new IllegalStateException("Field 'severity' has illegal value " + severity + ".");
                }
            }
            this.label.setIcon(icon);
            this.label.setText(messageQueueEntry.getMessageText());
            this.label.setToolTipText(String.valueOf(messageQueueEntry.getMessage().getId()) + ": " + this.label.getText());
        }
    }
}

