/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.common.ByteArrayUtility;
import com.wudsn.thecart.common.HexUtility;
import com.wudsn.thecart.common.Log;
import com.wudsn.thecart.model.WorkbookEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AtrLoader {
    private static List<PatchLocation> patchLocations = new ArrayList<PatchLocation>();

    static {
        patchLocations.add(new PatchLocation("dskinv", new byte[]{32, 83, -28}, 1, 3));
        patchLocations.add(new PatchLocation("dskinv", new byte[]{76, 83, -28}, 1, 3));
        patchLocations.add(new PatchLocation("siov", new byte[]{32, 89, -28}, 1, 6));
        patchLocations.add(new PatchLocation("siov", new byte[]{76, 89, -28}, 1, 6));
    }

    public static void setDefaultParameters(WorkbookEntry entry, byte[] content) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        List<WorkbookEntry.Parameter> parameters = AtrLoader.getPatchLocationParameters(content);
        parameters.add(new WorkbookEntry.Parameter("base", 1024));
        Collections.sort(parameters);
        entry.setParameters(WorkbookEntry.Parameter.getParametersString(parameters));
    }

    private static List<WorkbookEntry.Parameter> getPatchLocationParameters(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        ArrayList<WorkbookEntry.Parameter> result = new ArrayList<WorkbookEntry.Parameter>();
        for (PatchLocation patchLocation : patchLocations) {
            int offset = 0;
            while (offset >= 0) {
                if ((offset = ByteArrayUtility.getIndexOf(content, offset, content.length, patchLocation.pattern)) < 0) continue;
                result.add(new WorkbookEntry.Parameter(offset + patchLocation.patchOffset, patchLocation.name));
                offset += patchLocation.pattern.length;
            }
        }
        return result;
    }

    public static int getBaseAddress(WorkbookEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        int base = -1;
        for (WorkbookEntry.Parameter parameter : entry.getParametersList()) {
            if (!parameter.key.equals("base") || !parameter.isValueInteger()) continue;
            base = parameter.getValueAsInteger();
        }
        if (base == -1) {
            base = 1024;
        }
        return base;
    }

    public static void modifyContent(WorkbookEntry entry, byte[] content) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'parametersList' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        int base = AtrLoader.getBaseAddress(entry);
        block5: for (WorkbookEntry.Parameter parameter : entry.getParametersList()) {
            for (PatchLocation patchLocation : patchLocations) {
                int offset;
                String value = parameter.value;
                int mode = 0;
                if (value.startsWith("<")) {
                    mode = 1;
                } else if (value.startsWith(">")) {
                    mode = 2;
                }
                if (mode != 0) {
                    value = value.substring(1);
                }
                if (!parameter.isKeyInteger() || !value.equals(patchLocation.name) || (offset = parameter.getKeyAsInteger()) >= content.length) continue;
                int address = base + patchLocation.baseOffset;
                switch (mode) {
                    case 0: {
                        AtrLoader.modifyContent(content, offset, address & 0xFF);
                        AtrLoader.modifyContent(content, offset + 1, address >>> 8 & 0xFF);
                        continue block5;
                    }
                    case 1: {
                        AtrLoader.modifyContent(content, offset, address & 0xFF);
                        continue block5;
                    }
                    case 2: {
                        AtrLoader.modifyContent(content, offset, address >>> 8 & 0xFF);
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("Undefined mode " + mode + ".");
                    }
                }
            }
        }
        System.arraycopy(content, 16, content, 0, content.length - 16);
    }

    private static void modifyContent(byte[] content, int offset, int value) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        Log.logInfo("Replacing {0} with {1} at offset {2}", new Object[]{HexUtility.getByteValueHexString(content[offset] & 0xFF), HexUtility.getByteValueHexString(value), HexUtility.getLongValueHexString(offset)});
        content[offset] = (byte)(value & 0xFF);
    }

    private static final class Constants {
        public static final String BASE = "base";
        public static final String DSKINV = "dskinv";
        public static final String SIOV = "siov";
        public static final int DEFAULT_BASE = 1024;

        private Constants() {
        }
    }

    private static final class PatchLocation {
        public final String name;
        public final byte[] pattern;
        public final int patchOffset;
        public final int baseOffset;

        public PatchLocation(String name, byte[] pattern, int patchOffset, int baseOffset) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' must not be null.");
            }
            if (pattern == null) {
                throw new IllegalArgumentException("Parameter 'pattern' must not be null.");
            }
            this.name = name;
            this.pattern = pattern;
            this.patchOffset = patchOffset;
            this.baseOffset = baseOffset;
        }
    }
}

