/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.ASCIIString;
import com.wudsn.thecart.common.CoreException;
import com.wudsn.thecart.common.FileUtility;
import com.wudsn.thecart.common.HexUtility;
import com.wudsn.thecart.common.Main;
import com.wudsn.thecart.common.ResourceUtility;
import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.model.CartridgeFileUtility;
import com.wudsn.thecart.model.CartridgeType;
import com.wudsn.thecart.model.CartridgeUtility;
import com.wudsn.thecart.model.ContentType;
import com.wudsn.thecart.model.FileHeaderType;
import com.wudsn.thecart.model.Platform;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;

public final class CartridgeTypeSampleCreator
extends Main {
    private File folder;
    private Map<Platform, byte[]> binaries;
    private int fileCount;

    private void writeFile(String subFolderName, String fileName, CartridgeType cartridgeType, String extension, byte[] header, byte[] content) throws CoreException {
        if (subFolderName == null) {
            throw new IllegalArgumentException("Parameter 'subFolderName' must not be null.");
        }
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'fileType' must not be null.");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 'extension' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        File subFolder = new File(this.folder, subFolderName);
        if (!subFolder.exists() && !subFolder.mkdir()) {
            throw new CoreException(Messages.E202, subFolder.getAbsolutePath());
        }
        File file = fileName == null ? new File(subFolder, String.valueOf(cartridgeType.getText()) + " (" + cartridgeType.getNumericId() + ")" + extension) : new File(subFolder, String.valueOf(fileName) + extension);
        OutputStream outputStream = FileUtility.openOutputStream(file);
        try {
            if (header != null) {
                FileUtility.writeBytes(file, outputStream, header, 0, header.length);
            }
            FileUtility.writeBytes(file, outputStream, content, 0, content.length);
        }
        finally {
            FileUtility.closeOutputStream(file, outputStream);
        }
        ++this.fileCount;
    }

    public void run(File folder) throws CoreException {
        if (folder == null) {
            throw new IllegalArgumentException("Parameter 'folder' must not be null.");
        }
        if (!(folder = folder.getAbsoluteFile()).exists()) {
            throw new CoreException(Messages.E200, folder.getAbsolutePath());
        }
        this.folder = folder;
        this.fileCount = 0;
        this.binaries = new TreeMap<Platform, byte[]>();
        for (Platform platform : Platform.getValues()) {
            String resourcePath = platform.getCartridgeTypeSampleCreatorPath();
            if (StringUtility.isEmpty(resourcePath)) continue;
            byte[] binary = ResourceUtility.loadResourceAsByteArray(resourcePath);
            if (binary == null) {
                throw new CoreException(Messages.E216, resourcePath);
            }
            this.binaries.put(platform, binary);
        }
        CartridgeTypeSampleCreator.println("Generating sample files in folder '" + folder.getAbsolutePath() + "'.");
        CartridgeType singleCartridgeType = CartridgeType.UNKNOWN;
        for (CartridgeType cartridgeType : CartridgeType.getValues()) {
            byte[] header;
            byte[] content;
            int sizeInBytes = cartridgeType.getSizeInKB() * 1024;
            if (sizeInBytes == 0 || !singleCartridgeType.equals(CartridgeType.UNKNOWN) && !cartridgeType.equals(singleCartridgeType)) continue;
            CartridgeTypeSampleCreator.println("Generating content sample files for cartridge type '" + cartridgeType.getText() + " (" + cartridgeType.getNumericId() + ")'.");
            if (cartridgeType != CartridgeType.CARTRIDGE_THECART_128M) {
                String context = "ROM-Correct";
                content = this.createContent(cartridgeType, FileHeaderType.NONE, sizeInBytes, true, context);
                header = null;
                this.writeFile(context, null, cartridgeType, ".rom", header, content);
                context = "ROM-Correct";
                content = this.createContent(cartridgeType, FileHeaderType.NONE, sizeInBytes - 1, false, context);
                this.writeFile(context, null, cartridgeType, ".rom", header, content);
                context = "ROM-Too-Large";
                content = this.createContent(cartridgeType, FileHeaderType.NONE, sizeInBytes + 1, true, context);
                this.writeFile(context, null, cartridgeType, ".rom", header, content);
                context = "CAR-Correct";
                int cartridgeTypeNumericId = cartridgeType.getNumericId();
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, context);
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
                this.writeFile(context, null, cartridgeType, ".car", header, content);
                ContentType contentType = ContentType.getInstance(cartridgeType.getId());
                if (contentType == null) {
                    throw new RuntimeException("No content type defined for cartridge type '" + cartridgeType.getId() + "'.");
                }
                if (contentType.getTheCartMode() != 0) {
                    context = "CAR-Correct-Supported";
                    content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, context);
                    header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
                    this.writeFile(context, null, cartridgeType, ".car", header, content);
                }
                context = "CAR-Size-Too-Small";
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes - 1, false, context);
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
                this.writeFile(context, null, cartridgeType, ".car", header, content);
                context = "CAR-Size-Too-Large";
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes + 1, true, context);
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
                this.writeFile(context, null, cartridgeType, ".car", header, content);
                context = "CAR-Wrong-Header";
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, context);
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
                content[3] = 90;
                this.writeFile(context, null, cartridgeType, ".car", header, content);
                context = "CAR-CartridgeType-Too-Small";
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, context);
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(-1, content);
                this.writeFile(context, null, cartridgeType, ".car", header, content);
                context = "CAR-CartridgeType-Too-Large";
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, context);
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(Integer.MAX_VALUE, content);
                this.writeFile(context, null, cartridgeType, ".car", header, content);
                content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, "Wrong");
                header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
                content[8] = (byte)(content[8] + 1);
                this.writeFile("CAR-Wrong-Checksum", null, cartridgeType, ".car", header, content);
                continue;
            }
            int cartridgeTypeNumericId = cartridgeType.getNumericId();
            String context = "ROM-Correct";
            content = this.createContent(cartridgeType, FileHeaderType.NONE, sizeInBytes, true, context);
            header = null;
            this.writeFile(context, null, cartridgeType, ".rom", header, content);
            context = "CAR-Correct";
            content = this.createContent(cartridgeType, FileHeaderType.CART, sizeInBytes, true, context);
            header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeTypeNumericId, content);
            this.writeFile(context, null, cartridgeType, ".car", header, content);
        }
        if (singleCartridgeType.equals(CartridgeType.UNKNOWN)) {
            this.writeNumberSamples("CAR-Correct-Small", CartridgeType.CARTRIDGE_STD_8, FileHeaderType.CART, "ROM", 16385);
            this.writeNumberSamples("CAR-Correct-Large", CartridgeType.CARTRIDGE_ATMAX_1024, FileHeaderType.CART, "ROM", 129);
            this.writeNumberSamples("ROM-Correct-Small-Atarimax", CartridgeType.CARTRIDGE_STD_8, FileHeaderType.NONE, "Atarimax ROM", 127);
            this.writeNumberSamples("ROM-Correct-Small-MegaCart", CartridgeType.CARTRIDGE_STD_16, FileHeaderType.NONE, "MegaCart ROM", 127);
        }
        CartridgeTypeSampleCreator.println(String.valueOf(this.fileCount) + " sample files created in the sub-folders of '" + folder.getAbsolutePath() + "'.");
    }

    private void writeNumberSamples(String subFolderName, CartridgeType cartridgeType, FileHeaderType fileHeaderType, String prefix, int totalNumber) throws CoreException {
        if (subFolderName == null) {
            throw new IllegalArgumentException("Parameter 'subFolderName' must not be null.");
        }
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        if (fileHeaderType == null) {
            throw new IllegalArgumentException("Parameter 'fileHeaderType' must not be null.");
        }
        CartridgeTypeSampleCreator.println("Generating " + totalNumber + " number sample files for cartridge type '" + cartridgeType.getText() + " (" + cartridgeType.getNumericId() + ")' with file header type '" + fileHeaderType.getText() + "'.");
        String totalNumberString = Integer.toString(totalNumber);
        int digits = totalNumberString.length();
        int i = 0;
        while (i < totalNumber) {
            StringBuilder numberStringBuilder = new StringBuilder(Integer.toString(i + 1));
            while (numberStringBuilder.length() < digits) {
                numberStringBuilder.insert(0, '0');
            }
            String numberString = numberStringBuilder.toString();
            String fileName = String.valueOf(prefix) + "-" + numberString;
            String title = String.valueOf(fileName) + "/" + totalNumberString;
            byte[] content = this.createContent(cartridgeType, fileHeaderType, cartridgeType.getSizeInKB() * 1024, true, title);
            if (fileHeaderType.equals(FileHeaderType.CART)) {
                byte[] header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeType.getNumericId(), content);
                this.writeFile(subFolderName, fileName, cartridgeType, ".car", header, content);
            } else {
                this.writeFile(subFolderName, fileName, cartridgeType, ".rom", null, content);
            }
            ++i;
        }
    }

    private byte[] createContent(CartridgeType cartridgeType, FileHeaderType fileHeaderType, int sizeInBytes, boolean withVectors, String title) {
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        if (fileHeaderType == null) {
            throw new IllegalArgumentException("Parameter 'fileHeaderType' must not be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        int startBankOffset = cartridgeType.getInitialBankOffset();
        int bankSize = cartridgeType.getBankSize();
        int startAddress = cartridgeType.getInitialBankAddress();
        byte[] content = new byte[sizeInBytes];
        byte[] binary = this.binaries.get(cartridgeType.getPlatform());
        if (binary == null) {
            throw new RuntimeException("No binary for platform '" + cartridgeType + "'.");
        }
        System.arraycopy(binary, 0, content, startBankOffset, binary.length);
        int screenWidth = 40;
        String typeInfo = String.valueOf(cartridgeType.getText()) + " (" + cartridgeType.getNumericId() + ")/" + fileHeaderType.getText() + "/" + sizeInBytes + "B";
        String bankInfo = "Bank:" + cartridgeType.getBankSize() + "B Initial:" + cartridgeType.getInitialBankNumber() + " Address:$" + HexUtility.getLongValueHexString(cartridgeType.getInitialBankAddress());
        byte[] titleBytes = ASCIIString.getBytesCentered(title, screenWidth);
        byte[] typeInfoBytes = ASCIIString.getBytesCentered(typeInfo, screenWidth);
        byte[] bankInfoBytes = ASCIIString.getBytesCentered(bankInfo, screenWidth);
        System.arraycopy(titleBytes, 0, content, startBankOffset + 4 + screenWidth * 0, titleBytes.length);
        System.arraycopy(typeInfoBytes, 0, content, startBankOffset + 4 + screenWidth * 1, typeInfoBytes.length);
        System.arraycopy(bankInfoBytes, 0, content, startBankOffset + 4 + screenWidth * 2, bankInfoBytes.length);
        content[startBankOffset + 1] = (byte)(startAddress / 256);
        if (withVectors) {
            CartridgeUtility.setCartridgeVectors(content, startBankOffset, bankSize, 0, startAddress, 0);
        }
        if (cartridgeType == CartridgeType.CARTRIDGE_ATRAX_SDX_64 || cartridgeType == CartridgeType.CARTRIDGE_ATRAX_SDX_128) {
            content = this.createInterleavedAtraxSDXContent(content);
        }
        return content;
    }

    private byte[] createInterleavedAtraxSDXContent(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        byte[] result = new byte[content.length];
        int a0 = 0;
        while (a0 < content.length) {
            byte b0 = content[a0];
            int a0_6 = a0 >>> 0 & 1;
            int a0_7 = a0 >>> 1 & 1;
            int a0_12 = a0 >>> 2 & 1;
            int a0_15 = a0 >>> 3 & 1;
            int a0_14 = a0 >>> 4 & 1;
            int a0_13 = a0 >>> 5 & 1;
            int a0_8 = a0 >>> 6 & 1;
            int a0_5 = a0 >>> 7 & 1;
            int a0_4 = a0 >>> 8 & 1;
            int a0_3 = a0 >>> 9 & 1;
            int a0_0 = a0 >>> 10 & 1;
            int a0_1 = a0 >>> 11 & 1;
            int a0_2 = a0 >>> 12 & 1;
            int a0_9 = a0 >>> 13 & 1;
            int a0_11 = a0 >>> 14 & 1;
            int a0_10 = a0 >>> 15 & 1;
            int a0_16 = a0 >>> 16 & 1;
            int b0_4 = b0 >>> 0 & 1;
            int b0_0 = b0 >>> 1 & 1;
            int b0_5 = b0 >>> 2 & 1;
            int b0_1 = b0 >>> 3 & 1;
            int b0_7 = b0 >>> 4 & 1;
            int b0_6 = b0 >>> 5 & 1;
            int b0_3 = b0 >>> 6 & 1;
            int b0_2 = b0 >>> 7 & 1;
            int a1 = 0;
            a1 |= a0_0 * 1;
            a1 |= a0_1 * 2;
            a1 |= a0_2 * 4;
            a1 |= a0_3 * 8;
            a1 |= a0_4 * 16;
            a1 |= a0_5 * 32;
            a1 |= a0_6 * 64;
            a1 |= a0_7 * 128;
            a1 |= a0_8 * 256;
            a1 |= a0_9 * 512;
            a1 |= a0_10 * 1024;
            a1 |= a0_11 * 2048;
            a1 |= a0_12 * 4096;
            a1 |= a0_13 * 8192;
            a1 |= a0_14 * 16384;
            a1 |= a0_15 * 32768;
            a1 |= a0_16 * 65536;
            a1 &= 0x1FFFF;
            int b1 = 0;
            b1 |= b0_0 * 1;
            b1 |= b0_1 * 2;
            b1 |= b0_2 * 4;
            b1 |= b0_3 * 8;
            b1 |= b0_4 * 16;
            b1 |= b0_5 * 32;
            b1 |= b0_6 * 64;
            b1 |= b0_7 * 128;
            result[a1] = (byte)(b1 &= 0xFF);
            ++a0;
        }
        return result;
    }
}

