/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

public final class CartridgeUtility {
    public static final int CARTCS_OSSET = -6;
    public static final int CART_OFFSET = -4;
    public static final int CARTFG_OFFSET = -3;
    public static final byte CARTFG_DIAGNOSTIC_CART = -128;
    public static final byte CARTFG_START_CART = 4;
    public static final byte CARTFG_BOOT = 1;
    public static final int CARTAD_OFFSET = -2;

    private CartridgeUtility() {
    }

    public static void setCartridgeVectors(byte[] content, int startBankOffset, int startBankSize, int flags, int initAddress, int startAddress) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (startBankOffset < 0) {
            throw new IllegalArgumentException("Parameter 'startBankOffset' must not be negative. Specified value is " + startBankOffset + ".");
        }
        if (startBankSize < 0) {
            throw new IllegalArgumentException("Parameter 'startBankSize' must not be negative. Specified value is " + startBankSize + ".");
        }
        int startBankEndOffset = startBankOffset + startBankSize;
        if (initAddress < 16384 || initAddress > 49151) {
            throw new IllegalArgumentException("Parameter 'initAddress' must be between 0x8000 and 0xbfff. Specified value is " + Integer.toHexString(initAddress) + ".");
        }
        if (startAddress != 0 && (startAddress < 16384 || startAddress > 49151)) {
            throw new IllegalArgumentException("Parameter 'startAddress' must be between 0x8000 and 0xbfff. Specified value is " + Integer.toHexString(startAddress) + ".");
        }
        try {
            content[startBankEndOffset + -6] = (byte)(startAddress & 0xFF);
            content[startBankEndOffset + -6 + 1] = (byte)(startAddress >> 8 & 0xFF);
            content[startBankEndOffset + -4] = 0;
            content[startBankEndOffset + -3] = (byte)(flags & 0xFF);
            content[startBankEndOffset + -2] = (byte)(initAddress & 0xFF);
            content[startBankEndOffset + -2 + 1] = (byte)(initAddress >> 8 & 0xFF);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RuntimeException(ex);
        }
    }
}

