/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.DataTypes;
import com.wudsn.thecart.model.CartridgeType;
import com.wudsn.thecart.repository.Attribute;
import com.wudsn.thecart.repository.ValueSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ContentType
extends ValueSet {
    public static final ContentType UNKNOWN;
    public static final ContentType CARTRIDGE_STD_8;
    public static final ContentType CARTRIDGE_STD_16;
    public static final ContentType CARTRIDGE_OSS_034M_16;
    public static final ContentType CARTRIDGE_5200_32;
    public static final ContentType CARTRIDGE_DB_32;
    public static final ContentType CARTRIDGE_5200_EE_16;
    public static final ContentType CARTRIDGE_5200_40;
    public static final ContentType CARTRIDGE_WILL_64;
    public static final ContentType CARTRIDGE_EXP_64;
    public static final ContentType CARTRIDGE_DIAMOND_64;
    public static final ContentType CARTRIDGE_SDX_64;
    public static final ContentType CARTRIDGE_XEGS_32;
    public static final ContentType CARTRIDGE_XEGS_64;
    public static final ContentType CARTRIDGE_XEGS_128;
    public static final ContentType CARTRIDGE_OSS_M091_16;
    public static final ContentType CARTRIDGE_5200_NS_16;
    public static final ContentType CARTRIDGE_ATRAX_128;
    public static final ContentType CARTRIDGE_BBSB_40;
    public static final ContentType CARTRIDGE_5200_8;
    public static final ContentType CARTRIDGE_5200_4;
    public static final ContentType CARTRIDGE_RIGHT_8;
    public static final ContentType CARTRIDGE_WILL_32;
    public static final ContentType CARTRIDGE_XEGS_256;
    public static final ContentType CARTRIDGE_XEGS_512;
    public static final ContentType CARTRIDGE_XEGS_1024;
    public static final ContentType CARTRIDGE_MEGA_16;
    public static final ContentType CARTRIDGE_MEGA_32;
    public static final ContentType CARTRIDGE_MEGA_64;
    public static final ContentType CARTRIDGE_MEGA_128;
    public static final ContentType CARTRIDGE_MEGA_256;
    public static final ContentType CARTRIDGE_MEGA_512;
    public static final ContentType CARTRIDGE_MEGA_1024;
    public static final ContentType CARTRIDGE_SWXEGS_32;
    public static final ContentType CARTRIDGE_SWXEGS_64;
    public static final ContentType CARTRIDGE_SWXEGS_128;
    public static final ContentType CARTRIDGE_SWXEGS_256;
    public static final ContentType CARTRIDGE_SWXEGS_512;
    public static final ContentType CARTRIDGE_SWXEGS_1024;
    public static final ContentType CARTRIDGE_PHOENIX_8;
    public static final ContentType CARTRIDGE_BLIZZARD_16;
    public static final ContentType CARTRIDGE_ATMAX_128;
    public static final ContentType CARTRIDGE_ATMAX_1024;
    public static final ContentType CARTRIDGE_SDX_128;
    public static final ContentType CARTRIDGE_OSS_8;
    public static final ContentType CARTRIDGE_OSS_043M_16;
    public static final ContentType CARTRIDGE_BLIZZARD_4;
    public static final ContentType CARTRIDGE_AST_32;
    public static final ContentType CARTRIDGE_ATRAX_SDX_64;
    public static final ContentType CARTRIDGE_ATRAX_SDX_128;
    public static final ContentType CARTRIDGE_TURBOSOFT_64;
    public static final ContentType CARTRIDGE_TURBOSOFT_128;
    public static final ContentType CARTRIDGE_ULTRACART_32;
    public static final ContentType CARTRIDGE_LOW_BANK_8;
    public static final ContentType CARTRIDGE_SIC_128;
    public static final ContentType CARTRIDGE_SIC_256;
    public static final ContentType CARTRIDGE_SIC_512;
    public static final ContentType CARTRIDGE_STD_2;
    public static final ContentType CARTRIDGE_STD_4;
    public static final ContentType CARTRIDGE_RIGHT_4;
    public static final ContentType CARTRIDGE_BLIZZARD_32;
    public static final ContentType CARTRIDGE_MEGAMAX_2048;
    public static final ContentType CARTRIDGE_THECART_8;
    public static final ContentType CARTRIDGE_THECART_128M;
    public static final ContentType CARTRIDGE_MEGA_4096;
    public static final ContentType CARTRIDGE_MEGA_2048;
    public static final ContentType CARTRIDGE_THECART_32M;
    public static final ContentType CARTRIDGE_THECART_64M;
    public static final ContentType FILE_ATR;
    public static final ContentType FILE_BINARY;
    public static final ContentType FILE_EXECUTABLE;
    private static final Map<String, ContentType> values;
    private CartridgeType cartridgeType;
    private int theCartMode;

    static {
        values = new TreeMap<String, ContentType>();
        UNKNOWN = ContentType.add("UNKNOWN", CartridgeType.UNKNOWN, 0);
        CARTRIDGE_STD_8 = ContentType.add("CARTRIDGE_STD_8", CartridgeType.CARTRIDGE_STD_8, 1);
        CARTRIDGE_STD_16 = ContentType.add("CARTRIDGE_STD_16", CartridgeType.CARTRIDGE_STD_16, 33);
        CARTRIDGE_OSS_034M_16 = ContentType.add("CARTRIDGE_OSS_034M_16", CartridgeType.CARTRIDGE_OSS_034M_16, 0);
        CARTRIDGE_5200_32 = ContentType.add("CARTRIDGE_5200_32", CartridgeType.CARTRIDGE_5200_32, 0);
        CARTRIDGE_DB_32 = ContentType.add("CARTRIDGE_DB_32", CartridgeType.CARTRIDGE_DB_32, 0);
        CARTRIDGE_5200_EE_16 = ContentType.add("CARTRIDGE_5200_EE_16", CartridgeType.CARTRIDGE_5200_EE_16, 0);
        CARTRIDGE_5200_40 = ContentType.add("CARTRIDGE_5200_40", CartridgeType.CARTRIDGE_5200_40, 0);
        CARTRIDGE_WILL_64 = ContentType.add("CARTRIDGE_WILL_64", CartridgeType.CARTRIDGE_WILL_64, 13);
        CARTRIDGE_EXP_64 = ContentType.add("CARTRIDGE_EXP_64", CartridgeType.CARTRIDGE_EXP_64, 10);
        CARTRIDGE_DIAMOND_64 = ContentType.add("CARTRIDGE_DIAMOND_64", CartridgeType.CARTRIDGE_DIAMOND_64, 9);
        CARTRIDGE_SDX_64 = ContentType.add("CARTRIDGE_SDX_64", CartridgeType.CARTRIDGE_SDX_64, 8);
        CARTRIDGE_XEGS_32 = ContentType.add("CARTRIDGE_XEGS_32", CartridgeType.CARTRIDGE_XEGS_32, 56);
        CARTRIDGE_XEGS_64 = ContentType.add("CARTRIDGE_XEGS_64", CartridgeType.CARTRIDGE_XEGS_64, 49);
        CARTRIDGE_XEGS_128 = ContentType.add("CARTRIDGE_XEGS_128", CartridgeType.CARTRIDGE_XEGS_128, 50);
        CARTRIDGE_OSS_M091_16 = ContentType.add("CARTRIDGE_OSS_M091_16", CartridgeType.CARTRIDGE_OSS_M091_16, 4);
        CARTRIDGE_5200_NS_16 = ContentType.add("CARTRIDGE_5200_NS_16", CartridgeType.CARTRIDGE_5200_NS_16, 0);
        CARTRIDGE_ATRAX_128 = ContentType.add("CARTRIDGE_ATRAX_128", CartridgeType.CARTRIDGE_ATRAX_128, 12);
        CARTRIDGE_BBSB_40 = ContentType.add("CARTRIDGE_BBSB_40", CartridgeType.CARTRIDGE_BBSB_40, 0);
        CARTRIDGE_5200_8 = ContentType.add("CARTRIDGE_5200_8", CartridgeType.CARTRIDGE_5200_8, 0);
        CARTRIDGE_5200_4 = ContentType.add("CARTRIDGE_5200_4", CartridgeType.CARTRIDGE_5200_4, 0);
        CARTRIDGE_RIGHT_8 = ContentType.add("CARTRIDGE_RIGHT_8", CartridgeType.CARTRIDGE_RIGHT_8, 241);
        CARTRIDGE_WILL_32 = ContentType.add("CARTRIDGE_WILL_32", CartridgeType.CARTRIDGE_WILL_32, 0);
        CARTRIDGE_XEGS_256 = ContentType.add("CARTRIDGE_XEGS_256", CartridgeType.CARTRIDGE_XEGS_256, 51);
        CARTRIDGE_XEGS_512 = ContentType.add("CARTRIDGE_XEGS_512", CartridgeType.CARTRIDGE_XEGS_512, 52);
        CARTRIDGE_XEGS_1024 = ContentType.add("CARTRIDGE_XEGS_1024", CartridgeType.CARTRIDGE_XEGS_1024, 53);
        CARTRIDGE_MEGA_16 = ContentType.add("CARTRIDGE_MEGA_16", CartridgeType.CARTRIDGE_MEGA_16, 40);
        CARTRIDGE_MEGA_32 = ContentType.add("CARTRIDGE_MEGA_32", CartridgeType.CARTRIDGE_MEGA_32, 41);
        CARTRIDGE_MEGA_64 = ContentType.add("CARTRIDGE_MEGA_64", CartridgeType.CARTRIDGE_MEGA_64, 42);
        CARTRIDGE_MEGA_128 = ContentType.add("CARTRIDGE_MEGA_128", CartridgeType.CARTRIDGE_MEGA_128, 43);
        CARTRIDGE_MEGA_256 = ContentType.add("CARTRIDGE_MEGA_256", CartridgeType.CARTRIDGE_MEGA_256, 44);
        CARTRIDGE_MEGA_512 = ContentType.add("CARTRIDGE_MEGA_512", CartridgeType.CARTRIDGE_MEGA_512, 45);
        CARTRIDGE_MEGA_1024 = ContentType.add("CARTRIDGE_MEGA_1024", CartridgeType.CARTRIDGE_MEGA_1024, 46);
        CARTRIDGE_SWXEGS_32 = ContentType.add("CARTRIDGE_SWXEGS_32", CartridgeType.CARTRIDGE_SWXEGS_32, 56);
        CARTRIDGE_SWXEGS_64 = ContentType.add("CARTRIDGE_SWXEGS_64", CartridgeType.CARTRIDGE_SWXEGS_64, 57);
        CARTRIDGE_SWXEGS_128 = ContentType.add("CARTRIDGE_SWXEGS_128", CartridgeType.CARTRIDGE_SWXEGS_128, 58);
        CARTRIDGE_SWXEGS_256 = ContentType.add("CARTRIDGE_SWXEGS_256", CartridgeType.CARTRIDGE_SWXEGS_256, 59);
        CARTRIDGE_SWXEGS_512 = ContentType.add("CARTRIDGE_SWXEGS_512", CartridgeType.CARTRIDGE_SWXEGS_512, 60);
        CARTRIDGE_SWXEGS_1024 = ContentType.add("CARTRIDGE_SWXEGS_1024", CartridgeType.CARTRIDGE_SWXEGS_1024, 61);
        CARTRIDGE_PHOENIX_8 = ContentType.add("CARTRIDGE_PHOENIX_8", CartridgeType.CARTRIDGE_PHOENIX_8, 0);
        CARTRIDGE_BLIZZARD_16 = ContentType.add("CARTRIDGE_BLIZZARD_16", CartridgeType.CARTRIDGE_BLIZZARD_16, 35);
        CARTRIDGE_ATMAX_128 = ContentType.add("CARTRIDGE_ATMAX_128", CartridgeType.CARTRIDGE_ATMAX_128, 2);
        CARTRIDGE_ATMAX_1024 = ContentType.add("CARTRIDGE_ATMAX_1024", CartridgeType.CARTRIDGE_ATMAX_1024, 3);
        CARTRIDGE_SDX_128 = ContentType.add("CARTRIDGE_SDX_128", CartridgeType.CARTRIDGE_SDX_128, 0);
        CARTRIDGE_OSS_8 = ContentType.add("CARTRIDGE_OSS_8", CartridgeType.CARTRIDGE_OSS_8, 0);
        CARTRIDGE_OSS_043M_16 = ContentType.add("CARTRIDGE_OSS_043M_16", CartridgeType.CARTRIDGE_OSS_043M_16, 0);
        CARTRIDGE_BLIZZARD_4 = ContentType.add("CARTRIDGE_BLIZZARD_4", CartridgeType.CARTRIDGE_BLIZZARD_4, 0);
        CARTRIDGE_AST_32 = ContentType.add("CARTRIDGE_AST_32", CartridgeType.CARTRIDGE_AST_32, 0);
        CARTRIDGE_ATRAX_SDX_64 = ContentType.add("CARTRIDGE_ATRAX_SDX_64", CartridgeType.CARTRIDGE_ATRAX_SDX_64, 0);
        CARTRIDGE_ATRAX_SDX_128 = ContentType.add("CARTRIDGE_ATRAX_SDX_128", CartridgeType.CARTRIDGE_ATRAX_SDX_128, 0);
        CARTRIDGE_TURBOSOFT_64 = ContentType.add("CARTRIDGE_TURBOSOFT_64", CartridgeType.CARTRIDGE_TURBOSOFT_64, 0);
        CARTRIDGE_TURBOSOFT_128 = ContentType.add("CARTRIDGE_TURBOSOFT_128", CartridgeType.CARTRIDGE_TURBOSOFT_128, 0);
        CARTRIDGE_ULTRACART_32 = ContentType.add("CARTRIDGE_ULTRACART_32", CartridgeType.CARTRIDGE_ULTRACART_32, 0);
        CARTRIDGE_LOW_BANK_8 = ContentType.add("CARTRIDGE_LOW_BANK_8", CartridgeType.CARTRIDGE_LOW_BANK_8, 0);
        CARTRIDGE_SIC_128 = ContentType.add("CARTRIDGE_SIC_128", CartridgeType.CARTRIDGE_SIC_128, 0);
        CARTRIDGE_SIC_256 = ContentType.add("CARTRIDGE_SIC_256", CartridgeType.CARTRIDGE_SIC_256, 0);
        CARTRIDGE_SIC_512 = ContentType.add("CARTRIDGE_SIC_512", CartridgeType.CARTRIDGE_SIC_512, 36);
        CARTRIDGE_STD_2 = ContentType.add("CARTRIDGE_STD_2", CartridgeType.CARTRIDGE_STD_2, 0);
        CARTRIDGE_STD_4 = ContentType.add("CARTRIDGE_STD_4", CartridgeType.CARTRIDGE_STD_4, 0);
        CARTRIDGE_RIGHT_4 = ContentType.add("CARTRIDGE_RIGHT_4", CartridgeType.CARTRIDGE_RIGHT_4, 0);
        CARTRIDGE_BLIZZARD_32 = ContentType.add("CARTRIDGE_BLIZZARD_32", CartridgeType.CARTRIDGE_BLIZZARD_32, 0);
        CARTRIDGE_MEGAMAX_2048 = ContentType.add("CARTRIDGE_MEGAMAX_2048", CartridgeType.CARTRIDGE_MEGAMAX_2048, 34);
        CARTRIDGE_THECART_8 = ContentType.add("CARTRIDGE_THECART_8", CartridgeType.CARTRIDGE_STD_8, 240);
        CARTRIDGE_THECART_128M = ContentType.add("CARTRIDGE_THECART_128M", CartridgeType.CARTRIDGE_THECART_128M, 0);
        CARTRIDGE_MEGA_4096 = ContentType.add("CARTRIDGE_MEGA_4096", CartridgeType.CARTRIDGE_MEGA_4096, 0);
        CARTRIDGE_MEGA_2048 = ContentType.add("CARTRIDGE_MEGA_2048", CartridgeType.CARTRIDGE_MEGA_2048, 47);
        CARTRIDGE_THECART_32M = ContentType.add("CARTRIDGE_THECART_32M", CartridgeType.CARTRIDGE_THECART_32M, 0);
        CARTRIDGE_THECART_64M = ContentType.add("CARTRIDGE_THECART_64M", CartridgeType.CARTRIDGE_THECART_32M, 0);
        FILE_BINARY = ContentType.add("FILE_BINARY", CartridgeType.UNKNOWN, 224);
        FILE_EXECUTABLE = ContentType.add("FILE_EXECUTABLE", CartridgeType.UNKNOWN, 225);
        FILE_ATR = ContentType.add("FILE_ATR", CartridgeType.UNKNOWN, 226);
        ContentType.initializeClass(ContentType.class);
    }

    private ContentType(String id, CartridgeType cartridgeType, int theCartMode) {
        super(id, 0);
        this.cartridgeType = cartridgeType;
        this.theCartMode = theCartMode;
    }

    private static ContentType add(String id, CartridgeType cartridgeType, int theCartMode) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        ContentType result = new ContentType(id, cartridgeType, theCartMode);
        values.put(id, result);
        return result;
    }

    public static List<ContentType> getValues() {
        return Collections.unmodifiableList(new ArrayList<ContentType>(values.values()));
    }

    public static ContentType getInstance(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        return values.get(id);
    }

    public static ContentType getInstanceByCartridgeType(int cartridgeTypeNumericId) {
        ContentType result = UNKNOWN;
        if (cartridgeTypeNumericId != CartridgeType.UNKNOWN.getNumericId()) {
            for (ContentType contentType : values.values()) {
                if (contentType.getCartridgeType().getNumericId() != cartridgeTypeNumericId) continue;
                return contentType;
            }
        }
        return result;
    }

    public CartridgeType getCartridgeType() {
        return this.cartridgeType;
    }

    public int getTheCartMode() {
        return this.theCartMode;
    }

    public static final class Attributes {
        public static final Attribute TEXT = new Attribute("text", DataTypes.ContentType_Text);
        public static final Attribute ID = new Attribute("id", DataTypes.ContentType_Id);
        public static final Attribute SIZE = new Attribute("size", DataTypes.ContentType_Size);
        public static final Attribute CARTRIDGE_TYPE_NUMERIC_ID = new Attribute("cartridgeTypeNumericId", DataTypes.ContentType_CartridgeTypeNumericId);
        public static final Attribute THE_CART_MODE = new Attribute("theCartMode", DataTypes.ContentType_TheCartMode);
        public static final Attribute BANK_SIZE = new Attribute("bankSize", DataTypes.CartridgeType_BankSize);
        public static final Attribute INITIAL_BANK_NUMBER = new Attribute("initialBankNumber", DataTypes.CartridgeType_InitialBankNumber);

        private Attributes() {
        }
    }
}

