/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.CoreException;
import com.wudsn.thecart.common.FileUtility;
import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.model.AtrProgrammingFile;
import com.wudsn.thecart.model.CartridgeFileUtility;
import com.wudsn.thecart.model.maxflash.MaxflashImporter;
import java.io.File;
import java.io.OutputStream;

final class Importer {
    Importer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImportResult autoConvertFile(File file, MessageQueue messageQueue) {
        long fileLength;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        ImportResult result = new ImportResult();
        MaxflashImporter maxflashImporter = new MaxflashImporter();
        String fileName = file.getName();
        if (!maxflashImporter.isRelevant(fileName, fileLength = file.length())) return result;
        File sourceFile = file;
        File targetFile = new File(sourceFile.getParentFile(), String.valueOf(fileName.substring(0, fileName.length() - ".atr".length())) + ".car");
        try {
            AtrProgrammingFile atrProgrammingFile = new AtrProgrammingFile(file);
            try {
                if (!atrProgrammingFile.loadHeadersAndBootCode()) {
                    throw new CoreException(Messages.I500, atrProgrammingFile.getSourceFilePath());
                }
                maxflashImporter.determineCartridgeTypeAndBuild(atrProgrammingFile);
                if (atrProgrammingFile.getCartridgeType() == null) {
                    ImportResult importResult = result;
                    return importResult;
                }
                AtrProgrammingFile.BuildInfo buildInfo = atrProgrammingFile.getBuildInfo();
                if (buildInfo == null) {
                    throw new CoreException(Messages.I501, atrProgrammingFile.getSourceFilePath());
                }
                if (buildInfo.mode == 1) {
                    throw new CoreException(Messages.E502, buildInfo.signature, atrProgrammingFile.getSourceFilePath());
                }
                byte[] cartridgeContent = maxflashImporter.createCartridgeContent(atrProgrammingFile);
                byte[] cartridgeHeader = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(atrProgrammingFile.getCartridgeType().getNumericId(), cartridgeContent);
                OutputStream outputStream = null;
                try {
                    outputStream = FileUtility.openOutputStream(targetFile);
                    FileUtility.writeBytes(targetFile, outputStream, cartridgeHeader, 0, cartridgeHeader.length);
                    FileUtility.writeBytes(targetFile, outputStream, cartridgeContent, 0, cartridgeContent.length);
                    result.convertedFile = targetFile;
                    return result;
                }
                finally {
                    try {
                        if (outputStream != null) {
                            FileUtility.closeOutputStream(targetFile, outputStream);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
            finally {
                atrProgrammingFile.close();
            }
        }
        catch (CoreException ex) {
            result.convertedFileException = ex;
        }
        return result;
    }

    public static final class ImportResult {
        public File convertedFile;
        public CoreException convertedFileException;
    }
}

