/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.model;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.model.WorkbookGenre;
import com.wudsn.thecart.model.WorkbookRoot;
import com.wudsn.thecart.repository.RepositoryValidation;

public final class WorkbookGenreValidation {
    public static final WorkbookGenreValidation createInstance() {
        return new WorkbookGenreValidation();
    }

    public void validateSave(WorkbookRoot root, WorkbookGenre genre, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (genre == null) {
            throw new IllegalArgumentException("Parameter 'genre' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
        String name = genre.getName();
        if (StringUtility.isSpecified(name)) {
            if (name.equalsIgnoreCase("All")) {
                messageQueue.sendMessage(genre, WorkbookGenre.Attributes.NAME, Messages.E426, "All");
            } else {
                rv.isStringValid(genre, WorkbookGenre.Attributes.NAME, genre.getName());
            }
        }
    }

    public void validateExport(WorkbookRoot root, WorkbookGenre genre, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (genre == null) {
            throw new IllegalArgumentException("Parameter 'genre' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
    }
}

