/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.repository;

import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.common.TextUtility;

public final class Message {
    public static final int STATUS = 1;
    public static final int INFO = 2;
    public static final int ERROR = 3;
    private String id;
    private int severity;
    private String shortText;

    Message(String id, int severity, String shortText) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        if (StringUtility.isEmpty(id)) {
            throw new IllegalArgumentException("Parameter 'id' must not be empty.");
        }
        switch (severity) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter 'severity' has illegal value " + severity + ".");
            }
        }
        if (shortText == null) {
            throw new IllegalArgumentException("Parameter 'shortText' must not be null.");
        }
        if (StringUtility.isEmpty(shortText)) {
            throw new IllegalArgumentException("Parameter 'shortText' must not be empty.");
        }
        this.id = id;
        this.severity = severity;
        this.shortText = shortText;
    }

    public String getId() {
        return this.id;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String toString() {
        switch (this.severity) {
            case 2: {
                return "INFO: " + this.shortText;
            }
            case 3: {
                return "ERROR: " + this.shortText;
            }
        }
        throw new IllegalStateException("Field 'severity' has illegal value " + this.severity + ".");
    }

    public String format(String ... parameters) {
        return TextUtility.format(this.shortText, parameters);
    }
}

