/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.repository;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.MessageQueue;
import com.wudsn.thecart.common.StringUtility;
import com.wudsn.thecart.common.TextUtility;
import com.wudsn.thecart.repository.Attribute;

public final class RepositoryValidation {
    private MessageQueue messageQueue;

    private RepositoryValidation() {
    }

    public static RepositoryValidation createInstance(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        RepositoryValidation result = new RepositoryValidation();
        result.messageQueue = messageQueue;
        return result;
    }

    public boolean isStringSpecified(Object owner, Attribute attribute, String stringValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (StringUtility.isEmpty(stringValue)) {
            this.messageQueue.sendMessage(owner, attribute, Messages.E300, attribute.getDataType().getLabelWithoutMnemonics());
            return false;
        }
        return true;
    }

    public boolean isStringDefined(Object owner, Attribute attribute, String stringValue, boolean defined) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (StringUtility.isSpecified(stringValue) && !defined) {
            this.messageQueue.sendMessage(owner, attribute, Messages.E301, attribute.getDataType().getLabelWithoutMnemonics(), stringValue);
            return false;
        }
        return true;
    }

    public boolean isStringValid(Object owner, Attribute attribute, String stringValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (!this.isStringSpecified(owner, attribute, stringValue)) {
            return false;
        }
        int maximumLength = attribute.getDataType().getMaximumLength();
        if (stringValue.length() > maximumLength) {
            this.messageQueue.sendMessage(owner, attribute, Messages.E302, attribute.getDataType().getLabelWithoutMnemonics(), TextUtility.formatAsDecimal(stringValue.length()), TextUtility.formatAsDecimal(maximumLength));
            return false;
        }
        String allowedCharacters = attribute.getDataType().getAllowedCharacters();
        if (allowedCharacters != null) {
            int i = 0;
            while (i < stringValue.length()) {
                char c = stringValue.charAt(i);
                if (allowedCharacters.indexOf(c) < 0) {
                    this.messageQueue.sendMessage(owner, attribute, Messages.E303, attribute.getDataType().getLabelWithoutMnemonics(), Character.toString(c), TextUtility.formatAsDecimal(i + 1), allowedCharacters);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isLongValid(Object owner, Attribute attribute, long minimumValue, long maximumValue, long longValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (longValue < minimumValue || longValue > maximumValue) {
            this.messageQueue.sendMessage(owner, attribute, Messages.E304, attribute.getDataType().getLabelWithoutMnemonics(), TextUtility.formatAsDecimal(longValue), TextUtility.formatAsDecimal(minimumValue), TextUtility.formatAsDecimal(maximumValue));
            return false;
        }
        return true;
    }

    public boolean isMemorySizeValid(Object owner, Attribute attribute, long minimumValue, long maximumValue, long longValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (longValue < minimumValue || longValue > maximumValue) {
            this.messageQueue.sendMessage(owner, attribute, Messages.E304, attribute.getDataType().getLabelWithoutMnemonics(), TextUtility.formatAsMemorySize(longValue), TextUtility.formatAsDecimal(minimumValue), TextUtility.formatAsMemorySize(maximumValue));
            return false;
        }
        return true;
    }
}

