/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.thecart.ui;

import com.wudsn.thecart.Messages;
import com.wudsn.thecart.common.TextUtility;
import com.wudsn.thecart.model.Workbook;
import com.wudsn.thecart.model.WorkbookBanksSummary;
import com.wudsn.thecart.model.WorkbookRoot;
import com.wudsn.thecart.ui.BankColors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public final class WorkbookBanksSummaryPanel
extends JPanel {
    private Workbook workbook;
    private List<Bar> bars;

    public WorkbookBanksSummaryPanel(Workbook workbook) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        this.workbook = workbook;
        this.bars = new ArrayList<Bar>();
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                WorkbookBanksSummaryPanel.this.computeToolTipText(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private int defaultInitialDelay;
            private int defaultDismissDelay;

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager manager = ToolTipManager.sharedInstance();
                this.defaultInitialDelay = manager.getInitialDelay();
                this.defaultDismissDelay = manager.getDismissDelay();
                manager.setInitialDelay(50);
                manager.setDismissDelay(60000);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager manager = ToolTipManager.sharedInstance();
                manager.setInitialDelay(this.defaultInitialDelay);
                manager.setDismissDelay(this.defaultDismissDelay);
            }
        });
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    protected void computeToolTipText(MouseEvent e) {
        for (Bar bar : this.bars) {
            if (bar.start > e.getX() || e.getX() > bar.end) continue;
            this.setToolTipText(bar.text);
            return;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        String text;
        int endRequired;
        int endReserved;
        super.paintComponent(g);
        this.bars.clear();
        if (!this.workbook.isValid()) {
            return;
        }
        WorkbookRoot root = this.workbook.getRoot();
        if (!root.isBanksListInitialized()) {
            return;
        }
        WorkbookBanksSummary summary = root.getWorkbookBanksSummary();
        Dimension d = this.getSize();
        int clientWidth = d.width;
        int clientHeight = d.height;
        if (clientWidth == 0 || clientHeight == 0) {
            return;
        }
        int bankSize = this.workbook.getRoot().getBankSize();
        int banksDefined = summary.getDefinedBanks();
        int banksTotal = summary.getTotalBanks();
        int reservedBanksCount = summary.getReservedBanks();
        int requiredBanksCount = summary.getRequiredBanks();
        int freeBanksCount = banksDefined - requiredBanksCount - reservedBanksCount;
        reservedBanksCount = Math.min(reservedBanksCount, banksDefined);
        requiredBanksCount = Math.min(requiredBanksCount, banksDefined - reservedBanksCount);
        int startReserved = 0;
        int startRequired = endReserved = startReserved + clientWidth * reservedBanksCount / banksTotal;
        int startFree = endRequired = startRequired + clientWidth * requiredBanksCount / banksTotal;
        int endFree = clientWidth - 1;
        if (reservedBanksCount >= 0) {
            text = Messages.I150.format(TextUtility.formatAsDecimal(reservedBanksCount), TextUtility.formatAsDecimalPercent(reservedBanksCount, banksDefined), TextUtility.formatAsMemorySize(reservedBanksCount * bankSize));
            this.addBar(g, BankColors.RESERVED, startReserved, endReserved, text);
        }
        if (requiredBanksCount >= 0) {
            text = Messages.I151.format(TextUtility.formatAsDecimal(requiredBanksCount), TextUtility.formatAsDecimalPercent(requiredBanksCount, banksDefined), TextUtility.formatAsMemorySize(requiredBanksCount * bankSize));
            this.addBar(g, BankColors.USED1, startRequired, endRequired, text);
        }
        if (freeBanksCount > 0) {
            text = Messages.I152.format(TextUtility.formatAsDecimal(freeBanksCount), TextUtility.formatAsDecimalPercent(freeBanksCount, banksDefined), TextUtility.formatAsMemorySize(freeBanksCount * bankSize));
            this.addBar(g, BankColors.FREE, startFree, endFree, text);
        } else if (freeBanksCount < 0) {
            int missingBanksCount = -freeBanksCount;
            text = Messages.I153.format(TextUtility.formatAsDecimal(missingBanksCount), TextUtility.formatAsMemorySize(missingBanksCount * bankSize));
            this.addBar(g, BankColors.NOT_AVAILABLE, startFree, endFree, text);
        }
    }

    private void addBar(Graphics graphics, Color color, int start, int end, String text) {
        if (graphics == null) {
            throw new IllegalArgumentException("Parameter 'graphics' must not be null.");
        }
        if (color == null) {
            throw new IllegalArgumentException("Parameter 'color' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        int startY = this.getLocation().y;
        int barHeight = 16;
        Bar bar = new Bar(start, end, text);
        this.bars.add(bar);
        graphics.setColor(color);
        graphics.fillRect(start, startY, end - start, barHeight);
    }

    private static final class Bar {
        public final int start;
        public final int end;
        public final String text;

        public Bar(int start, int end, String text) {
            if (start > end) {
                throw new IllegalArgumentException("Parameter 'start' must not be greater then parameter 'end'. Specified values are " + start + " and " + end + ".");
            }
            if (text == null) {
                throw new IllegalArgumentException("Parameter 'text' must not be null.");
            }
            this.start = start;
            this.end = end;
            this.text = text;
        }
    }
}

