/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.DateUtility;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.AtrFile;
import com.wudsn.tools.thecartstudio.model.CartDef;
import com.wudsn.tools.thecartstudio.model.CartridgeFileUtility;
import com.wudsn.tools.thecartstudio.model.CartridgeType;
import com.wudsn.tools.thecartstudio.model.ReservedContentProvider;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookBank;
import java.io.File;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Exporter {
    private Workbook workbook;
    private byte[] data;
    private MessageQueue messageQueue;
    private List<File> exportedFiles;
    private long exportedFileSize;

    public Exporter(Workbook workbook, byte[] data, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        this.workbook = workbook;
        this.data = data;
        this.messageQueue = messageQueue;
        this.exportedFiles = new ArrayList<File>();
        this.exportedFileSize = 0L;
    }

    public void exportAsBinImage(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        try {
            FileUtility.writeBytes(file, this.data);
            this.addExportedFile(file);
        }
        catch (CoreException ex) {
            this.messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
            return;
        }
        this.messageQueue.sendMessage(file, null, Messages.I110, TextUtility.formatAsMemorySize(this.exportedFileSize), file.getAbsolutePath());
    }

    private void addExportedFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        this.exportedFiles.add(file);
        this.exportedFileSize += file.length();
    }

    public void exportAsCarImage(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        CartridgeType cartridgeType = this.workbook.getRoot().getCartridgeType();
        if (cartridgeType == CartridgeType.UNKNOWN) {
            throw new RuntimeException("Cannot export to unknown cartrdige type.");
        }
        try {
            OutputStream outputStream = FileUtility.openOutputStream(file);
            try {
                byte[] cartrdigeHeader = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeType.getNumericId(), this.data);
                FileUtility.writeBytes(file, outputStream, cartrdigeHeader, 0, cartrdigeHeader.length);
                FileUtility.writeBytes(file, outputStream, this.data, 0, this.data.length);
            }
            finally {
                FileUtility.closeOutputStream(file, outputStream);
            }
            this.addExportedFile(file);
        }
        catch (CoreException ex) {
            this.messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
            return;
        }
        this.messageQueue.sendMessage(file, null, Messages.I111, TextUtility.formatAsMemorySize(this.exportedFileSize), file.getAbsolutePath());
    }

    public void exportAsAtrImage(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        RomTool romTool = new RomTool(this.workbook, this.data);
        int romSize = romTool.getMaxBlock() * 131072;
        int dataSize = 8192 + romSize;
        try {
            OutputStream outputStream = FileUtility.openOutputStream(file);
            try {
                byte[] atrHeader = AtrFile.createHeader(dataSize, 8192);
                FileUtility.writeBytes(file, outputStream, atrHeader, 0, atrHeader.length);
                byte[] imageHeader = romTool.createImageHeader();
                FileUtility.writeBytes(file, outputStream, imageHeader, 0, imageHeader.length);
                FileUtility.writeBytes(file, outputStream, this.data, 0, romSize);
            }
            finally {
                FileUtility.closeOutputStream(file, outputStream);
            }
            this.addExportedFile(file);
        }
        catch (CoreException ex) {
            this.messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
            return;
        }
        this.messageQueue.sendMessage(file, null, Messages.I112, TextUtility.formatAsMemorySize(this.exportedFileSize), file.getAbsolutePath());
    }

    public void exportAsAtrImages(File file) {
        String extension;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        String fileName = file.getName();
        if (!fileName.endsWith(extension = ".atr")) {
            throw new IllegalArgumentException("Parameter 'file' be a file that ends with '" + extension + "'. Specified value was '" + fileName + "'.");
        }
        int extensionIndex = fileName.length() - extension.length();
        String baseFileName = fileName.substring(0, extensionIndex);
        int numberIndex = fileName.lastIndexOf("_");
        if (numberIndex >= 0) {
            char c;
            int i = numberIndex + 1;
            boolean digits = (c = fileName.charAt(i++)) >= '0' && c <= '9';
            while (digits && i < extensionIndex) {
                boolean bl = digits = (c = fileName.charAt(i++)) >= '0' && c <= '9';
            }
            if (digits) {
                baseFileName = fileName.substring(0, numberIndex);
            }
        }
        RomTool romTool = new RomTool(this.workbook, this.data);
        int maxBlock = romTool.getMaxBlock();
        byte[] imageHeader = romTool.createImageHeader();
        int numberOfAtrs = (maxBlock + 127 - 1) / 127;
        imageHeader[22] = (byte)numberOfAtrs;
        int currentAtr = 1;
        while (currentAtr <= numberOfAtrs) {
            imageHeader[23] = (byte)currentAtr;
            File partFile = new File(file.getParentFile(), String.valueOf(baseFileName) + "_" + currentAtr + extension).getAbsoluteFile();
            int startBlock = (currentAtr - 1) * 127;
            int numberOfBlocks = maxBlock - startBlock;
            if (numberOfBlocks > 127) {
                numberOfBlocks = 127;
            }
            this.exportAsAtrImagesPart(partFile, imageHeader, startBlock, numberOfBlocks);
            if (this.messageQueue.containsError()) {
                return;
            }
            this.addExportedFile(partFile);
            ++currentAtr;
        }
        String fileNames = this.exportedFiles.get(0).getAbsolutePath();
        int count = this.exportedFiles.size();
        if (count > 1) {
            fileNames = String.valueOf(fileNames) + " ... " + this.exportedFiles.get(count - 1).getName();
        }
        this.messageQueue.sendMessage(file, null, Messages.I113, TextUtility.formatAsMemorySize(this.exportedFileSize), fileNames);
    }

    private void exportAsAtrImagesPart(File file, byte[] imageHeader, int startBlock, int numberOfBlocks) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (imageHeader == null) {
            throw new IllegalArgumentException("Parameter 'imageHeader' must not be null.");
        }
        int romSize = numberOfBlocks * 131072;
        int dataSize = 8576 + romSize;
        try {
            OutputStream outputStream = FileUtility.openOutputStream(file);
            try {
                byte[] atrHeader = AtrFile.createHeader(dataSize, 256);
                FileUtility.writeBytes(file, outputStream, atrHeader, 0, atrHeader.length);
                byte[] bootSectors = AtrFile.createBootSectors();
                FileUtility.writeBytes(file, outputStream, bootSectors, 0, bootSectors.length);
                FileUtility.writeBytes(file, outputStream, imageHeader, 0, imageHeader.length);
                FileUtility.writeBytes(file, outputStream, this.data, startBlock * 131072, romSize);
            }
            finally {
                FileUtility.closeOutputStream(file, outputStream);
            }
        }
        catch (CoreException ex) {
            this.messageQueue.sendMessage(ex.createMessageQueueEntry(file, null));
        }
    }

    public List<File> getExportedFiles() {
        return Collections.unmodifiableList(this.exportedFiles);
    }

    private static final class RomTool {
        public static final int IMAGE_HEADER_SIZE = 8192;
        private byte[] data;
        private MessageDigest sha512;
        private int maxBlock;
        private static byte EOL = (byte)-101;
        private byte[] imageName = new byte[40];
        private byte[] imageTimeStamp = new byte[20];
        private byte[] imageHeader = new byte[8192];

        public RomTool(Workbook workbook, byte[] data) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            if (data == null) {
                throw new IllegalArgumentException("Parameter 'data' must not be null.");
            }
            this.data = data;
            try {
                this.sha512 = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
            this.imageName = new byte[40];
            this.imageTimeStamp = new byte[20];
            this.imageHeader = new byte[8192];
            int maxBank = 0;
            for (WorkbookBank bank : workbook.getRoot().getBanksList()) {
                boolean relevant;
                ReservedContentProvider reservedContentProvider = bank.getReservedContentProvider();
                boolean bl = relevant = reservedContentProvider != null && reservedContentProvider.isReservedForSystem() || !bank.getEntries().isEmpty();
                if (!relevant) continue;
                maxBank = bank.getNumber() + 1;
            }
            this.maxBlock = (maxBank + 16 - 1) / 16;
            if (this.maxBlock < 2) {
                this.maxBlock = 2;
            }
            this.setImageName(workbook.getRoot().getTitle());
            this.setImageTimeStamp();
            this.calculateHashes();
            this.addTheCartSignature();
            this.setupBaseHeader();
        }

        public int getMaxBlock() {
            return this.maxBlock;
        }

        private void setImageName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' must not be null.");
            }
            int index = 0;
            int dst = 0;
            while (index < name.length() && dst < this.imageName.length - 1) {
                char c;
                if ((c = name.charAt(index++)) < ' ' || c == '`' || c == '{' || c >= '}') continue;
                this.imageName[dst++] = (byte)c;
            }
            this.imageName[dst++] = EOL;
            while (dst < this.imageName.length) {
                this.imageName[dst++] = -1;
            }
        }

        private void setImageTimeStamp() {
            byte[] dateTime = ASCIIString.getBytes(DateUtility.getCurrentDateTimeString());
            System.arraycopy(dateTime, 0, this.imageTimeStamp, 0, dateTime.length);
            this.imageTimeStamp[this.imageTimeStamp.length - 1] = EOL;
        }

        private void calculateHashes() {
            int i = 0;
            while (i < this.maxBlock) {
                if (i < 1 || i >= 2) {
                    int hashOffset = 131072 + i * 64;
                    this.computeSHA512(this.data, i * 131072, 131072, this.data, hashOffset);
                }
                ++i;
            }
        }

        private void computeSHA512(byte[] source, int sourceOffset, int size, byte[] dest, int destOffset) {
            this.sha512.reset();
            this.sha512.update(source, sourceOffset, size);
            byte[] hash = this.sha512.digest();
            System.arraycopy(hash, 0, dest, destOffset, hash.length);
        }

        private void addTheCartSignature() {
            System.arraycopy(CartDef.SIGNATURE_DATA, 0, this.data, 131136, 16);
            this.data[131152] = (byte)(this.maxBlock & 0xFF);
            this.data[131153] = (byte)(this.maxBlock >> 8);
            System.arraycopy(this.imageName, 0, this.data, 131160, 40);
        }

        private void calculateUsageMap() {
            int i = 0;
            while (i < 2048) {
                this.imageHeader[4096 + i] = 0;
                ++i;
            }
            int block = 0;
            while (block < this.maxBlock * 2) {
                int blockOffset = block * 8192 * 8;
                int usedBits = 0;
                int i2 = 0;
                while (i2 < 8) {
                    int bankOffset = blockOffset + i2 * 8192;
                    boolean bankUnused = true;
                    int j = 0;
                    while (bankUnused && j < 8192) {
                        bankUnused = this.data[bankOffset + j] == -1;
                        ++j;
                    }
                    if (!bankUnused) {
                        usedBits |= 1 << i2;
                    }
                    ++i2;
                }
                this.imageHeader[4096 + block] = (byte)usedBits;
                ++block;
            }
        }

        private void setupBaseHeader() {
            this.computeSHA512(this.data, 131072, 131072, this.imageHeader, 128);
            System.arraycopy(CartDef.HDR_SIGNATURE_DATA, 0, this.imageHeader, 0, 16);
            this.imageHeader[16] = (byte)(this.maxBlock & 0xFF);
            this.imageHeader[17] = (byte)(this.maxBlock >> 8);
            this.imageHeader[22] = 1;
            this.imageHeader[23] = 1;
            this.imageHeader[18] = 1;
            this.imageHeader[19] = 0;
            this.imageHeader[20] = 1;
            System.arraycopy(this.imageName, 0, this.imageHeader, 32, 40);
            System.arraycopy(this.imageTimeStamp, 0, this.imageHeader, 72, 20);
            this.calculateUsageMap();
        }

        public byte[] createImageHeader() {
            return this.imageHeader;
        }
    }
}

