/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.JDK;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.common.XMLUtility;
import com.wudsn.tools.base.gui.AttributeTableModel;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.base.repository.RepositoryValidation;
import com.wudsn.tools.thecartstudio.DataTypes;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.Texts;
import com.wudsn.tools.thecartstudio.model.AtrFile;
import com.wudsn.tools.thecartstudio.model.AtrLoader;
import com.wudsn.tools.thecartstudio.model.CartridgeDatabase;
import com.wudsn.tools.thecartstudio.model.CartridgeDatabaseEntry;
import com.wudsn.tools.thecartstudio.model.CartridgeFileUtility;
import com.wudsn.tools.thecartstudio.model.CartridgeType;
import com.wudsn.tools.thecartstudio.model.ContentType;
import com.wudsn.tools.thecartstudio.model.DisplayMode;
import com.wudsn.tools.thecartstudio.model.FileHeaderType;
import com.wudsn.tools.thecartstudio.model.ImportableCartridgeMenu;
import com.wudsn.tools.thecartstudio.model.Importer;
import com.wudsn.tools.thecartstudio.model.ReservedContentProvider;
import com.wudsn.tools.thecartstudio.model.ReservedContentProviderFactory;
import com.wudsn.tools.thecartstudio.model.WorkbookAddEntriesCallback;
import com.wudsn.tools.thecartstudio.model.WorkbookBank;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookEntryType;
import com.wudsn.tools.thecartstudio.model.WorkbookGenre;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import com.wudsn.tools.thecartstudio.model.WorkbookRootValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.CRC32;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class Workbook {
    public static final String FILE_EXTENSION = ".tcw";
    private static final String DATA_FOLDER_FILE_EXTENSION = ".tcd";
    private static final long ENTRY_MAX_FILE_SIZE = 0x8000000L;
    private static final int SINGLE_ROWS_LIMIT = 100;
    private CartridgeDatabase cartridgeDatabase;
    private boolean valid;
    private WorkbookRoot root;
    private File rootFile;
    private WorkbookRoot backup;
    private AttributeTableModel entriesModel;

    public Workbook(CartridgeDatabase cartridgeDatabase) {
        if (cartridgeDatabase == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeDatabase' must not be null.");
        }
        this.cartridgeDatabase = cartridgeDatabase;
        this.valid = false;
        this.root = new WorkbookRoot();
        this.rootFile = null;
        this.backup = null;
        this.entriesModel = null;
    }

    public void setEntriesTableModel(AttributeTableModel entriesModel) {
        this.entriesModel = entriesModel;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isChanged() {
        if (!this.valid) {
            return false;
        }
        if (this.backup == null) {
            return true;
        }
        return !this.root.contentEquals(this.backup);
    }

    public boolean isPersistent() {
        return this.rootFile != null;
    }

    public WorkbookRoot getRoot() {
        return this.root;
    }

    public File getFile() {
        return this.rootFile;
    }

    public void close() {
        this.clear();
    }

    public boolean create(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        this.clear();
        this.valid = true;
        this.root.setTitle(Texts.MainWindow_Title_Unnamed);
        WorkbookGenre genre = new WorkbookGenre();
        genre.setName("Games");
        this.root.getGenresList().add(genre);
        genre = new WorkbookGenre();
        genre.setName("Demos");
        this.root.getGenresList().add(genre);
        genre = new WorkbookGenre();
        genre.setName("Tools");
        this.root.getGenresList().add(genre);
        this.backup = this.root.createCopy();
        return Workbook.initializeBanksList(this.root, messageQueue);
    }

    private void clear() {
        this.valid = false;
        this.root = new WorkbookRoot();
        this.rootFile = null;
        this.backup = null;
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkbookEntry addEntries(File[] files, WorkbookAddEntriesCallback callback, MessageQueue messageQueue) {
        if (files == null) {
            throw new IllegalArgumentException("Parameter 'files' must not be null.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Parameter 'callback' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        List<File> filesList = Arrays.asList(files);
        Collections.sort(filesList, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return JDK.Long.compare(o2.length(), o1.length());
            }
        });
        WorkbookEntry firstAddedEntry = null;
        int totalNumber = filesList.size();
        int steps = Math.max(10, totalNumber / 100);
        try {
            block12: {
                int i;
                block11: {
                    i = 0;
                    if (!true) break block11;
                    if (i >= filesList.size()) return firstAddedEntry;
                    if (callback.isCancelled()) break block12;
                }
                do {
                    WorkbookEntry entry;
                    File entryFile = filesList.get(i);
                    int number = i + 1;
                    if (number % steps == 0) {
                        messageQueue.sendMessage(entryFile, WorkbookEntry.Attributes.FILE_PATH, Messages.S416, TextUtility.formatAsDecimal(number), TextUtility.formatAsDecimal(totalNumber), TextUtility.formatAsDecimalPercent(number, totalNumber));
                    }
                    if ((entry = this.addEntry(entryFile, callback, messageQueue)) != null) {
                        firstAddedEntry = entry;
                    }
                    ++i;
                    if (i >= filesList.size()) return firstAddedEntry;
                } while (!callback.isCancelled());
            }
            return firstAddedEntry;
        }
        finally {
            if (this.entriesModel != null) {
                this.entriesModel.fireTableDataChanged();
            }
        }
    }

    public WorkbookEntry addUserSpaceEntry() {
        WorkbookEntry entry = new WorkbookEntry();
        entry.setType(WorkbookEntryType.USER_SPACE_ENTRY);
        entry.setTitle(Texts.WorkbookEntry_UserSpaceEntryTitle);
        entry.setStartBankFixed(true);
        ReservedContentProviderFactory.UserSpaceContentProvider userSpaceContentProvider = new ReservedContentProviderFactory.UserSpaceContentProvider();
        userSpaceContentProvider.init(this.root);
        entry.setStartBankNumber(userSpaceContentProvider.getStartBankNumber());
        int index = this.root.getUnmodifiableEntriesList().size();
        this.root.addEntry(index, entry);
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
        return entry;
    }

    private WorkbookEntry addEntry(File file, WorkbookAddEntriesCallback callback, MessageQueue messageQueue) {
        byte[] content;
        int index;
        boolean insert;
        WorkbookEntry entry;
        String fileName;
        String filePath;
        block27: {
            block26: {
                if (file == null) {
                    throw new IllegalArgumentException("Parameter 'file' must not be null.");
                }
                if (callback == null) {
                    throw new IllegalArgumentException("Parameter 'callback' must not be null.");
                }
                if (messageQueue == null) {
                    throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
                }
                Importer.ImportResult importResult = new Importer().autoConvertFile(file, messageQueue);
                if (importResult.convertedFileException != null && importResult.convertedFileException.getSeverity() == 3) {
                    importResult.convertedFileException.createMessageQueueEntry(file, WorkbookEntry.Attributes.FILE_NAME);
                    return null;
                }
                if (importResult.convertedFile != null) {
                    file = importResult.convertedFile;
                }
                filePath = file.getAbsolutePath();
                fileName = file.getName();
                entry = this.root.getEntry(fileName);
                insert = false;
                if (entry == null) break block26;
                int i = fileName.lastIndexOf(46);
                String fileNameWithoutExtension = fileName;
                String fileExtension = "";
                if (i >= 0) {
                    fileNameWithoutExtension = fileName.substring(0, i);
                    fileExtension = fileName.substring(i);
                }
                String renamedFileName = fileName;
                File renamedFile = file;
                WorkbookEntry otherEntry = null;
                String parentPath = "";
                while ((otherEntry = this.root.getEntry(renamedFileName)) != null && renamedFile != null && StringUtility.isSpecified(renamedFile.getName())) {
                    if ((renamedFile = renamedFile.getParentFile()) == null || !StringUtility.isSpecified(renamedFile.getName())) continue;
                    parentPath = String.valueOf(parentPath) + "_" + renamedFile.getName();
                    renamedFileName = String.valueOf(fileNameWithoutExtension) + parentPath + fileExtension;
                }
                if (otherEntry != null) {
                    int number = 1;
                    renamedFileName = String.valueOf(fileNameWithoutExtension) + "_" + number + fileExtension;
                    while ((otherEntry = this.root.getEntry(renamedFileName)) != null && renamedFile != null) {
                        renamedFileName = String.valueOf(fileNameWithoutExtension) + "_" + ++number + fileExtension;
                    }
                }
                int result = callback.confirmAdd(entry.getTitle(), entry.getFileName(), filePath, renamedFileName);
                switch (result) {
                    case -1: {
                        return null;
                    }
                    case 1: {
                        if (file.length() != entry.getFileSize()) {
                            this.unassignBanks(entry);
                        }
                        index = this.root.getUnmodifiableEntriesList().indexOf(entry);
                        break block27;
                    }
                    case 2: {
                        entry = new WorkbookEntry();
                        index = this.root.getUnmodifiableEntriesList().size();
                        fileName = renamedFileName;
                        insert = true;
                        break block27;
                    }
                    case 3: {
                        ++callback.skippedEntriesCount;
                        return null;
                    }
                    default: {
                        throw new RuntimeException("Illegal result " + result + ".");
                    }
                }
            }
            entry = new WorkbookEntry();
            index = this.root.getUnmodifiableEntriesList().size();
            insert = true;
        }
        entry.setFilePath(filePath);
        entry.setFileName(fileName);
        int nameIndex = fileName.indexOf(46);
        if (nameIndex >= 0) {
            fileName = fileName.substring(0, nameIndex);
        }
        entry.setTitle(fileName);
        long fileSizeLong = file.length();
        if (file.exists() && file.isFile()) {
            if (fileSizeLong == 0L) {
                messageQueue.sendMessage(entry, WorkbookEntry.Attributes.FILE_PATH, Messages.S419, file.getAbsolutePath());
                ++callback.skippedEntriesCount;
                return null;
            }
            if (fileSizeLong > 0x8000000L) {
                messageQueue.sendMessage(entry, WorkbookEntry.Attributes.FILE_PATH, com.wudsn.tools.base.Messages.E214, file.getAbsolutePath(), TextUtility.formatAsMemorySize(fileSizeLong), TextUtility.formatAsMemorySize(0x8000000L));
                return null;
            }
        }
        int fileSize = (int)fileSizeLong;
        entry.setFileSize(fileSize);
        try {
            content = FileUtility.readBytes(file, 0x8000000L, true);
        }
        catch (CoreException ex) {
            messageQueue.sendMessage(ex.createMessageQueueEntry(file, WorkbookEntry.Attributes.FILE_PATH));
            return null;
        }
        int cartridgeType = CartridgeFileUtility.getCartridgeTypeNumericId(content);
        if (cartridgeType > 0) {
            entry.setFileHeaderType(FileHeaderType.CART);
            int headerSize = entry.getFileHeaderType().getHeaderSize();
            byte[] newContent = new byte[fileSize -= headerSize];
            System.arraycopy(content, headerSize, newContent, 0, fileSize);
            content = newContent;
            entry.setContentType(ContentType.getInstanceByCartridgeType(cartridgeType));
        } else {
            entry.setFileHeaderType(FileHeaderType.NONE);
        }
        this.applyEntryDefaults(entry, content);
        int requiredBanks = (fileSize + this.root.getBankSize() - 1) / this.root.getBankSize();
        entry.setRequiredBanksCount(requiredBanks);
        if (insert) {
            this.root.addEntry(index, entry);
            ++callback.addedEntriesCount;
        } else {
            ++callback.updatedEntriesCount;
        }
        this.assignNewBanks(entry, messageQueue);
        return entry;
    }

    private void applyEntryDefaults(WorkbookEntry entry, byte[] content) {
        CartridgeType entryCartridgeType;
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entr' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        CRC32 crc32 = new CRC32();
        crc32.update(content, 0, content.length);
        int sizeInKB = content.length / 1024;
        int crc32Value = (int)crc32.getValue();
        entry.setContentCRC32(crc32Value);
        CartridgeDatabaseEntry cartridgeDatabaseEntry = this.cartridgeDatabase.getEntryByCRC32(sizeInKB, crc32Value);
        if (cartridgeDatabaseEntry != null) {
            entry.setTitle(cartridgeDatabaseEntry.getTitle());
            entry.setContentType(cartridgeDatabaseEntry.getContentType());
        }
        List<CartridgeType> cartridgeTypes = !(entryCartridgeType = entry.getContentType().getCartridgeType()).equals(CartridgeType.UNKNOWN) ? Collections.singletonList(entryCartridgeType) : CartridgeType.getValues();
        for (CartridgeType cartridgeType : cartridgeTypes) {
            ImportableCartridgeMenu importableCartridgeMenu;
            if (entry.getContentSize() != (long)(cartridgeType.getSizeInKB() * 1024) || (importableCartridgeMenu = cartridgeType.createImportableCartridgeMenu()) == null || !importableCartridgeMenu.isContainedIn(content)) continue;
            entry.setContentType(ContentType.getInstanceByCartridgeType(cartridgeType.getNumericId()));
            entry.setDisplayMode(DisplayMode.MULTIPLE_ENTRIES);
        }
        if (AtrFile.isHeader(content)) {
            entry.setContentType(ContentType.FILE_ATR);
            AtrLoader.setDefaultParameters(entry, content);
        }
    }

    public void removeEntries(int[] indexes, MessageQueue messageQueue) {
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter 'indexes' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        try {
            Arrays.sort(indexes);
            int minRow = 0;
            int i = indexes.length - 1;
            while (i >= 0) {
                minRow = indexes[i];
                try {
                    WorkbookEntry entry = this.root.removeEntry(minRow);
                    this.unassignBanks(entry);
                }
                finally {
                    if (this.entriesModel != null && indexes.length < 100) {
                        this.entriesModel.fireTableRowsDeleted(minRow, minRow);
                    }
                }
                --i;
            }
        }
        finally {
            if (this.entriesModel != null && indexes.length >= 100) {
                this.entriesModel.fireTableDataChanged();
            }
        }
    }

    public void setEntriesGenreName(String genreName, int[] indexes, MessageQueue messageQueue) {
        if (genreName == null) {
            throw new IllegalArgumentException("Parameter 'genreName' must not be null.");
        }
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter 'indexes' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        List<WorkbookEntry> entries = this.root.getUnmodifiableEntriesList();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            entries.get(i).setGenreName(genreName);
            ++n2;
        }
        if (this.entriesModel != null && indexes.length > 0) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    private String getEntryAbsoluteFilePath(WorkbookEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        String entryFilePath = entry.getFilePath();
        if (StringUtility.isEmpty(entryFilePath)) {
            String dataFolderPath = this.getDataFolderPath();
            entryFilePath = String.valueOf(dataFolderPath) + entry.getFileName();
        }
        return entryFilePath;
    }

    public void open(File file, MessageQueue messageQueue) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        XMLUtility.open(file, new XMLHandler(this), messageQueue);
        if (!messageQueue.containsError()) {
            this.valid = true;
            this.rootFile = file;
            this.backup = this.root.createCopy();
            Workbook.initializeBanksList(this.root, messageQueue);
            this.assignCurrentBanks(messageQueue);
        }
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    public void save(File file, MessageQueue messageQueue) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        WorkbookRootValidation validation = WorkbookRootValidation.createInstance();
        validation.validateSave(this.root, messageQueue, true);
        if (messageQueue.containsError()) {
            return;
        }
        if (this.rootFile != null && !this.rootFile.equals(file)) {
            for (WorkbookEntry entry : this.root.getUnmodifiableEntriesList()) {
                if (!StringUtility.isEmpty(entry.getFilePath())) continue;
                entry.setFilePath(new File(this.getDataFolderPath(), entry.getFileName()).getAbsolutePath());
            }
        }
        this.rootFile = file;
        Collections.sort(this.root.getEntriesList());
        this.entriesModel.fireTableDataChanged();
        XMLUtility.save(file, new XMLHandler(this), messageQueue);
        if (messageQueue.containsError()) {
            return;
        }
        this.saveEntryFilesToDataFolder(messageQueue);
        if (messageQueue.containsError()) {
            return;
        }
        this.backup = this.root.createCopy();
    }

    private void saveEntryFilesToDataFolder(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        String dataFolderPath = this.getDataFolderPath();
        File dataFolderFile = new File(dataFolderPath);
        if (!dataFolderFile.exists() && !dataFolderFile.mkdirs()) {
            messageQueue.sendMessage(this.root, null, com.wudsn.tools.base.Messages.E203, dataFolderPath);
            return;
        }
        ArrayList<FileToCopy> filesToCopy = new ArrayList<FileToCopy>();
        for (WorkbookEntry entry : this.root.getUnmodifiableEntriesList()) {
            if (StringUtility.isSpecified(entry.getFilePath())) {
                String targetFilePath;
                String sourceFilePath = entry.getFilePath();
                if (sourceFilePath.equals(targetFilePath = String.valueOf(dataFolderPath) + entry.getFileName())) continue;
                File sourceFile = new File(sourceFilePath);
                File targetFile = new File(targetFilePath);
                filesToCopy.add(new FileToCopy(entry, sourceFile, targetFile));
                continue;
            }
            entry.setFilePath("");
        }
        int totalNumber = filesToCopy.size();
        int steps = Math.max(10, totalNumber / 100);
        int i = 0;
        while (i < totalNumber) {
            FileToCopy fileToCopy = (FileToCopy)filesToCopy.get(i);
            try {
                int number = i + 1;
                if (number % steps == 0) {
                    messageQueue.sendMessage(fileToCopy.entry, WorkbookEntry.Attributes.FILE_PATH, Messages.S417, TextUtility.formatAsDecimal(number), TextUtility.formatAsDecimal(totalNumber), TextUtility.formatAsDecimalPercent(number, totalNumber));
                }
                FileUtility.copyFile(fileToCopy.sourceFile, fileToCopy.targetFile);
                fileToCopy.entry.setFilePath("");
            }
            catch (CoreException ex) {
                messageQueue.sendMessage(ex.createMessageQueueEntry(fileToCopy.entry, WorkbookEntry.Attributes.FILE_PATH));
            }
            ++i;
        }
        System.gc();
        File[] files = dataFolderFile.listFiles();
        ArrayList<File> filesToDelete = new ArrayList<File>();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int targetFile = 0;
            while (targetFile < n) {
                File file = fileArray[targetFile];
                if (file.isFile() && this.root.getEntry(file.getName()) == null) {
                    filesToDelete.add(file);
                }
                ++targetFile;
            }
        }
        totalNumber = filesToDelete.size();
        int i2 = 0;
        while (i2 < totalNumber) {
            File file = (File)filesToDelete.get(i2);
            int number = i2 + 1;
            if (number % 10 == 0) {
                messageQueue.sendMessage(file, WorkbookEntry.Attributes.FILE_PATH, Messages.S418, TextUtility.formatAsDecimal(number), TextUtility.formatAsDecimal(totalNumber), TextUtility.formatAsDecimalPercent(number, totalNumber));
            }
            if (!file.delete()) {
                messageQueue.sendMessage(file, null, com.wudsn.tools.base.Messages.E219, file.getAbsolutePath());
            }
            ++i2;
        }
        if (this.entriesModel != null) {
            this.entriesModel.fireTableDataChanged();
        }
    }

    public static boolean initializeBanksList(WorkbookRoot root, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        root.clearBanksList();
        int reservedBanksCount = 0;
        for (ReservedContentProvider reservedContentProvider : root.getReservedContentProviders()) {
            reservedContentProvider.init(root);
            if (reservedContentProvider.getRequiredBanksCount() <= 0) continue;
            if (reservedContentProvider.getRequiredBankSize() > 0 && reservedContentProvider.getRequiredBankSize() != root.getBankSize()) {
                messageQueue.sendMessage(reservedContentProvider, null, Messages.E407, reservedContentProvider.getTitle(), TextUtility.formatAsMemorySize(reservedContentProvider.getRequiredBankSize()));
                continue;
            }
            reservedBanksCount += reservedContentProvider.getRequiredBanksCount();
            int endBank = reservedContentProvider.getStartBankNumber() + reservedContentProvider.getRequiredBanksCount();
            if (endBank > root.getBankCount()) {
                messageQueue.sendMessage(reservedContentProvider, null, Messages.E408, reservedContentProvider.getTitle(), TextUtility.formatAsDecimal(reservedContentProvider.getRequiredBanksCount()), TextUtility.formatAsDecimal(endBank), TextUtility.formatAsDecimal(root.getBankCount()));
                continue;
            }
            int bankNumber = reservedContentProvider.getStartBankNumber();
            while (bankNumber < endBank) {
                WorkbookBank bank = root.getBanksList().get(bankNumber);
                ReservedContentProvider otherReservedContentProvider = bank.getReservedContentProvider();
                if (otherReservedContentProvider == null) {
                    bank.setReservedContentProvider(reservedContentProvider);
                } else {
                    messageQueue.sendMessage(reservedContentProvider, null, Messages.E409, TextUtility.formatAsDecimal(bankNumber), otherReservedContentProvider.getTitle(), reservedContentProvider.getTitle());
                }
                ++bankNumber;
            }
        }
        if (messageQueue.containsError()) {
            return false;
        }
        root.setBanksListInitialized(true, reservedBanksCount);
        return true;
    }

    private boolean validateBanksList(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (!this.root.isBanksListInitialized()) {
            messageQueue.sendMessage(this, null, Messages.E411, new String[0]);
            return false;
        }
        return true;
    }

    public boolean unassignAllBanks(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (!this.validateBanksList(messageQueue)) {
            return false;
        }
        for (WorkbookEntry entry : this.root.getUnmodifiableEntriesList()) {
            this.unassignBanks(entry);
        }
        return true;
    }

    private void assignCurrentBanks(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (!this.unassignAllBanks(messageQueue)) {
            return;
        }
        int failedEntriesCount = 0;
        RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
        for (WorkbookEntry entry : this.root.getUnmodifiableEntriesList()) {
            int startBank = entry.getStartBankNumber();
            if (startBank < 0 || !rv.isLongValid(entry, WorkbookEntry.Attributes.START_BANK, 0L, this.root.getBankCount() - 1, startBank) || this.assignBanks(entry, startBank)) continue;
            ++failedEntriesCount;
        }
        if (failedEntriesCount > 0) {
            messageQueue.sendMessage(this, null, Messages.E126, TextUtility.formatAsDecimal(failedEntriesCount));
            return;
        }
    }

    public void assignNewBanks(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (!this.unassignAllBanks(messageQueue)) {
            return;
        }
        ArrayList<WorkbookEntry> entries = new ArrayList<WorkbookEntry>(this.root.getUnmodifiableEntriesList());
        Collections.sort(entries, new Comparator<WorkbookEntry>(){

            @Override
            public int compare(WorkbookEntry o1, WorkbookEntry o2) {
                int result = JDK.Boolean.compare(o2.isStartBankFixed(), o1.isStartBankFixed());
                if (result == 0) {
                    result = o2.getRequiredBanksCount() - o1.getRequiredBanksCount();
                }
                if (result == 0) {
                    result = o1.getFileName().compareTo(o2.getFileName());
                }
                return result;
            }
        });
        int failedEntriesCount = 0;
        for (WorkbookEntry entry : entries) {
            if (this.assignNewBanks(entry, messageQueue)) continue;
            ++failedEntriesCount;
        }
        if (failedEntriesCount > 0 && !messageQueue.containsError()) {
            messageQueue.sendMessage(this, null, Messages.E126, TextUtility.formatAsDecimal(failedEntriesCount));
        }
    }

    private boolean assignNewBanks(WorkbookEntry entry, MessageQueue messageQueue) {
        boolean bankFound;
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        this.unassignBanks(entry);
        if (!entry.isStartBankFixed()) {
            entry.setStartBankNumber(-1);
        }
        if (entry.getRequiredBanksCount() == 0) {
            return true;
        }
        if (entry.isStartBankFixed()) {
            RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
            bankFound = rv.isLongValid(entry, WorkbookEntry.Attributes.START_BANK, 0L, this.root.getBankCount() - 1, entry.getStartBankNumber()) ? this.assignBanks(entry, entry.getStartBankNumber()) : false;
        } else {
            entry.setStartBankNumber(-1);
            bankFound = false;
            int bankNumber = 0;
            while (!bankFound && bankNumber < this.root.getBankCount()) {
                if (bankNumber % entry.getAlignmentBanksCount() == 0) {
                    bankFound = this.assignBanks(entry, bankNumber);
                }
                ++bankNumber;
            }
        }
        return bankFound;
    }

    public boolean assignBanks(WorkbookEntry entry, int startBank) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (entry.areBanksAssigned()) {
            throw new IllegalArgumentException("Entry for file '" + entry.getFileName() + "' starting at bank " + entry.getStartBankNumber() + " already has banks assigned.");
        }
        List<WorkbookBank> banks = this.root.getBanksList();
        boolean allBanksFree = true;
        int j = 0;
        while (allBanksFree && j < entry.getRequiredBanksCount()) {
            if (startBank + j < banks.size()) {
                WorkbookBank bank = banks.get(startBank + j);
                if (bank.isUsed()) {
                    allBanksFree = false;
                }
            } else {
                allBanksFree = false;
            }
            ++j;
        }
        if (allBanksFree) {
            entry.setStartBankNumber(startBank);
            j = 0;
            while (j < entry.getRequiredBanksCount()) {
                banks.get(startBank + j).getEntries().add(entry);
                ++j;
            }
        }
        entry.setBanksAssigned(allBanksFree);
        return allBanksFree;
    }

    public void unassignBanks(WorkbookEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter 'entry' must not be null.");
        }
        if (!entry.areBanksAssigned()) {
            return;
        }
        entry.setBanksAssigned(false);
        List<WorkbookBank> banks = this.root.getBanksList();
        int bankNumber = entry.getStartBankNumber();
        while (bankNumber < entry.getStartBankNumber() + entry.getRequiredBanksCount() && bankNumber < this.root.getBankCount()) {
            WorkbookBank bank = banks.get(bankNumber);
            bank.getEntries().remove(entry);
            ++bankNumber;
        }
    }

    private String getDataFolderPath() {
        if (this.rootFile == null) {
            throw new IllegalStateException("Workbook is not yet persistent.");
        }
        String result = FileUtility.getAbsolutePath(this.rootFile.getAbsolutePath());
        int index = result.lastIndexOf(46);
        if (index < 0) {
            throw new IllegalStateException("Workbook path '" + result + "' has no file extensions.");
        }
        result = String.valueOf(result.substring(0, index)) + DATA_FOLDER_FILE_EXTENSION + File.separator;
        return result;
    }

    public byte[] export(int exportFormat, MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        WorkbookRootValidation validation = WorkbookRootValidation.createInstance();
        validation.validateExport(this.root, messageQueue);
        if (messageQueue.containsError()) {
            return null;
        }
        int imageSize = this.root.getImageSize();
        byte[] data = new byte[imageSize];
        int bankSize = this.root.getBankSize();
        byte[] emptyBank = new byte[bankSize];
        int i = 0;
        while (i < bankSize) {
            emptyBank[i] = -1;
            ++i;
        }
        i = 0;
        while (i < imageSize) {
            System.arraycopy(emptyBank, 0, data, i, bankSize);
            i += bankSize;
        }
        int bankNumber = 0;
        while (bankNumber < this.root.getBankCount()) {
            WorkbookBank bank = this.root.getBanksList().get(bankNumber);
            ReservedContentProvider reservedContentProvider = bank.getReservedContentProvider();
            if (reservedContentProvider != null && reservedContentProvider.getStartBankNumber() == bankNumber) {
                byte[] reservedContent = reservedContentProvider.createContent(this, messageQueue);
                if (reservedContent != null) {
                    int expectedLength = reservedContentProvider.getRequiredBanksCount() * bankSize;
                    if (reservedContent.length > expectedLength) {
                        throw new RuntimeException("Reserved content provider '" + reservedContentProvider + "' returned too much content. Expected " + expectedLength + " bytes and found " + reservedContent.length + " bytes.");
                    }
                    System.arraycopy(reservedContent, 0, data, bankNumber * bankSize, reservedContent.length);
                    bankNumber += reservedContentProvider.getRequiredBanksCount() - 1;
                }
            } else {
                List<WorkbookEntry> entries = bank.getEntries();
                if (!entries.isEmpty()) {
                    WorkbookEntry entry = entries.get(0);
                    byte[] entryContent = this.getEntryFileContent(entry, messageQueue);
                    if (entryContent != null) {
                        if (entry.getContentType().equals(ContentType.FILE_ATR)) {
                            entryContent = AtrLoader.modifyContent(entry, entryContent);
                        }
                        System.arraycopy(entryContent, 0, data, bankNumber * bankSize, entryContent.length);
                    }
                    bankNumber += entry.getRequiredBanksCount() - 1;
                }
            }
            ++bankNumber;
        }
        switch (exportFormat) {
            case 2: {
                CartridgeType cartridgeType = this.root.getCartridgeType();
                if (cartridgeType != CartridgeType.UNKNOWN) break;
                messageQueue.sendMessage(data, null, Messages.E404, this.root.getFlashTargetType().getText());
                break;
            }
            case 3: {
                if (data.length % 8192 == 0) break;
                messageQueue.sendMessage(data, null, Messages.E410, TextUtility.formatAsMemorySize(data.length), TextUtility.formatAsMemorySize(8192L));
            }
        }
        if (messageQueue.containsError()) {
            return null;
        }
        return data;
    }

    public byte[] getEntryFileContent(WorkbookEntry entry, MessageQueue messageQueue) {
        String filePath = this.getEntryAbsoluteFilePath(entry);
        File entryFile = new File(filePath);
        if (!entryFile.exists()) {
            messageQueue.sendMessage(entry, WorkbookEntry.Attributes.FILE_PATH, com.wudsn.tools.base.Messages.E203, filePath);
            return null;
        }
        long entryFileSize = entryFile.length();
        if (entryFileSize != entry.getFileSize()) {
            messageQueue.sendMessage(entry, WorkbookEntry.Attributes.FILE_PATH, Messages.E403, filePath, TextUtility.formatAsMemorySize(entryFileSize), TextUtility.formatAsMemorySize(entry.getFileSize()));
        } else {
            CartridgeType cartridgeType = entry.getContentType().getCartridgeType();
            long cartridgeTypeSize = cartridgeType.getSizeInKB() * 1024;
            if (cartridgeType != CartridgeType.UNKNOWN && entry.getContentSize() != cartridgeTypeSize) {
                messageQueue.sendMessage(entry, WorkbookEntry.Attributes.CONTENT_TYPE, Messages.E413, filePath, TextUtility.formatAsMemorySize(entry.getContentSize()), entry.getContentType().getText(), TextUtility.formatAsMemorySize(cartridgeTypeSize));
            } else {
                InputStream inputStream = null;
                try {
                    byte[] entryContent;
                    inputStream = FileUtility.openInputStream(entryFile);
                    int headerSize = entry.getFileHeaderType().getHeaderSize();
                    if (headerSize > 0) {
                        try {
                            if (inputStream.read(new byte[headerSize]) != headerSize) {
                                throw new RuntimeException();
                            }
                        }
                        catch (IOException ex) {
                            throw new CoreException(com.wudsn.tools.base.Messages.E206, filePath, ex.getLocalizedMessage());
                        }
                    }
                    byte[] byArray = entryContent = FileUtility.readBytes(filePath, inputStream, 0x8000000L, true);
                    return byArray;
                }
                catch (CoreException ex) {
                    messageQueue.sendMessage(ex.createMessageQueueEntry(entry, WorkbookEntry.Attributes.FILE_PATH));
                }
                finally {
                    if (inputStream != null) {
                        try {
                            FileUtility.closeInputStream(entryFile, inputStream);
                        }
                        catch (CoreException ex) {
                            messageQueue.sendMessage(ex.createMessageQueueEntry(entry, WorkbookEntry.Attributes.FILE_PATH));
                        }
                    }
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.root.toString();
    }

    public static final class Attributes {
        public static final Attribute FILE_PATH = new Attribute("filePath", DataTypes.Workbook_FilePath);
        public static final Attribute FOLDER_PATH = new Attribute("folderPath", DataTypes.Workbook_FolderPath);

        private Attributes() {
        }
    }

    private static final class FileToCopy {
        public final WorkbookEntry entry;
        public final File sourceFile;
        public final File targetFile;

        public FileToCopy(WorkbookEntry entry, File sourceFile, File targetFile) {
            if (entry == null) {
                throw new IllegalArgumentException("Parameter 'entry' must not be null.");
            }
            if (sourceFile == null) {
                throw new IllegalArgumentException("Parameter 'sourceFile' must not be null.");
            }
            if (targetFile == null) {
                throw new IllegalArgumentException("Parameter 'targetFile' must not be null.");
            }
            this.entry = entry;
            this.sourceFile = sourceFile;
            this.targetFile = targetFile;
        }
    }

    private static final class XMLHandler
    extends com.wudsn.tools.base.common.XMLHandler {
        private Workbook workbook;

        public XMLHandler(Workbook workbook) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            this.workbook = workbook;
        }

        @Override
        public void startOpen(MessageQueue messageQueue) {
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            this.workbook.create(messageQueue);
            this.workbook.getRoot().getGenresList().clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if (qName == null) {
                throw new IllegalArgumentException("Parameter 'qName' must not be null.");
            }
            if (attributes == null) {
                throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
            }
            if (qName.equals("workbook")) {
                this.workbook.getRoot().deserialize(attributes);
            } else if (qName.equals("genre")) {
                WorkbookGenre genre = new WorkbookGenre();
                genre.deserialize(attributes);
                WorkbookRoot root = this.workbook.getRoot();
                root.getGenresList().add(genre);
            } else if (qName.equals("entry")) {
                WorkbookEntry entry = new WorkbookEntry();
                entry.deserialize(attributes);
                WorkbookRoot root = this.workbook.getRoot();
                WorkbookEntry otherEntry = root.getEntry(entry.getFileName());
                if (otherEntry != null) {
                    throw new SAXException("There is already an entry with file name '" + entry.getFileName() + "'.");
                }
                root.addEntry(root.getEntryCount(), entry);
            }
        }

        @Override
        public void startSave(Document document, MessageQueue messageQueue) {
            Element entryElement;
            if (document == null) {
                throw new IllegalArgumentException("Parameter 'document' must not be null.");
            }
            if (messageQueue == null) {
                throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
            }
            Element workbookElement = document.createElement("workbook");
            document.appendChild(workbookElement);
            WorkbookRoot root = this.workbook.getRoot();
            root.serialize(workbookElement);
            for (WorkbookGenre workbookGenre : root.getUnmodifiableGenresList()) {
                entryElement = document.createElement("genre");
                workbookElement.appendChild(entryElement);
                workbookGenre.serialize(entryElement);
            }
            for (WorkbookEntry workbookEntry : root.getUnmodifiableEntriesList()) {
                entryElement = document.createElement("entry");
                workbookElement.appendChild(entryElement);
                workbookEntry.serialize(entryElement);
            }
        }
    }
}

