/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model.maxflash;

import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.ByteArrayUtility;
import com.wudsn.tools.thecartstudio.model.ImportableCartridgeMenu;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;

public final class MaxflashMenu
extends ImportableCartridgeMenu {
    private static final int MENU_CONTENT_LENGTH = 8192;
    private static final byte[] MENU_TEXT_BYTES = ASCIIString.getBytes("Maxflash Menu");
    private static final byte[] MENU_ENTRY_TEXT_BYTES1 = ASCIIString.getBytes("<A>");
    private static final byte[] MENU_ENTRY_TEXT_BYTES2 = ASCIIString.getBytes(" A. ");

    public MaxflashMenu() {
        super("Maxfalsh Studio");
    }

    private int getMenuEntryIndex(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        int result = ByteArrayUtility.getIndexOf(content, 0, MENU_CONTENT_LENGTH, MENU_ENTRY_TEXT_BYTES1);
        if (result == -1) {
            result = ByteArrayUtility.getIndexOf(content, 0, MENU_CONTENT_LENGTH, MENU_ENTRY_TEXT_BYTES2);
        }
        return result;
    }

    @Override
    public boolean isContainedIn(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        int menuTextIndex = ByteArrayUtility.getIndexOf(content, 0, MENU_CONTENT_LENGTH, MENU_TEXT_BYTES);
        int menuEntryIndex = this.getMenuEntryIndex(content);
        return menuTextIndex >= 0 || menuEntryIndex == 1316 || menuEntryIndex == 1340 || menuEntryIndex == 1509 || menuEntryIndex == 1540 || menuEntryIndex == 1549 || menuEntryIndex == 1659 || menuEntryIndex == 1699 || menuEntryIndex == 1773 || menuEntryIndex == 1923 || menuEntryIndex == 2267;
    }

    @Override
    public int collectMenuEntries(Object owner, byte[] content, ImportableCartridgeMenu.Collector collector) {
        if (owner == null) {
            throw new IllegalArgumentException("Parameter 'owner' must not be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 'content' must not be null.");
        }
        if (collector == null) {
            throw new IllegalArgumentException("Parameter 'collector' must not be null.");
        }
        if (content.length > MENU_CONTENT_LENGTH) {
            byte[] signature = ASCIIString.getBytes("Maxflash Menu Software, Copyright 2009 Steven J Tucker");
            int signatureIndex = ByteArrayUtility.getIndexOf(content, 0, MENU_CONTENT_LENGTH, signature);
            int menuEntryIndex = this.getMenuEntryIndex(content);
            byte[] byArray = new byte[7];
            byArray[0] = 76;
            byArray[1] = -83;
            byArray[2] = -74;
            byArray[4] = 1;
            byArray[5] = -83;
            byArray[6] = -74;
            byte[] oldMenuVectors = byArray;
            int oldMenuVectorsIndex = content.length - 7;
            int oldMenuPointerIndex = oldMenuVectorsIndex - 2;
            boolean oldMenu = ByteArrayUtility.getIndexOf(content, oldMenuVectorsIndex, 7, oldMenuVectors) == oldMenuVectorsIndex;
            int menuVersion = -1;
            int menuEntriesOffset = -1;
            int menuEntriesSkip = 6;
            block0 : switch (signatureIndex) {
                case 7708: {
                    menuVersion = 0;
                    menuEntriesOffset = 4165;
                    break;
                }
                case 7733: {
                    menuVersion = 0;
                    menuEntriesOffset = 4190;
                    break;
                }
                case 8007: {
                    menuVersion = 2;
                    menuEntriesOffset = 4464;
                    break;
                }
                case 7990: {
                    menuVersion = 0;
                    menuEntriesOffset = 4446;
                    break;
                }
                default: {
                    switch (menuEntryIndex) {
                        case 1316: 
                        case 1340: 
                        case 1509: 
                        case 1540: 
                        case 1549: 
                        case 1659: 
                        case 1699: 
                        case 1773: 
                        case 1923: 
                        case 2267: {
                            menuVersion = 0;
                            menuEntriesOffset = menuEntryIndex;
                            menuEntriesSkip = 4;
                            break block0;
                        }
                    }
                    if (oldMenu) {
                        menuVersion = 1;
                        menuEntriesOffset = content.length - 8192 + this.getWord(content, oldMenuPointerIndex) - 40960;
                        break;
                    }
                    return 2;
                }
            }
            if (oldMenu) {
                collector.collectMenu(owner, "MaxflashMenu-old");
                int menuEntriesCount = this.getByte(content, menuEntriesOffset++);
                while (menuEntriesOffset < content.length && this.getByte(content, menuEntriesOffset) != 155) {
                    ++menuEntriesOffset;
                }
                int entryPointer = this.getWord(content, ++menuEntriesOffset);
                int j = 0;
                while (entryPointer != 0) {
                    char c;
                    entryPointer += content.length - 8192 - 8192 + 4;
                    StringBuffer titleBuffer = new StringBuffer(WorkbookEntry.TITLE_LENGTH);
                    while (entryPointer < content.length && (c = (char)this.getByte(content, entryPointer)) != '\u009b') {
                        titleBuffer.append(ATASCII[c]);
                        ++entryPointer;
                    }
                    collector.collectMenuEntry(owner, menuVersion, j, titleBuffer);
                    entryPointer = this.getWord(content, menuEntriesOffset += 2);
                    ++j;
                }
                menuEntriesCount = 1;
                if (menuVersion != 0) {
                    return 5;
                }
                return 4;
            }
            collector.collectMenu(owner, "MaxflashMenu-$" + Integer.toHexString(signatureIndex) + "-$" + Integer.toHexString(menuEntryIndex));
            int menuEntriesCount = content[menuEntriesOffset - 1] & 0xFF;
            if (menuEntriesCount >= 0) {
                menuEntriesCount = Math.min(menuEntriesCount, 70);
                int j = 0;
                while (j < menuEntriesCount) {
                    menuEntriesOffset += menuEntriesSkip;
                    StringBuffer titleBuffer = new StringBuffer(WorkbookEntry.TITLE_LENGTH);
                    while (menuEntriesOffset < MENU_CONTENT_LENGTH && (content[menuEntriesOffset] & 0xFF) != 155) {
                        char c = (char)(content[menuEntriesOffset] & 0xFF);
                        titleBuffer.append(c);
                        ++menuEntriesOffset;
                    }
                    ++menuEntriesOffset;
                    collector.collectMenuEntry(owner, menuVersion, j, titleBuffer);
                    ++j;
                }
                if (menuVersion != 0) {
                    return 5;
                }
                return 4;
            }
            return 3;
        }
        return 1;
    }
}

