/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.directory;

import com.wudsn.tools.base.gui.HTMLWriter;
import com.wudsn.tools.thecartstudio.directory.DirectoryWriter;

abstract class DirectoryEntry {
    private int id = -1;
    private String idString = "";
    private int bank;
    private int offset;
    protected int paddingBytes;

    protected DirectoryEntry() {
    }

    final void setId(int id) {
        this.id = id;
        this.idString = Integer.toString(id);
    }

    public final int getId() {
        return this.id;
    }

    public final String getIdString() {
        return this.idString;
    }

    public abstract int getRawSize();

    final void setBankAndOffset(int bank, int offset) {
        this.bank = bank;
        this.offset = offset;
    }

    public final int getBank() {
        return this.bank;
    }

    public final int getOffset() {
        return this.offset;
    }

    final void setPaddingBytes(int number) {
        this.paddingBytes = number;
    }

    abstract void writeAsBinary(DirectoryWriter var1);

    void writeAsHTML(HTMLWriter htmlWriter) {
        if (htmlWriter == null) {
            throw new IllegalArgumentException("Parameter 'htmlWriter' must not be null.");
        }
        htmlWriter.writeTableCell(this.idString);
        htmlWriter.writeTableCell("$" + Integer.toHexString(this.bank));
        htmlWriter.writeTableCell("$" + Integer.toHexString(this.offset));
        htmlWriter.writeTableCell("$" + Integer.toHexString(this.getRawSize()));
        htmlWriter.writeTableCell("$" + Integer.toHexString(this.paddingBytes));
    }
}

