/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.AttributeTable;
import com.wudsn.tools.base.gui.AttributeTableModel;
import com.wudsn.tools.base.gui.SimpleDialog;
import com.wudsn.tools.thecartstudio.Texts;
import com.wudsn.tools.thecartstudio.model.ContentType;
import com.wudsn.tools.thecartstudio.model.Preferences;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;

public final class ContentTypesDialog
extends SimpleDialog {
    private Preferences preferences;
    TableModel tableModel;
    private AttributeTable table;

    public ContentTypesDialog(JFrame parent, Preferences preferences) {
        super(parent, Texts.ContentTypesDialog_Title, false);
        if (preferences == null) {
            throw new IllegalArgumentException("Parameter 'parent, prefernces' must not be null.");
        }
        this.preferences = preferences;
    }

    @Override
    protected void initComponents(JDialog dialog) {
        Container pane = dialog.getContentPane();
        this.tableModel = new TableModel();
        this.table = new AttributeTable(this.tableModel, this.preferences, "contentTypesTable");
        this.table.setAutoCreateRowSorter(true);
        pane.add((Component)new JScrollPane(this.table), "Center");
        this.table.getRowSorter().toggleSortOrder(0);
        this.initButtonBar();
        dialog.setSize(640, 480);
    }

    public AttributeTable getTable() {
        return this.table;
    }

    private static final class TableModel
    extends AttributeTableModel {
        private List<ContentType> contentTypes;

        public TableModel() {
            this.addColumn(ContentType.Attributes.TEXT, 5);
            this.addColumn(ContentType.Attributes.ID, 4);
            this.addColumn(ContentType.Attributes.SIZE, 6);
            this.addColumn(ContentType.Attributes.CARTRIDGE_TYPE_NUMERIC_ID, 6);
            this.addColumn(ContentType.Attributes.THE_CART_MODE, 6, new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    int theCartMode = (Integer)value;
                    if (theCartMode == 0) {
                        this.setText("");
                    } else {
                        this.setText(TextUtility.formatAsDecimal(theCartMode));
                    }
                }
            }, null);
            this.addColumn(ContentType.Attributes.BANK_SIZE, 4);
            this.addColumn(ContentType.Attributes.INITIAL_BANK_NUMBER, 4);
            this.contentTypes = new ArrayList<ContentType>(ContentType.getValues());
            this.contentTypes.remove(ContentType.UNKNOWN);
            this.contentTypes.remove(ContentType.FILE_BINARY);
            this.contentTypes.remove(ContentType.FILE_EXECUTABLE);
        }

        @Override
        public int getRowCount() {
            return this.contentTypes.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ContentType contentType = this.contentTypes.get(row);
            switch (column) {
                case 1: {
                    return contentType.getId();
                }
                case 0: {
                    return contentType.getText();
                }
                case 2: {
                    return contentType.getCartridgeType().getSizeInKB() * 1024;
                }
                case 3: {
                    return contentType.getCartridgeType().getNumericId();
                }
                case 4: {
                    return contentType.getTheCartMode();
                }
                case 5: {
                    return contentType.getCartridgeType().getBankSize();
                }
                case 6: {
                    return contentType.getCartridgeType().getInitialBankNumber();
                }
            }
            throw new IllegalArgumentException("Invalid column " + column + ".");
        }

        private static final class Columns {
            public static final int TEXT = 0;
            public static final int ID = 1;
            public static final int SIZE_IN_KB = 2;
            public static final int CARTRDIGE_TYPE_NUMERIC_ID = 3;
            public static final int THE_CART_MODE = 4;
            public static final int BANK_SIZE = 5;
            public static final int START_BANK_NUMBER = 6;

            private Columns() {
            }
        }
    }
}

