/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.gui.ColorField;
import com.wudsn.tools.base.gui.ElementFactory;
import com.wudsn.tools.base.gui.ModalDialog;
import com.wudsn.tools.base.gui.SpringUtilities;
import com.wudsn.tools.base.gui.ValueSetField;
import com.wudsn.tools.thecartstudio.Actions;
import com.wudsn.tools.thecartstudio.DataTypes;
import com.wudsn.tools.thecartstudio.Texts;
import com.wudsn.tools.thecartstudio.model.Language;
import com.wudsn.tools.thecartstudio.model.Preferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JTextField;

public final class OptionsDialog
extends ModalDialog {
    private static final int ROWS = 9;
    private final ValueSetField<Language> languageField;
    private final JCheckBox updateCheckIndicatorField;
    private final ColorField freeBankColorField;
    private final JTextField emulatorExecuablePathField;
    private final ColorField reservedBankColorField;
    private final ColorField reservedUserSpaceBankColorField;
    private final ColorField usedOddBankColorField;
    private final ColorField usedEvenBankColorField;
    private final ColorField conflictBankColorField;
    Preferences preferences;

    public OptionsDialog(JFrame parent) {
        super(parent, Texts.OptionsDialog_Title);
        this.languageField = SpringUtilities.createValueSetField(this.fieldsPane, DataTypes.Preferences_Language, Language.class);
        this.updateCheckIndicatorField = SpringUtilities.createCheckBox(this.fieldsPane, DataTypes.Preferences_UpdateCheckIndicator);
        this.emulatorExecuablePathField = SpringUtilities.createTextField(this.fieldsPane, DataTypes.Preferences_EmulatorExecutablePath);
        this.freeBankColorField = SpringUtilities.createColorField(this.fieldsPane, DataTypes.Preferences_FreeBankColor);
        this.reservedBankColorField = SpringUtilities.createColorField(this.fieldsPane, DataTypes.Preferences_ReservedBankColor);
        this.reservedUserSpaceBankColorField = SpringUtilities.createColorField(this.fieldsPane, DataTypes.Preferences_ReservedUserSpaceBankColor);
        this.usedOddBankColorField = SpringUtilities.createColorField(this.fieldsPane, DataTypes.Preferences_UsedOddBankColor);
        this.usedEvenBankColorField = SpringUtilities.createColorField(this.fieldsPane, DataTypes.Preferences_UsedEvenBankColor);
        this.conflictBankColorField = SpringUtilities.createColorField(this.fieldsPane, DataTypes.Preferences_ConflictBankColor);
        JButton resetButton = ElementFactory.createButton(Actions.Preferences_ButtonBar_Reset);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.preferences.setDefaultBankColors();
                OptionsDialog.this.dataToUi();
            }
        });
        this.addButtonBarButton(resetButton);
    }

    public boolean showModal(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
        }
        SpringUtilities.makeCompactGrid(this.fieldsPane, 9, 2, 6, 6, 6, 6);
        this.preferences = new Preferences();
        preferences.copyTo(this.preferences);
        this.showModal(this.languageField);
        if (this.okPressed) {
            this.preferences.copyTo(preferences);
        }
        return this.okPressed;
    }

    @Override
    protected void dataFromUi() {
        this.preferences.setLanguage(this.languageField.getValue());
        this.preferences.setUpdateCheckIndicator(this.updateCheckIndicatorField.isSelected());
        this.preferences.setEmulatorExecutablePath(this.emulatorExecuablePathField.getText());
        this.preferences.setFreeBankColor(this.freeBankColorField.getValue());
        this.preferences.setReservedBankColor(this.reservedBankColorField.getValue());
        this.preferences.setReservedUserSpaceBankColor(this.reservedUserSpaceBankColorField.getValue());
        this.preferences.setUsedOddBankColor(this.usedOddBankColorField.getValue());
        this.preferences.setUsedEvenBankColor(this.usedEvenBankColorField.getValue());
        this.preferences.setConflictBankColor(this.conflictBankColorField.getValue());
    }

    @Override
    protected void dataToUi() {
        this.languageField.setValue(this.preferences.getLanguage());
        this.updateCheckIndicatorField.setSelected(this.preferences.getUpdateCheckIndicator());
        this.emulatorExecuablePathField.setText(this.preferences.getEmulatorExecutablePath());
        this.freeBankColorField.setValue(this.preferences.getFreeBankColor());
        this.reservedBankColorField.setValue(this.preferences.getReservedBankColor());
        this.reservedUserSpaceBankColorField.setValue(this.preferences.getReservedUserSpaceBankColor());
        this.usedOddBankColorField.setValue(this.preferences.getUsedOddBankColor());
        this.usedEvenBankColorField.setValue(this.preferences.getUsedEvenBankColor());
        this.conflictBankColorField.setValue(this.preferences.getConflictBankColor());
    }
}

