/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.console.Console;
import com.wudsn.tools.base.console.ConsoleCommandExecution;
import com.wudsn.tools.base.console.ConsoleCommandParser;
import com.wudsn.tools.thecartstudio.Actions;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.CartridgeTypeSampleCreator;
import com.wudsn.tools.thecartstudio.model.Exporter;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookAddEntriesCallback;
import com.wudsn.tools.thecartstudio.model.WorkbookExport;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class TheCartStudioConsole {
    private ConsoleCommandParser consoleCommandParser = new ConsoleCommandParser("-jar TheCartStudio.jar");

    public TheCartStudioConsole() {
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_New, "new");
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_Open, "open").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_Save, "save");
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_SaveAs, "saveAs").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_Close, "close");
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_ExportToBinImage, "exportToBinImage").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_ExportToCarImage, "exportToCarImage").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_ExportToAtrImage, "exportToAtrImage").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_File_ExportToAtrImages, "exportToAtrImages").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_Edit_AddEntries, "addEntries").addParameter(Workbook.Attributes.FILE_PATH, 2);
        this.consoleCommandParser.addCommand(Actions.MainMenu_Edit_AssignNewBanks, "assignNewBanks");
        this.consoleCommandParser.addCommand(Actions.Console_CreateSampleFiles, "createSampleFiles").addParameter(Workbook.Attributes.FOLDER_PATH, 2);
    }

    public boolean runConsoleCommands(String[] args, boolean mandatory, Workbook workbook, MessageQueue messageQueue) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (this.consoleCommandParser.parse(args, mandatory, messageQueue)) {
            return true;
        }
        List<ConsoleCommandExecution> parseResult = this.consoleCommandParser.getParseResult();
        Console console = this.consoleCommandParser.getConsole();
        if (!parseResult.isEmpty()) {
            boolean errorOccurred = false;
            int i = 0;
            while (i < parseResult.size() && !errorOccurred) {
                Exporter exporter;
                WorkbookExport workbookExport;
                File file;
                ConsoleCommandExecution commandExecution = parseResult.get(i);
                messageQueue.clear();
                messageQueue.sendMessage(this, null, com.wudsn.tools.base.Messages.S254, commandExecution.toString());
                String actionCommand = commandExecution.getConsoleCommand().getActionCommand();
                if (actionCommand.equals("new")) {
                    if (workbook.create(messageQueue)) {
                        messageQueue.sendMessage(this, null, Messages.I140, new String[0]);
                    }
                } else if (actionCommand.equals("open")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FILE_PATH);
                    workbook.open(file, messageQueue);
                } else if (actionCommand.equals("save")) {
                    file = workbook.getFile();
                    if (file == null) {
                        messageQueue.sendMessage(this, null, Messages.E141, new String[0]);
                    } else {
                        workbook.save(file, messageQueue);
                        if (!messageQueue.containsError()) {
                            messageQueue.sendMessage(this, null, Messages.I106, new String[0]);
                        }
                    }
                } else if (actionCommand.equals("saveAs")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FILE_PATH);
                    workbook.save(file, messageQueue);
                    if (!messageQueue.containsError()) {
                        messageQueue.sendMessage(this, null, Messages.I106, new String[0]);
                    }
                } else if (actionCommand.equals("close")) {
                    workbook.close();
                    if (!messageQueue.containsError()) {
                        messageQueue.sendMessage(this, null, Messages.I107, new String[0]);
                    }
                } else if (actionCommand.equals("exportToBinImage")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FILE_PATH);
                    workbookExport = workbook.export(1, messageQueue);
                    if (!messageQueue.containsError()) {
                        exporter = new Exporter(workbookExport, messageQueue);
                        exporter.exportAsBinImage(file);
                    }
                } else if (actionCommand.equals("exportToCarImage")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FILE_PATH);
                    workbookExport = workbook.export(2, messageQueue);
                    if (!messageQueue.containsError()) {
                        exporter = new Exporter(workbookExport, messageQueue);
                        exporter.exportAsCarImage(file);
                    }
                } else if (actionCommand.equals("exportToAtrImage")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FILE_PATH);
                    workbookExport = workbook.export(3, messageQueue);
                    if (!messageQueue.containsError()) {
                        exporter = new Exporter(workbookExport, messageQueue);
                        exporter.exportAsAtrImage(file);
                    }
                } else if (actionCommand.equals("exportToAtrImages")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FILE_PATH);
                    workbookExport = workbook.export(4, messageQueue);
                    if (!messageQueue.containsError()) {
                        exporter = new Exporter(workbookExport, messageQueue);
                        exporter.exportAsAtrImages(file);
                    }
                } else if (actionCommand.equals("addEntries")) {
                    List<String> parameterValues = commandExecution.getParameterValuesAsString(Workbook.Attributes.FILE_PATH);
                    ArrayList<File> filesList = new ArrayList<File>();
                    for (String parameterValue : parameterValues) {
                        File file2 = new File(parameterValue);
                        String fileName = file2.getName();
                        if (fileName.contains("*")) {
                            final Pattern pattern = Pattern.compile(fileName.replaceAll("\\*", ".*"));
                            File[] files = file2.getParentFile().listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return pattern.matcher(name).matches();
                                }
                            });
                            if (files == null) continue;
                            File[] fileArray = files;
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File otherFile = fileArray[n2];
                                filesList.add(otherFile);
                                ++n2;
                            }
                            continue;
                        }
                        filesList.add(file2);
                    }
                    WorkbookAddEntriesCallback callback = new WorkbookAddEntriesCallback(){

                        @Override
                        public int confirmAdd(String existingEntryTitle, String existingFileName, String newFilePath, String renamedFileName) {
                            return 1;
                        }
                    };
                    workbook.addEntries(filesList.toArray(new File[filesList.size()]), callback, messageQueue);
                    if (!messageQueue.containsError()) {
                        messageQueue.sendMessage(workbook, null, Messages.I108, TextUtility.formatAsDecimal(callback.getAddedEntriesCount()), TextUtility.formatAsDecimal(callback.getUpdatesEntriesCount()), TextUtility.formatAsDecimal(callback.getSkippedEntriesCount()));
                    }
                } else if (actionCommand.equals("assignNewBanks")) {
                    workbook.assignNewBanks(messageQueue);
                    if (!messageQueue.containsError()) {
                        messageQueue.sendMessage(workbook, null, Messages.I125, new String[0]);
                    }
                } else if (actionCommand.equals("createSampleFiles")) {
                    file = commandExecution.getParameterValueAsFile(Workbook.Attributes.FOLDER_PATH);
                    CartridgeTypeSampleCreator instance = new CartridgeTypeSampleCreator();
                    try {
                        instance.run(file);
                    }
                    catch (CoreException ex) {
                        messageQueue.sendMessage(ex.createMessageQueueEntry(null, null));
                    }
                } else {
                    throw new RuntimeException("Unhandled action command '" + actionCommand + "'.");
                }
                errorOccurred = messageQueue.containsError();
                console.displayMessageQueue(messageQueue);
                ++i;
            }
            return true;
        }
        return false;
    }
}

