/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.TheCartStudio;
import com.wudsn.tools.thecartstudio.model.Preferences;
import com.wudsn.tools.thecartstudio.model.ReservedContentProvider;
import com.wudsn.tools.thecartstudio.model.ReservedContentProviderFactory;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookBank;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import com.wudsn.tools.thecartstudio.ui.BankColorUtility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class WorkbookBanksPanel
extends JPanel {
    private final TheCartStudio studio;
    private final Preferences preferences;
    private final Workbook workbook;
    private List<WorkbookBank> banksList;
    private int startX;
    private int startY;
    private int banksPerRow;
    private int rows;
    private int barSize;

    public WorkbookBanksPanel(TheCartStudio studio, Preferences preferences, Workbook workbook) {
        if (studio == null) {
            throw new IllegalArgumentException("Parameter 'studio' must not be null.");
        }
        if (preferences == null) {
            throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
        }
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        this.studio = studio;
        this.preferences = preferences;
        this.workbook = workbook;
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                WorkbookBanksPanel.this.computeToolTipText(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){
            private int defaultInitialDelay;
            private int defaultDismissDelay;

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager manager = ToolTipManager.sharedInstance();
                this.defaultInitialDelay = manager.getInitialDelay();
                this.defaultDismissDelay = manager.getDismissDelay();
                manager.setInitialDelay(50);
                manager.setDismissDelay(60000);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager manager = ToolTipManager.sharedInstance();
                manager.setInitialDelay(this.defaultInitialDelay);
                manager.setDismissDelay(this.defaultDismissDelay);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                WorkbookBanksPanel.this.showWorkbookEntry(e);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        int minBarSize = 4;
        super.paintComponent(g);
        this.barSize = 0;
        if (!this.workbook.isValid()) {
            return;
        }
        WorkbookRoot root = this.workbook.getRoot();
        if (!root.isBanksListInitialized()) {
            return;
        }
        this.banksList = root.getBanksList();
        if (this.banksList.isEmpty()) {
            return;
        }
        Dimension d = this.getSize();
        int clientWidth = d.width;
        int clientHeight = d.height;
        if (clientWidth == 0 || clientHeight == 0) {
            return;
        }
        int size = this.banksList.size();
        double clientScale = 0.98;
        double area = (double)(clientWidth * clientHeight) * (clientScale * clientScale);
        double side = Math.sqrt(area / (double)size);
        this.banksPerRow = (int)((double)clientWidth * clientScale / side);
        this.rows = (size + this.banksPerRow - 1) / this.banksPerRow;
        this.barSize = (int)side;
        this.barSize = Math.max(this.barSize, 4);
        int usedWidth = this.barSize * this.banksPerRow;
        int usedHeight = this.barSize * this.rows;
        this.startX = 0;
        this.startY = 0;
        if (usedWidth < clientWidth) {
            this.startX = (clientWidth - usedWidth) / 2;
        }
        if (usedHeight < clientHeight) {
            this.startY = (clientHeight - usedHeight) / 2;
        }
        WorkbookEntry lastEntry = null;
        boolean lastColorToggle = false;
        int bankNumber = 0;
        int positionY = 0;
        while (positionY < this.rows) {
            int positionX = 0;
            while (positionX < this.banksPerRow && bankNumber < this.banksList.size()) {
                Color fillColor;
                WorkbookBank bank = this.banksList.get(bankNumber);
                Color borderColor = Color.BLACK;
                int usedBanksCount = 1;
                if (bank.isReserved()) {
                    fillColor = this.preferences.getReservedBankColor();
                    ReservedContentProvider reservedContentProvider = bank.getReservedContentProvider();
                    if (reservedContentProvider instanceof ReservedContentProviderFactory.UserSpaceContentProvider) {
                        fillColor = this.preferences.getReservedUserSpaceBankColor();
                    }
                    if ((usedBanksCount = reservedContentProvider.getStartBankNumber() + reservedContentProvider.getRequiredBanksCount() - bankNumber) > this.banksPerRow - positionX) {
                        usedBanksCount = this.banksPerRow - positionX;
                    }
                    if (!bank.getEntries().isEmpty()) {
                        fillColor = this.preferences.getConflictBankColor();
                    }
                } else {
                    switch (bank.getEntries().size()) {
                        case 0: {
                            borderColor = Color.LIGHT_GRAY;
                            fillColor = this.preferences.getFreeBankColor();
                            break;
                        }
                        case 1: {
                            WorkbookEntry entry = bank.getEntries().get(0);
                            usedBanksCount = entry.getStartBankNumber() + entry.getRequiredBanksCount() - bankNumber;
                            if (usedBanksCount > this.banksPerRow - positionX) {
                                usedBanksCount = this.banksPerRow - positionX;
                            }
                            if (entry != lastEntry) {
                                lastColorToggle = !lastColorToggle;
                                lastEntry = entry;
                            }
                            if (lastColorToggle) {
                                fillColor = this.preferences.getUsedOddBankColor();
                                break;
                            }
                            fillColor = this.preferences.getUsedEvenBankColor();
                            break;
                        }
                        default: {
                            fillColor = this.preferences.getConflictBankColor();
                        }
                    }
                }
                int cellX = positionX * this.barSize + this.startX;
                int cellY = positionY * this.barSize + this.startY;
                int fillWidth = this.barSize * usedBanksCount;
                if (this.barSize > 4) {
                    if (fillColor != null) {
                        g.setColor(fillColor);
                        g.fillRect(cellX + 1, cellY + 1, fillWidth - 3, this.barSize - 3);
                    }
                    int j = 1;
                    while (j < usedBanksCount) {
                        g.setColor(BankColorUtility.getLineColor(fillColor));
                        int x = cellX + 1 + j * this.barSize;
                        g.drawLine(x, cellY + 1, x, cellY + 1 + this.barSize - 3);
                        ++j;
                    }
                    g.setColor(borderColor);
                    g.drawRect(cellX, cellY, fillWidth - 2, this.barSize - 2);
                } else {
                    if (fillColor != null) {
                        g.setColor(fillColor);
                    } else {
                        g.setColor(borderColor);
                    }
                    g.fillRect(cellX, cellY, fillWidth - 2, this.barSize - 2);
                }
                positionX += usedBanksCount;
                bankNumber += usedBanksCount;
            }
            ++positionY;
        }
        g.setColor(Color.white);
    }

    private WorkbookBank getBankAt(MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter 'e' must not be null.");
        }
        if (this.barSize > 0) {
            int bankNumber;
            Point p = e.getPoint();
            int positionX = p.x - this.startX;
            int positionY = p.y - this.startY;
            if (positionX >= 0 && positionY >= 0 && (positionX /= this.barSize) < this.banksPerRow && (positionY /= this.barSize) < this.rows && (bankNumber = positionX + positionY * this.banksPerRow) < this.banksList.size()) {
                return this.banksList.get(bankNumber);
            }
        }
        return null;
    }

    void computeToolTipText(MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter 'e' must not be null.");
        }
        String text = null;
        WorkbookBank bank = this.getBankAt(e);
        if (bank != null) {
            String bankOffsetText;
            int bankNumber = bank.getNumber();
            List<WorkbookEntry> entries = bank.getEntries();
            String bankNumberText = TextUtility.formatAsDecimal(bankNumber);
            WorkbookRoot root = this.workbook.getRoot();
            int bankSize = root.getBankSize();
            int maxBankOffsetValue = root.getBankCount() * bankSize;
            int bankOffsetStart = bank.getNumber() * bankSize;
            int flashBlockSize = root.getCartridgeType().getFlashBlockSize();
            if (flashBlockSize == 0) {
                bankOffsetText = Messages.I127.format(TextUtility.formatAsHexaDecimal(bankOffsetStart, maxBankOffsetValue), TextUtility.formatAsHexaDecimal(bankOffsetStart + bankSize - 1, maxBankOffsetValue));
            } else {
                int blockNumber = bankOffsetStart / flashBlockSize;
                bankOffsetText = Messages.I128.format(TextUtility.formatAsHexaDecimal(bankOffsetStart, maxBankOffsetValue), TextUtility.formatAsHexaDecimal(bankOffsetStart + bankSize - 1, maxBankOffsetValue), TextUtility.formatAsDecimal(blockNumber));
            }
            ReservedContentProvider reservedContentProvider = bank.getReservedContentProvider();
            if (entries.isEmpty()) {
                text = bank.isReserved() ? Messages.I121.format(bankNumberText, reservedContentProvider.getTitle(), bankOffsetText) : Messages.I120.format(bankNumberText, bankOffsetText);
            } else {
                text = bank.isReserved() ? Messages.I121.format(bankNumberText, reservedContentProvider.getTitle(), "") : "";
                if (entries.size() == 1) {
                    WorkbookEntry entry = entries.get(0);
                    text = String.valueOf(text) + Messages.I122.format(bankNumberText, entry.getTitle(), bankOffsetText, entry.getFileName(), TextUtility.formatAsDecimal(bankNumber + 1 - entry.getStartBankNumber()), TextUtility.formatAsDecimal(entry.getRequiredBanksCount()));
                } else {
                    text = String.valueOf(text) + Messages.I123.format(bankNumberText, bankOffsetText);
                }
            }
            text = "<html>" + text + "</html>";
        }
        this.setToolTipText(text);
    }

    void showWorkbookEntry(MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter 'e' must not be null.");
        }
        WorkbookBank bank = this.getBankAt(e);
        if (bank != null && bank.getEntries().size() == 1) {
            this.studio.performShowWorkbookEntry(bank.getEntries().get(0), WorkbookEntry.Attributes.ID);
        }
    }
}

