/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.directory;

import com.wudsn.tools.base.gui.HTMLWriter;
import com.wudsn.tools.thecartstudio.directory.DirectoryEntry;
import com.wudsn.tools.thecartstudio.directory.DirectoryWriter;
import java.util.ArrayList;
import java.util.List;

public class DirectoryRecord
extends DirectoryEntry {
    private String title;
    private List<String> words = new ArrayList<String>();

    public String getTitle() {
        return this.title;
    }

    void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        this.title = title;
    }

    public List<String> getWords() {
        return this.words;
    }

    @Override
    public int getRawSize() {
        return 1 + this.title.length();
    }

    @Override
    void writeAsBinary(DirectoryWriter directoryWriter) {
        if (directoryWriter == null) {
            throw new IllegalArgumentException("Parameter 'directoryWriter' must not be null.");
        }
        directoryWriter.writeByte(this.title.length());
        directoryWriter.writeString(this.title);
        directoryWriter.writePaddingBytes(this.paddingBytes);
    }

    @Override
    void writeAsHTML(HTMLWriter htmlWriter) {
        if (htmlWriter == null) {
            throw new IllegalArgumentException("Parameter 'htmlWriter' must not be null.");
        }
        super.writeAsHTML(htmlWriter);
        htmlWriter.writeTableCell(this.title);
        htmlWriter.writeTableCell(HTMLWriter.getString(this.words));
    }

    public String toString() {
        return "id=" + this.getId() + "/title=" + this.title + "/words=" + this.words;
    }
}

