/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.repository.RepositoryValidation;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.WorkbookBank;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookEntryValidation;
import com.wudsn.tools.thecartstudio.model.WorkbookGenreValidation;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import java.util.List;

public final class WorkbookRootValidation {
    private WorkbookGenreValidation genreValidation = WorkbookGenreValidation.createInstance();
    private WorkbookEntryValidation entryValidation = WorkbookEntryValidation.createInstance();

    private WorkbookRootValidation() {
    }

    public static final WorkbookRootValidation createInstance() {
        return new WorkbookRootValidation();
    }

    public void validateSave(WorkbookRoot root, MessageQueue messageQueue, boolean withEntries) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        int userSpaceAlignmentSize = root.getUserSpaceAlignmentSize();
        if (userSpaceAlignmentSize > 0) {
            root.setUserSpaceSize(userSpaceAlignmentSize * ((root.getUserSpaceSize() + userSpaceAlignmentSize - 1) / userSpaceAlignmentSize));
        }
        RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
        rv.isStringValid(root, WorkbookRoot.Attributes.TITLE, root.getTitle());
        boolean sizeValid = rv.isLongValid(root, WorkbookRoot.Attributes.BANK_COUNT, 1L, 65536L, root.getBankCount());
        if (sizeValid &= rv.isLongValid(root, WorkbookRoot.Attributes.BANK_SIZE, 1024L, 65536L, root.getBankSize())) {
            rv.isMemorySizeValid(root, WorkbookRoot.Attributes.BANK_SIZE, 0L, root.getImageSize(), root.getUserSpaceSize());
        }
        if (!root.getFlashTargetType().getSupportedCartridgeMenuTypes().contains(root.getCartridgeMenuType())) {
            messageQueue.sendMessage(root, WorkbookRoot.Attributes.CARTRDIGE_MENU_TYPE, Messages.E412, WorkbookRoot.Attributes.CARTRDIGE_MENU_TYPE.getDataType().getLabelWithoutMnemonics(), root.getCartridgeMenuType().getText(), root.getFlashTargetType().getText());
        }
        this.genreValidation.validateSave(root, messageQueue);
        if (withEntries) {
            for (WorkbookEntry entry : root.getUnmodifiableEntriesList()) {
                this.entryValidation.validateSave(root, entry, messageQueue);
            }
        }
    }

    public void validateExport(WorkbookRoot root, MessageQueue messageQueue) {
        this.validateSave(root, messageQueue, true);
        if (messageQueue.containsError()) {
            return;
        }
        for (WorkbookEntry entry : root.getUnmodifiableEntriesList()) {
            this.entryValidation.validateExport(root, entry, messageQueue);
        }
        if (messageQueue.containsError()) {
            return;
        }
        for (WorkbookBank bank : root.getBanksList()) {
            List<WorkbookEntry> entries = bank.getEntries();
            if (bank.isReserved() && entries.size() > 0) {
                messageQueue.sendMessage(bank, WorkbookBank.Attributes.NUMBER, Messages.E401, TextUtility.formatAsDecimal(bank.getNumber()), entries.get(0).getTitle());
                continue;
            }
            if (entries.size() <= 1) continue;
            messageQueue.sendMessage(bank, WorkbookBank.Attributes.NUMBER, Messages.E402, TextUtility.formatAsDecimal(bank.getNumber()));
        }
    }
}

