/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.Actions;
import com.wudsn.tools.base.gui.AttributeTable;
import com.wudsn.tools.base.gui.AttributeTableModel;
import com.wudsn.tools.base.gui.ElementFactory;
import com.wudsn.tools.base.repository.DataType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class AttributeTableColumnChooser
extends MouseAdapter
implements ActionListener {
    public static final String FIXED_COLUMNS = "FixedColumns";
    private static final String COLUMN_INDEX = "ColumnIndex";
    private static final String JTABLE = "AttributeTable";
    private static final String SET_COLUMN_DEFAULTS = "setColumnDefaults";
    private static WeakReference<AttributeTableColumnChooser> ref = null;

    private AttributeTableColumnChooser() {
    }

    private static AttributeTableColumnChooser getInstance() {
        if (ref == null || ref.get() == null) {
            ref = new WeakReference<AttributeTableColumnChooser>(new AttributeTableColumnChooser());
        }
        return (AttributeTableColumnChooser)ref.get();
    }

    public static void install(AttributeTable table) {
        table.getTableHeader().addMouseListener(AttributeTableColumnChooser.getInstance());
    }

    public static void uninstall(AttributeTable table) {
        table.getTableHeader().removeMouseListener(AttributeTableColumnChooser.getInstance());
    }

    public static void hideColumns(TableColumnModel columnModel, int[] modelColumnIndexes) {
        if (columnModel == null) {
            throw new IllegalArgumentException("Parameter 'columnModel' must not be null.");
        }
        if (modelColumnIndexes == null) {
            throw new IllegalArgumentException("Parameter 'modelColumnIndexes' must not be null.");
        }
        TableColumn[] column = new TableColumn[modelColumnIndexes.length];
        int i = 0;
        int j = 0;
        while (i < columnModel.getColumnCount()) {
            TableColumn col = columnModel.getColumn(i);
            if (col.getModelIndex() == modelColumnIndexes[j]) {
                column[j++] = col;
                if (j >= modelColumnIndexes.length) break;
            }
            ++i;
        }
        i = 0;
        while (i < column.length) {
            columnModel.removeColumn(column[i]);
            ++i;
        }
    }

    private static boolean isVisibleColumn(TableColumnModel model, int modelCol) {
        int i = 0;
        while (i < model.getColumnCount()) {
            if (model.getColumn(i).getModelIndex() == modelCol) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.maybePopup(me);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybePopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.maybePopup(e);
    }

    private void maybePopup(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        JTableHeader header = (JTableHeader)me.getComponent();
        AttributeTable table = (AttributeTable)header.getTable();
        AttributeTableModel tableModel = (AttributeTableModel)table.getModel();
        TableColumnModel columnModel = table.getColumnModel();
        JPopupMenu popup = new JPopupMenu();
        int i = 0;
        while (i < tableModel.getColumnCount()) {
            AttributeTableModel.Column column = tableModel.getColumn(i);
            DataType dataType = column.getAttribute().getDataType();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem();
            ElementFactory.setButtonTextAndMnemonic(item, dataType.getLabel(), dataType.getToolTip());
            item.setSelected(AttributeTableColumnChooser.isVisibleColumn(columnModel, i));
            item.setEnabled(!column.isFixed());
            item.putClientProperty(COLUMN_INDEX, i);
            item.putClientProperty(JTABLE, header.getTable());
            item.addActionListener(this);
            popup.add(item);
            ++i;
        }
        popup.addSeparator();
        JMenuItem item = ElementFactory.createMenuItem(Actions.AttributeTable_HeaderPopupMenuSetColumnDefaults, SET_COLUMN_DEFAULTS);
        item.putClientProperty(JTABLE, header.getTable());
        item.addActionListener(this);
        popup.add(item);
        popup.show(header, me.getX(), me.getY());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem item = (JMenuItem)actionEvent.getSource();
        AttributeTable table = (AttributeTable)item.getClientProperty(JTABLE);
        if (actionEvent.getActionCommand().equals(SET_COLUMN_DEFAULTS)) {
            table.setColumnDefaults();
        } else {
            Integer columnIndex = (Integer)item.getClientProperty(COLUMN_INDEX);
            table.setColumnVisible(columnIndex, item.isSelected());
        }
    }
}

