/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CSVReader {
    public static final int MAX_LINE_SIZE = 1024;
    private static final int CR = 13;
    private static final int LF = 10;
    private char separatorChar;
    private Reader reader;
    private int newLineChars;
    private Map<String, Integer> headerMap;
    private String[] columnHeaders;
    private String[] columnValues;
    private int rowNumber;

    public void open(File file, char separatorChar, String charsetName) {
        if (!file.exists()) {
            throw new RuntimeException("File does not exist: " + file.getAbsolutePath());
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("Parameter 'charsetName' must not be null.");
        }
        try {
            this.open(new FileInputStream(file), new FileInputStream(file), separatorChar, charsetName);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found", ex);
        }
    }

    public void open(InputStream headerInputStream, InputStream bodyInputStream, char separatorChar, String charsetName) {
        if (headerInputStream == null) {
            throw new IllegalArgumentException("Parameter 'headerInputStream' must not be null.");
        }
        if (bodyInputStream == null) {
            throw new IllegalArgumentException("Parameter 'bodyInputStream' must not be null.");
        }
        this.separatorChar = separatorChar;
        if (charsetName == null) {
            throw new IllegalArgumentException("Parameter 'charsetName' must not be null.");
        }
        this.newLineChars = 1;
        this.reader = new InputStreamReader(headerInputStream, Charset.forName(charsetName));
        try {
            int c = this.reader.read();
            while (c != -1) {
                if (c == 13 || c == 10) {
                    c = this.reader.read();
                    if (c == 13 || c == 10) {
                        ++this.newLineChars;
                    }
                    c = -1;
                    continue;
                }
                c = this.reader.read();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file", ex);
        }
        this.reader = new InputStreamReader(bodyInputStream, Charset.forName(charsetName));
        this.headerMap = new HashMap<String, Integer>();
        int columnIndex = 0;
        ArrayList<String> columnHeaderList = new ArrayList<String>();
        try {
            StringBuilder builder = new StringBuilder();
            boolean completed = false;
            do {
                int c;
                if ((c = this.reader.read()) == -1) {
                    completed = true;
                    this.reader.close();
                    continue;
                }
                if (c == 13 || c == 10) {
                    completed = true;
                    if (this.newLineChars != 2 || (c = this.reader.read()) == 13 || c == 10) continue;
                    throw new RuntimeException("Inconsistent newlines in rowNumber " + this.rowNumber + ".");
                }
                if (c == separatorChar) {
                    String columnHeader = builder.toString();
                    columnHeaderList.add(columnHeader);
                    this.headerMap.put(columnHeader, columnIndex);
                    ++columnIndex;
                    builder.setLength(0);
                    continue;
                }
                builder.append((char)c);
            } while (!completed);
            if (builder.length() > 0) {
                String columnHeader = builder.toString();
                columnHeaderList.add(columnHeader);
                this.headerMap.put(columnHeader, columnIndex);
                ++columnIndex;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file", ex);
        }
        this.columnHeaders = columnHeaderList.toArray(new String[columnIndex]);
        this.columnValues = new String[columnIndex];
        this.rowNumber = 1;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Parameter 'columnName' must not be null.");
        }
        Integer index = this.headerMap.get(columnName);
        if (index == null) {
            throw new RuntimeException("Illegal column '" + columnName + "'. Defined column names are: " + this.headerMap.keySet().toString());
        }
        return index;
    }

    public boolean readNextRow() {
        StringBuilder builder = new StringBuilder();
        boolean completed = false;
        boolean eof = false;
        int i = 0;
        while (i < this.columnValues.length) {
            this.columnValues[i] = "";
            ++i;
        }
        int columnIndex = 0;
        boolean quoteMode = false;
        try {
            do {
                int c;
                if ((c = this.reader.read()) == -1) {
                    completed = true;
                    eof = true;
                    continue;
                }
                if (quoteMode) {
                    if (c == 34) {
                        quoteMode = false;
                        continue;
                    }
                    builder.append((char)c);
                    continue;
                }
                if (c == 13 || c == 10) {
                    completed = true;
                    ++this.rowNumber;
                    continue;
                }
                if (c == this.separatorChar) {
                    String columnValue = builder.toString();
                    if (quoteMode) {
                        columnValue = columnValue.substring(columnValue.length() - 1);
                    }
                    this.columnValues[columnIndex++] = columnValue;
                    quoteMode = false;
                    builder.setLength(0);
                    continue;
                }
                if (builder.length() == 0 && c == 34) {
                    quoteMode = true;
                    continue;
                }
                builder.append((char)c);
            } while (!completed);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file", ex);
        }
        if (builder.length() > 0) {
            String columnValue = builder.toString();
            if (quoteMode) {
                columnValue = columnValue.substring(columnValue.length() - 1);
            }
            if (columnIndex > this.columnValues.length - 1) {
                this.columnValues[columnIndex] = columnValue;
            }
            this.columnValues[columnIndex] = columnValue;
        }
        return !eof;
    }

    public String getColumnHeader(int index) {
        return this.columnHeaders[index];
    }

    public String getColumnValue(int index) {
        return this.columnValues[index];
    }

    public String getColumnValue(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Parameter 'columnName' must not be null.");
        }
        int index = this.getColumnIndex(columnName);
        return this.columnValues[index];
    }
}

