/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

public final class AtrFile {
    public static final int HEADER_SIZE = 16;
    public static final int PARAGRAPH_SIZE = 16;
    public static final int SECTOR_SIZE_8K = 8192;
    public static final int SECTOR_SIZE_SD = 128;
    public static final int SECTOR_SIZE_DD = 256;
    public static final int BOOT_SECTORS_SIZE_SD = 384;
    private static final byte[] bootCode;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[3] = 7;
        byArray[4] = 7;
        byArray[5] = 7;
        byArray[6] = 56;
        byArray[7] = 96;
        bootCode = byArray;
    }

    private AtrFile() {
    }

    public static byte[] createHeader(int dataSize, int sectorSize) {
        if (sectorSize < 128) {
            throw new IllegalArgumentException("Parameter 'sectorSize' must not be less than 128, actual value was " + sectorSize + ".");
        }
        if (sectorSize > 65535) {
            throw new IllegalArgumentException("Parameter 'sectorSize' must not be largen than 65535, actual value was " + sectorSize + ".");
        }
        dataSize = sectorSize == 256 && dataSize >= 384 ? (dataSize - 384 + sectorSize - 1) / sectorSize * sectorSize + 384 : (dataSize + sectorSize - 1) / sectorSize * sectorSize;
        if (dataSize % 16 != 0) {
            throw new IllegalArgumentException("Parameter 'content' has effective size " + dataSize + " which is not a multiple of the paragraph size " + 16 + ".");
        }
        int paragraphs = dataSize / 16;
        byte[] header = new byte[16];
        header[0] = -106;
        header[1] = 2;
        header[4] = (byte)(sectorSize & 0xFF);
        header[5] = (byte)(sectorSize >> 8 & 0xFF);
        header[2] = (byte)(paragraphs & 0xFF);
        header[3] = (byte)(paragraphs >> 8 & 0xFF);
        header[6] = (byte)(paragraphs >> 16 & 0xFF);
        header[7] = (byte)(paragraphs >> 24 & 0xFF);
        header[8] = 0;
        header[9] = 0;
        header[10] = 0;
        header[11] = 0;
        header[12] = 0;
        header[13] = 0;
        header[14] = 0;
        header[15] = 0;
        return header;
    }

    public static byte[] createBootSectors() {
        byte[] result = new byte[384];
        System.arraycopy(bootCode, 0, result, 0, bootCode.length);
        return result;
    }

    public static boolean isHeader(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter 'data' must not be null.");
        }
        return data.length >= 16 && data[0] == -106 && data[1] == 2;
    }
}

