/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.HexUtility;
import com.wudsn.tools.base.common.Main;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.console.Console;
import com.wudsn.tools.base.io.CSVReader;
import com.wudsn.tools.base.repository.RepositoryValidation;
import com.wudsn.tools.thecartstudio.model.CartridgeDatabase;
import com.wudsn.tools.thecartstudio.model.CartridgeDatabaseEntry;
import com.wudsn.tools.thecartstudio.model.ContentType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CartridgeDatabaseCreator
extends Main {
    private Console console;
    private boolean logSkipped;
    private static final String BASE_DIR = "C:\\Users\\D025328\\Documents\\Eclipse\\workspace.jac\\com.wudsn.tools.thecartstudio\\";
    private static final String KROTKI_LIST = "C:\\Users\\D025328\\Documents\\Eclipse\\workspace.jac\\com.wudsn.tools.thecartstudio\\tst\\crc\\Atari 8-bit ROM list\\List - Comparison.csv";
    private static final String MAXFLASH_LIST = "C:\\Users\\D025328\\Documents\\Eclipse\\workspace.jac\\com.wudsn.tools.thecartstudio\\tst\\crc\\Maxflash\\romlib.ini";
    private static final String DATABASE_FILE = "C:\\Users\\D025328\\Documents\\Eclipse\\workspace.jac\\com.wudsn.tools.thecartstudio\\src\\data/CartridgeDatabase.csv";
    private Map<String, ContentType> mappings = new TreeMap<String, ContentType>();

    public static void main(String[] args) {
        new CartridgeDatabaseCreator().run();
    }

    private CartridgeDatabaseCreator() {
        this.createMappings();
    }

    private void addMapping(String mappingValue, ContentType contentType) {
        if (mappingValue == null) {
            throw new IllegalArgumentException("Parameter 'mappingValue' must not be null.");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Parameter 'contentType' must not be null.");
        }
        this.mappings.put(mappingValue, contentType);
    }

    private void createMappings() {
        this.addMapping("1024KB/ATARIMAX", ContentType.CARTRIDGE_ATMAX_1024);
        this.addMapping("1024KB/ULTIMATE1MB", ContentType.UNKNOWN);
        this.addMapping("1032KB/CORINA EEPROM", ContentType.UNKNOWN);
        this.addMapping("128KB/-", ContentType.UNKNOWN);
        this.addMapping("128KB/ATARIMAX", ContentType.CARTRIDGE_ATMAX_128);
        this.addMapping("128KB/ATRAX", ContentType.CARTRIDGE_ATRAX_128);
        this.addMapping("128KB/ATRAX SDX", ContentType.CARTRIDGE_ATRAX_SDX_128);
        this.addMapping("128KB/FOOCART", ContentType.UNKNOWN);
        this.addMapping("128KB/MEGACART", ContentType.CARTRIDGE_MEGA_128);
        this.addMapping("128KB/MYIDE+", ContentType.UNKNOWN);
        this.addMapping("128KB/SIC!", ContentType.CARTRIDGE_SIC_128);
        this.addMapping("128KB/SPARTADOS X", ContentType.CARTRIDGE_SDX_128);
        this.addMapping("128KB/SWITCHABLE XEGS", ContentType.CARTRIDGE_SWXEGS_128);
        this.addMapping("128KB/TURBO FREEZER 2005", ContentType.UNKNOWN);
        this.addMapping("128KB/TURBOSOFT", ContentType.CARTRIDGE_TURBOSOFT_128);
        this.addMapping("128KB/XEGS", ContentType.CARTRIDGE_XEGS_128);
        this.addMapping("16KB/-", ContentType.CARTRIDGE_STD_16);
        this.addMapping("16KB/BLIZZARD", ContentType.CARTRIDGE_BLIZZARD_16);
        this.addMapping("16KB/BUTTON SWITCH", ContentType.CARTRIDGE_STD_16);
        this.addMapping("16KB/OSS 034M", ContentType.CARTRIDGE_OSS_034M_16);
        this.addMapping("16KB/OSS 043M", ContentType.CARTRIDGE_OSS_043M_16);
        this.addMapping("16KB/OSS M091", ContentType.CARTRIDGE_OSS_M091_16);
        this.addMapping("16KB/STANDARD", ContentType.CARTRIDGE_STD_16);
        this.addMapping("256KB/SIC!", ContentType.CARTRIDGE_SIC_256);
        this.addMapping("256KB/TURBO FREEZER 2005", ContentType.UNKNOWN);
        this.addMapping("256KB/ULTIMATE1MB", ContentType.UNKNOWN);
        this.addMapping("2KB/AUTO SWITCHOFF", ContentType.UNKNOWN);
        this.addMapping("2KB/STANDARD", ContentType.CARTRIDGE_STD_2);
        this.addMapping("32KB/-", ContentType.UNKNOWN);
        this.addMapping("32KB/AST", ContentType.CARTRIDGE_AST_32);
        this.addMapping("32KB/ULTRACART", ContentType.CARTRIDGE_ULTRACART_32);
        this.addMapping("32KB/XEGS", ContentType.CARTRIDGE_XEGS_32);
        this.addMapping("40KB/BOUNTY BOB", ContentType.CARTRIDGE_BBSB_40);
        this.addMapping("4KB/", ContentType.CARTRIDGE_STD_4);
        this.addMapping("4KB/AUTO SWITCHOFF", ContentType.CARTRIDGE_STD_4);
        this.addMapping("4KB/BLIZZARD", ContentType.CARTRIDGE_BLIZZARD_4);
        this.addMapping("4KB/RIGHT", ContentType.CARTRIDGE_RIGHT_4);
        this.addMapping("4KB/STANDARD", ContentType.CARTRIDGE_STD_4);
        this.addMapping("512KB/IDE PLUS 2.0", ContentType.UNKNOWN);
        this.addMapping("512KB/MEGACART", ContentType.CARTRIDGE_MEGA_512);
        this.addMapping("64KB/?", ContentType.UNKNOWN);
        this.addMapping("64KB/ATRAX SDX", ContentType.CARTRIDGE_ATRAX_SDX_64);
        this.addMapping("64KB/DIAMOND", ContentType.CARTRIDGE_DIAMOND_64);
        this.addMapping("64KB/EXPRESS", ContentType.CARTRIDGE_EXP_64);
        this.addMapping("64KB/SPARTADOS X", ContentType.CARTRIDGE_SDX_64);
        this.addMapping("64KB/TURBOSOFT", ContentType.CARTRIDGE_TURBOSOFT_64);
        this.addMapping("64KB/WILLIAMS", ContentType.CARTRIDGE_WILL_64);
        this.addMapping("64KB/XEGS", ContentType.CARTRIDGE_XEGS_64);
        this.addMapping("8KB/", ContentType.CARTRIDGE_STD_8);
        this.addMapping("8KB/?", ContentType.CARTRIDGE_STD_8);
        this.addMapping("8KB/BUTTON SWITCH", ContentType.CARTRIDGE_STD_8);
        this.addMapping("8KB/LOW BANK", ContentType.CARTRIDGE_RIGHT_8);
        this.addMapping("8KB/OSS", ContentType.CARTRIDGE_OSS_8);
        this.addMapping("8KB/PHOENIX", ContentType.CARTRIDGE_PHOENIX_8);
        this.addMapping("8KB/RIGHT", ContentType.CARTRIDGE_RIGHT_8);
        this.addMapping("8KB/STANDARD", ContentType.CARTRIDGE_STD_8);
        this.addMapping("8KB/TELELINK II", ContentType.UNKNOWN);
    }

    private void run() {
        this.console = new Console();
        this.logSkipped = false;
        boolean krotkiList = true;
        boolean atariManiaList = false;
        boolean maxFlashList = false;
        CartridgeDatabase database = new CartridgeDatabase();
        if (atariManiaList) {
            this.addAtariManiaList(database);
        }
        if (krotkiList) {
            this.addKrotkiList(database);
        }
        if (maxFlashList) {
            this.addMaxflashList(database);
        }
        try {
            File file = new File(DATABASE_FILE);
            database.save(file);
            CartridgeDatabaseCreator.logInfo("CRC database saved to '" + file + "' with " + TextUtility.formatAsDecimal(file.length()) + " bytes, " + TextUtility.formatAsDecimal(database.getKnownTitelsCount()) + " known entries and " + TextUtility.formatAsDecimal(database.getKnownContentTypesCount()) + " known content types.");
        }
        catch (CoreException ex) {
            CartridgeDatabaseCreator.logError(ex.getMessage());
        }
    }

    private boolean addEntry(CartridgeDatabase database, int sizeInKB, int crc32, String md5, String title, ContentType contentType, String source) {
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' must not be null.");
        }
        MessageQueue messageQueue = new MessageQueue();
        RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
        rv.isStringValid(null, CartridgeDatabaseEntry.Attributes.TITLE, title);
        if (messageQueue.containsError()) {
            CartridgeDatabaseCreator.logError("File with title '" + title + "' is not valid.");
            this.console.displayMessageQueue(messageQueue);
            return false;
        }
        database.addEntry(sizeInKB, crc32, md5, title, contentType, source);
        return true;
    }

    private void addAtariManiaList(CartridgeDatabase database) {
        URL url;
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' must not be null.");
        }
        try {
            url = new URL("http://www.atarimania.com/list_games_atari-400-800-xl-xe-p_total-page-step-cartridge_380-2-200-1_8_G.html");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        try {
            SAXParser parser;
            InputStream inputStream = url.openStream();
            XMLHandler xmlHandler = new XMLHandler();
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setFeature("http://xml.org/sax/features/validation", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                reader.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
                reader.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                reader.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", false);
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException("Cannot create parser.", ex);
            }
            catch (SAXException ex) {
                throw new RuntimeException("Cannot create parser.", ex);
            }
            try {
                parser.parse(new InputSource(inputStream), (DefaultHandler)xmlHandler);
            }
            catch (SAXParseException ex) {
                throw new RuntimeException(ex);
            }
            catch (SAXException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addKrotkiList(CartridgeDatabase database) {
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' must not be null.");
        }
        CSVReader csvReader = new CSVReader();
        csvReader.open(new File(KROTKI_LIST), ',', Charset.defaultCharset().name());
        String titleHeader = "Title";
        int titleIndex = csvReader.getColumnIndex("Title");
        String crc32Header = "CRC-32";
        int crc32Index = csvReader.getColumnIndex(crc32Header);
        String sizeHeader = "Size";
        int sizeIndex = csvReader.getColumnIndex(sizeHeader);
        String mappingHeader = "Mapping";
        int mappingIndex = csvReader.getColumnIndex(mappingHeader);
        int addedCount = 0;
        int errorCount = 0;
        int skippedCount = 0;
        while (csvReader.readNextRow()) {
            String title = csvReader.getColumnValue(titleIndex).trim();
            String crc32Value = csvReader.getColumnValue(crc32Index).trim().toUpperCase();
            String sizeValue = csvReader.getColumnValue(sizeIndex).trim().toUpperCase();
            String mappingValue = String.valueOf(sizeValue) + "/" + csvReader.getColumnValue(mappingIndex).trim().toUpperCase();
            if (StringUtility.isEmpty(title)) {
                if (this.logSkipped) {
                    CartridgeDatabaseCreator.logInfo("Skipping: Column '" + titleHeader + "' empty in row " + csvReader.getRowNumber());
                }
                ++skippedCount;
                continue;
            }
            if (StringUtility.isEmpty(crc32Value)) {
                if (this.logSkipped) {
                    CartridgeDatabaseCreator.logInfo("Skipping: " + title + ", column '" + crc32Header + "' empty in row " + csvReader.getRowNumber());
                }
                ++skippedCount;
                continue;
            }
            if (StringUtility.isEmpty(sizeValue)) {
                if (this.logSkipped) {
                    CartridgeDatabaseCreator.logInfo("Skipping: " + title + ", column '" + sizeHeader + "' empty in row " + csvReader.getRowNumber());
                }
                ++skippedCount;
                continue;
            }
            int crc32 = (int)Long.parseLong(crc32Value, 16);
            String KB_SUFFIX = "KB";
            if (!sizeValue.endsWith("KB")) {
                throw new RuntimeException("Unknown size suffix in " + sizeValue + ".");
            }
            int sizeInKB = Integer.parseInt(sizeValue.substring(0, sizeValue.length() - "KB".length()));
            CartridgeDatabaseEntry cartridgeDatabaseEntry = database.getEntryByCRC32(sizeInKB, crc32);
            ContentType contentType = this.mappings.get(mappingValue);
            if (contentType == null) {
                throw new RuntimeException("Unknown mapping value " + mappingValue + ". Add a mapping definition.");
            }
            if (contentType == ContentType.UNKNOWN) {
                CartridgeDatabaseCreator.logError("Unmapping mapping value " + mappingValue + " for: '" + title + "'.");
                ++errorCount;
            } else if (contentType.getCartridgeType().getSizeInKB() != sizeInKB) {
                throw new RuntimeException("Size mismatch for mapping value " + mappingValue + ". Check mapping definition.");
            }
            if (cartridgeDatabaseEntry == null) {
                if (this.addEntry(database, sizeInKB, crc32, "", title, contentType, "K")) {
                    ++addedCount;
                    continue;
                }
                ++errorCount;
                continue;
            }
            throw new RuntimeException("Entry '" + cartridgeDatabaseEntry.getTitle() + "' with same size and crc32 value already present");
        }
        CartridgeDatabaseCreator.logInfo(String.valueOf(addedCount) + " entries added, " + skippedCount + " entries skipped, " + errorCount + " errors from Krotki's list.");
    }

    private void addMaxflashList(CartridgeDatabase database) {
        FileInputStream fis;
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' must not be null.");
        }
        File file = new File(MAXFLASH_LIST);
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        int addedCount = 0;
        int errorCount = 0;
        int skippedCount = 0;
        String line = null;
        try {
            String md5 = "";
            String title = "";
            int crc32 = 0;
            String crc32String = "";
            String formatValue = "";
            int format = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("[")) {
                    md5 = line.substring(1, 32).toUpperCase();
                } else if (line.startsWith("DESCRIPTION=")) {
                    title = line.substring(12);
                } else if (line.startsWith("CRC32=")) {
                    String crc32Value = line.substring(6);
                    crc32 = (int)Long.parseLong(crc32Value);
                    crc32String = CartridgeDatabaseCreator.getCRC32String(crc32);
                } else if (line.startsWith("FORMAT=")) {
                    formatValue = line.substring(7);
                    format = Integer.parseInt(formatValue);
                }
                if (!StringUtility.isEmpty(line)) continue;
                if (format == 0) {
                    if (this.logSkipped) {
                        CartridgeDatabaseCreator.logInfo("Skipping entry " + formatValue + "/" + crc32String + "/" + title + " as it is unsupported.");
                    }
                } else if (format == 0 || crc32 == 0 || StringUtility.isEmpty(title)) {
                    CartridgeDatabaseCreator.logError("Skipping entry " + formatValue + "/" + crc32String + "/" + title + " as it is incomplete.");
                } else {
                    int sizeInKB = 0;
                    CartridgeDatabaseEntry cartridgeDatabaseEntry = database.getEntryByCRC32(sizeInKB, crc32);
                    ContentType contentType = ContentType.UNKNOWN;
                    switch (format) {
                        case 1: {
                            contentType = ContentType.FILE_EXECUTABLE;
                            break;
                        }
                        case 2: {
                            contentType = ContentType.CARTRIDGE_STD_8;
                            break;
                        }
                        case 3: {
                            contentType = ContentType.FILE_ATR;
                        }
                    }
                    if (cartridgeDatabaseEntry == null) {
                        if (this.addEntry(database, sizeInKB, crc32, md5, title, contentType, "M")) {
                            ++addedCount;
                        } else {
                            ++errorCount;
                        }
                    } else {
                        CartridgeDatabaseCreator.logError("Skipping entry " + sizeInKB + "/" + crc32String + "/" + title + " as it is already present.");
                    }
                }
                md5 = "";
                format = 0;
                crc32 = 0;
                title = "";
            }
            reader.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        CartridgeDatabaseCreator.logInfo(String.valueOf(addedCount) + " entries added, " + skippedCount + " entries skipped, " + errorCount + " errors from Maxflash list.");
    }

    private static String getCRC32String(int crc32) {
        return HexUtility.getLongValueHexString((long)crc32 & 0xFFFFFFFFL, 8);
    }

    private static final class XMLHandler
    extends DefaultHandler {
        private int nesting = 0;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName == null) {
                throw new IllegalArgumentException("Parameter 'qName' must not be null.");
            }
            if (attributes == null) {
                throw new IllegalArgumentException("Parameter 'attributes' must not be null.");
            }
            if (qName.equals("table")) {
                ++this.nesting;
                CartridgeDatabaseCreator.println("Table " + attributes.getValue("id") + " at " + this.nesting);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("table")) {
                --this.nesting;
            }
        }
    }
}

