/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.ClassPathUtility;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.AtrLoader;
import com.wudsn.tools.thecartstudio.model.CartridgeMenuType;
import com.wudsn.tools.thecartstudio.model.CartridgeType;
import com.wudsn.tools.thecartstudio.model.DisplayMode;
import com.wudsn.tools.thecartstudio.model.ImportableCartridgeMenu;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookGenre;
import com.wudsn.tools.thecartstudio.model.WorkbookMenuEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CartridgeMenu {
    private static final String SIMPLE_MENU = "data/cartmenu.rom";
    private static final String EXTENDED_MENU = "data/cartmenu-extended.rom";
    private static final String EXTERNAL_SIMPLE_MENU = "cartmenu.rom";
    private static final String EXTERNAL_EXTENDED_MENU = "cartmenu-extended.rom";
    public static final int MENU_ENTRY_LENGTH = 64;
    private CartridgeMenuType cartridgeMenuType;
    private boolean valid;
    private boolean external;
    private String externalFilePath;
    private String version;
    private byte[] simpleMenuContent;
    private byte[] extendedMenuContent;

    public static CartridgeMenu createInstance(CartridgeMenuType cartridgeMenuType) {
        if (cartridgeMenuType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeMenuType' must not be null.");
        }
        if (cartridgeMenuType.equals(CartridgeMenuType.NONE)) {
            return null;
        }
        CartridgeMenu instance = new CartridgeMenu(cartridgeMenuType);
        return instance;
    }

    private CartridgeMenu(CartridgeMenuType cartridgeMenuType) {
        this.cartridgeMenuType = cartridgeMenuType;
        this.valid = false;
        this.external = false;
        this.externalFilePath = "";
        this.version = "????-??-??";
        boolean simpleMenuValid = false;
        boolean extendedMenuValid = false;
        File jarFolder = ClassPathUtility.getJarFolder();
        byte[] externalSimpleMenuContent = null;
        if (jarFolder != null) {
            try {
                File externalSimpleMenuFile = new File(jarFolder, EXTERNAL_SIMPLE_MENU);
                externalSimpleMenuContent = FileUtility.readBytes(externalSimpleMenuFile, 0x100000L, true);
                this.externalFilePath = externalSimpleMenuFile.getAbsolutePath();
            }
            catch (CoreException externalSimpleMenuFile) {
                // empty catch block
            }
        }
        this.simpleMenuContent = ResourceUtility.loadResourceAsByteArray(SIMPLE_MENU);
        if (externalSimpleMenuContent != null && externalSimpleMenuContent.length == this.simpleMenuContent.length) {
            this.simpleMenuContent = externalSimpleMenuContent;
            this.external = true;
        }
        if (this.simpleMenuContent != null && this.simpleMenuContent.length > 8192) {
            String signature = new String(this.simpleMenuContent, 8160, 16);
            if (signature.startsWith("The!Cart")) {
                this.version = String.valueOf(signature.substring(8, 12)) + "-" + signature.substring(12, 14) + "-" + signature.substring(14, 16);
            }
            simpleMenuValid = true;
        }
        byte[] externalExtendedMenuContent = null;
        if (jarFolder != null) {
            try {
                File externalExtendedMenuFile = new File(jarFolder, EXTERNAL_EXTENDED_MENU);
                externalExtendedMenuContent = FileUtility.readBytes(externalExtendedMenuFile, 0x100000L, true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.extendedMenuContent = ResourceUtility.loadResourceAsByteArray(EXTENDED_MENU);
        if (externalExtendedMenuContent != null && externalExtendedMenuContent.length > 8192) {
            this.extendedMenuContent = externalExtendedMenuContent;
        }
        if (this.extendedMenuContent != null && this.extendedMenuContent.length > 8192) {
            extendedMenuValid = true;
        }
        if (cartridgeMenuType.equals(CartridgeMenuType.SIMPLE)) {
            this.valid = simpleMenuValid;
        } else if (cartridgeMenuType.equals(CartridgeMenuType.EXTENDED)) {
            this.valid = simpleMenuValid && extendedMenuValid;
        }
    }

    public CartridgeMenuType getCartridgeMenuType() {
        return this.cartridgeMenuType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getExternalFilePath() {
        return this.externalFilePath;
    }

    public String getVersion() {
        return this.version;
    }

    public byte[] getContent(Workbook workbook, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        byte[] content = null;
        if (this.valid) {
            WorkbookRoot root = workbook.getRoot();
            if (root.getCartridgeMenuType() == CartridgeMenuType.SIMPLE) {
                content = this.simpleMenuContent;
            } else if (root.getCartridgeMenuType() == CartridgeMenuType.EXTENDED && (content = this.extendedMenuContent) != null) {
                this.createMenuEntries(workbook, messageQueue);
                if (messageQueue.containsError()) {
                    return null;
                }
                System.arraycopy(this.simpleMenuContent, 0, this.extendedMenuContent, 0, 6144);
                System.arraycopy(this.simpleMenuContent, 8160, this.extendedMenuContent, 8160, 16);
                System.arraycopy(this.extendedMenuContent, 8186, this.simpleMenuContent, 16, 2);
                System.arraycopy(this.simpleMenuContent, 8192, this.extendedMenuContent, 8192, this.simpleMenuContent.length - 8192);
                int startBankNumber = root.getMenuEntriesContentProvider().getStartBankNumber();
                CartridgeMenu.setByte(content, 7936, root.getCartridgeType().getNumericId());
                CartridgeMenu.setWord(content, 7938, root.getBankCount());
                CartridgeMenu.setWord(content, 7940, root.getUnmodifiableGenresList().size() + 1);
                CartridgeMenu.setWord(content, 7942, startBankNumber + 0);
                CartridgeMenu.setWord(content, 7944, root.getMenuEntriesList().size());
                CartridgeMenu.setWord(content, 7946, startBankNumber + 1);
                StringBuffer title = new StringBuffer(root.getTitle());
                int padding = Math.max(0, (WorkbookEntry.TITLE_LENGTH - title.length()) / 2);
                int i = 0;
                while (i < padding) {
                    title.insert(0, ' ');
                    ++i;
                }
                CartridgeMenu.setString(content, 7948, title.toString(), WorkbookEntry.TITLE_LENGTH);
            }
        }
        if (content == null) {
            content = new byte[]{};
        }
        return content;
    }

    private void createMenuEntries(Workbook workbook, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        WorkbookRoot root = workbook.getRoot();
        List<WorkbookEntry> workbookEntries = root.getUnmodifiableEntriesList();
        List<WorkbookMenuEntry> workbookMenuEntries = root.getMenuEntriesList();
        workbookMenuEntries.clear();
        InnerMenuCollector collector = new InnerMenuCollector(workbook);
        int i = 0;
        while (i < workbookEntries.size()) {
            block9: {
                WorkbookEntry workbookEntry;
                block10: {
                    ImportableCartridgeMenu importableCartrideMenu;
                    block8: {
                        workbookEntry = workbookEntries.get(i);
                        importableCartrideMenu = null;
                        if (!workbookEntry.getDisplayMode().equals(DisplayMode.MULTIPLE_ENTRIES) || (importableCartrideMenu = workbookEntry.getContentType().getCartridgeType().createImportableCartridgeMenu()) != null) break block8;
                        messageQueue.sendMessage(workbookEntry, WorkbookEntry.Attributes.DISPLAY_MODE, Messages.E422, workbookEntry.getContentType().toString(), DisplayMode.MULTIPLE_ENTRIES.toString(), CartridgeType.getImportableCartridgeMenuList());
                        break block9;
                    }
                    if (importableCartrideMenu == null) break block10;
                    byte[] content = workbook.getEntryFileContent(workbookEntry, messageQueue);
                    if (content == null) break block9;
                    int result = importableCartrideMenu.collectMenuEntries(workbookEntry, content, collector);
                    switch (result) {
                        case 1: 
                        case 2: 
                        case 3: {
                            messageQueue.sendMessage(workbookEntry, WorkbookEntry.Attributes.DISPLAY_MODE, Messages.E423, new String[0]);
                            break block9;
                        }
                        case 4: {
                            messageQueue.sendMessage(workbookEntry, WorkbookEntry.Attributes.DISPLAY_MODE, Messages.I425, importableCartrideMenu.getCreatingToolName());
                            break block9;
                        }
                        case 5: {
                            break block9;
                        }
                        default: {
                            throw new RuntimeException("Unsupported result code " + result + ".");
                        }
                    }
                }
                workbookMenuEntries.add(new WorkbookMenuEntry(workbookEntry));
            }
            ++i;
        }
        Collections.sort(workbookMenuEntries);
    }

    public static void setMenuEntriesContent(Workbook workbook, byte[] result, MessageQueue messageQueue) {
        int bankSize;
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (result == null) {
            throw new IllegalArgumentException("Parameter 'result' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        Arrays.fill(result, (byte)-1);
        WorkbookRoot root = workbook.getRoot();
        int genresOffset = 0;
        int bytesPerGenre = 2;
        WorkbookGenre allGenre = new WorkbookGenre();
        allGenre.setName("All");
        ArrayList<WorkbookGenre> genresList = new ArrayList<WorkbookGenre>(root.getUnmodifiableGenresList());
        genresList.add(0, allGenre);
        int genreCount = genresList.size();
        int genreNameOffset = genreCount * bytesPerGenre;
        int i = 0;
        while (i < genreCount) {
            WorkbookGenre genre = (WorkbookGenre)genresList.get(i);
            int offset = genresOffset + i * bytesPerGenre;
            CartridgeMenu.setWord(result, offset, genreNameOffset);
            genreNameOffset += genre.getName().length() + 1;
            ++i;
        }
        ArrayList<String> genreNames = new ArrayList<String>();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int i2 = 0;
        while (i2 < genreCount) {
            WorkbookGenre genre = (WorkbookGenre)genresList.get(i2);
            String genreName = genre.getName();
            genreNames.add(genreName);
            try {
                buffer.write(ASCIIString.getBytes(genreName));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            buffer.write(0);
            ++i2;
        }
        genreNameOffset = genreCount * bytesPerGenre;
        byte[] genreNamesBytes = buffer.toByteArray();
        System.arraycopy(genreNamesBytes, 0, result, genreNameOffset, genreNamesBytes.length);
        List<WorkbookMenuEntry> workbookMenuEntries = root.getMenuEntriesList();
        int entryOffset = bankSize = workbook.getRoot().getBankSize();
        StringBuilder builder = new StringBuilder(WorkbookEntry.TITLE_LENGTH);
        int i3 = 0;
        while (i3 < workbookMenuEntries.size()) {
            WorkbookMenuEntry workbookMenuEntry = workbookMenuEntries.get(i3);
            WorkbookEntry workbookEntry = workbookMenuEntry.getWorkbookEntry();
            int offset = entryOffset + 0;
            CartridgeMenu.setWord(result, offset, i3);
            offset = entryOffset + 2;
            CartridgeMenu.setByte(result, offset, workbookEntry.getContentType().getTheCartMode());
            offset = entryOffset + 4;
            CartridgeMenu.setWord(result, offset, workbookEntry.getStartBankNumber());
            int initialBankNumber = workbookEntry.getContentType().getCartridgeType().getInitialBankNumber();
            offset = entryOffset + 6;
            CartridgeMenu.setWord(result, offset, initialBankNumber);
            int loaderBaseAddress = AtrLoader.getBaseAddress(workbookEntry);
            offset = entryOffset + 8;
            CartridgeMenu.setWord(result, offset, loaderBaseAddress);
            offset = entryOffset + 10;
            CartridgeMenu.setByte(result, offset, workbookMenuEntry.getSourceType());
            offset = entryOffset + 11;
            CartridgeMenu.setByte(result, offset, workbookMenuEntry.getItemMenuVersion());
            offset = entryOffset + 12;
            CartridgeMenu.setByte(result, offset, workbookMenuEntry.getItemNumber());
            String title = workbookMenuEntry.getTitle().trim();
            offset = entryOffset + 13;
            CartridgeMenu.setByte(result, offset, title.length());
            offset = entryOffset + 14;
            builder.setLength(0);
            builder.append(workbookMenuEntry.getTitle());
            builder.append("                                        ");
            int j = 0;
            while (j < WorkbookEntry.TITLE_LENGTH) {
                result[offset++] = (byte)builder.charAt(j);
                ++j;
            }
            offset = entryOffset + 54;
            int genreNumber = 0;
            String genreName = workbookMenuEntry.getWorkbookEntry().getGenreName();
            if (StringUtility.isSpecified(genreName)) {
                genreNumber = genreNames.indexOf(genreName);
            }
            CartridgeMenu.setByte(result, offset, genreNumber);
            offset = entryOffset + 55;
            CartridgeMenu.setByte(result, offset, workbookMenuEntry.getWorkbookEntry().isFavorite() ? 1 : 0);
            entryOffset += 64;
            ++i3;
        }
    }

    private static void setByte(byte[] content, int offset, int value) {
        if (value > 256) {
            throw new IllegalArgumentException("Value " + value + " is no byte value");
        }
        content[offset] = (byte)(value & 0xFF);
    }

    private static void setWord(byte[] content, int offset, int value) {
        content[offset] = (byte)(value & 0xFF);
        content[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    private static void setString(byte[] content, int offset, String value, int length) {
        int i = 0;
        while (i < length) {
            int c = i < value.length() ? (int)value.charAt(i) : 32;
            CartridgeMenu.setByte(content, offset + i, c);
            ++i;
        }
    }

    private final class InnerMenuCollector
    implements ImportableCartridgeMenu.Collector {
        private Workbook workbook;
        private boolean logMenus;
        private boolean logMenuEntries;

        public InnerMenuCollector(Workbook workbook) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            this.workbook = workbook;
            this.logMenus = false;
            this.logMenuEntries = false;
        }

        @Override
        public void collectMenu(Object owner, String info) {
            if (owner == null) {
                throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' must not be null.");
            }
            WorkbookEntry workbookEntry = (WorkbookEntry)owner;
            workbookEntry.setTitle(info);
            if (this.logMenus) {
                Log.logInfo("Found importable menu: {0} - '{1}' - '{2}'", new Object[]{workbookEntry.getContentType().toString(), info, workbookEntry.getTitle()});
            }
        }

        @Override
        public final void collectMenuEntry(Object owner, int itemMenuVersion, int itemNumber, StringBuffer titleBuffer) {
            if (this.workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            if (owner == null) {
                throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
            }
            if (titleBuffer == null) {
                throw new IllegalArgumentException("Parameter 'titleBuffer' must not be null.");
            }
            WorkbookEntry workbookEntry = (WorkbookEntry)owner;
            String title = titleBuffer.toString().trim();
            if (StringUtility.isSpecified(title)) {
                if (this.logMenuEntries) {
                    Log.logInfo("Found importable menu entry: '{0}' - '{1}'", new Object[]{workbookEntry.getTitle(), title});
                }
                WorkbookMenuEntry workbookMenuEntry = new WorkbookMenuEntry(workbookEntry);
                workbookMenuEntry.setTitle(title);
                workbookMenuEntry.setSourceType(1);
                workbookMenuEntry.setItemMenuVersion(itemMenuVersion);
                workbookMenuEntry.setItemNumber(itemNumber);
                this.workbook.getRoot().getMenuEntriesList().add(workbookMenuEntry);
            }
        }
    }

    public static final class Offsets {
        public static final int ENTRY_DEFAULT_CARTSTART = 15;
        public static final int CARTCS = 8186;
        public static final int MENU_STUDIO_ROM = 6144;
        public static final int MENU_START_ROM = 7680;
        public static final int MENU_MCB_ROM = 7936;
        public static final int CARTRIDGE_TYPE = 7936;
        public static final int BANK_COUNT = 7938;
        public static final int MENU_GENRES_COUNT = 7940;
        public static final int MENU_GENRES_START_BANK_NUMBER = 7942;
        public static final int MENU_ENTRIES_COUNT = 7944;
        public static final int MENU_ENTRIES_START_BANK_NUMBER = 7946;
        public static final int MENU_TITLE = 7948;
        public static final int CARTMENU_SIGNATURE = 8160;
        public static final int CARTMENU_SIGNATURE_LENGTH = 16;
        public static final int CARTMENU_FIRST_BANK_END = 8192;
        public static final int MENU_ENTRY_NUMBER = 0;
        public static final int MENU_ENTRY_THE_CART_MODE = 2;
        public static final int MENU_ENTRY_START_BANK_NUMBER = 4;
        public static final int MENU_ENTRY_INITIAL_BANK_NUMBER = 6;
        public static final int MENU_ENTRY_LOADER_BASE_ADDRESS = 8;
        public static final int MENU_ENTRY_SOURCE_TYPE = 10;
        public static final int MENU_ENTRY_ITEM_MENU_VERSION = 11;
        public static final int MENU_ENTRY_ITEM_NUMBER = 12;
        public static final int MENU_ENTRY_TITLE_LENGTH = 13;
        public static final int MENU_ENTRY_TITLE = 14;
        public static final int MENU_ENTRY_GENRE_NUMBER = 54;
        public static final int MENU_ENTRY_FAVORITE_INDICATOR = 55;
    }
}

