/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.repository.ValueSet;
import com.wudsn.tools.thecartstudio.ValueSets;
import com.wudsn.tools.thecartstudio.model.CartridgeMenuType;
import com.wudsn.tools.thecartstudio.model.CartridgeType;
import com.wudsn.tools.thecartstudio.model.ContentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class FlashTargetType
extends ValueSet {
    public static final FlashTargetType ATMAX_128;
    public static final FlashTargetType ATMAX_1024;
    public static final FlashTargetType MEGA_4096;
    public static final FlashTargetType THECART_32MB;
    public static final FlashTargetType THECART_64MB;
    public static final FlashTargetType THECART_128MB;
    public static final FlashTargetType TURBO_FREEZER_2005_448;
    public static final FlashTargetType USER_DEFINED;
    private static List<FlashTargetType> values;
    private static final Map<String, FlashTargetType> map;
    private CartridgeType cartridgeType;
    private int bankCount;
    private int bankSize;
    private List<CartridgeMenuType> supportedCartridgeMenuTypes;
    private List<ContentType> supportedContentTypes;
    private int[] supportedExportFormats;

    static {
        values = new ArrayList<FlashTargetType>();
        map = new TreeMap<String, FlashTargetType>();
        ArrayList<CartridgeMenuType> supportedCartridgeMenuTypes = new ArrayList<CartridgeMenuType>();
        ArrayList<ContentType> supportedContentTypes = new ArrayList<ContentType>();
        int sortKey = 0;
        supportedCartridgeMenuTypes.clear();
        supportedCartridgeMenuTypes.add(CartridgeMenuType.NONE);
        supportedCartridgeMenuTypes.add(CartridgeMenuType.EXTENDED);
        supportedContentTypes.clear();
        supportedContentTypes.add(ContentType.CARTRIDGE_STD_8);
        supportedContentTypes.add(ContentType.CARTRIDGE_STD_16);
        supportedContentTypes.add(ContentType.CARTRIDGE_ATMAX_128);
        int[] exportFormats = new int[]{1, 2};
        ATMAX_128 = FlashTargetType.add("ATMAX_128", sortKey++, CartridgeType.CARTRIDGE_ATMAX_128, 0, 0, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        supportedContentTypes.add(ContentType.CARTRIDGE_ATMAX_1024);
        ATMAX_1024 = FlashTargetType.add("ATMAX_1024", sortKey++, CartridgeType.CARTRIDGE_ATMAX_1024, 0, 0, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        supportedCartridgeMenuTypes.clear();
        supportedCartridgeMenuTypes.add(CartridgeMenuType.NONE);
        supportedContentTypes.clear();
        supportedContentTypes.add(ContentType.CARTRIDGE_STD_8);
        supportedContentTypes.add(ContentType.CARTRIDGE_STD_16);
        exportFormats = new int[]{1, 2};
        MEGA_4096 = FlashTargetType.add("MEGA_4096", sortKey++, CartridgeType.CARTRIDGE_MEGA_4096, 0, 0, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        supportedCartridgeMenuTypes.clear();
        supportedCartridgeMenuTypes.add(CartridgeMenuType.NONE);
        supportedCartridgeMenuTypes.add(CartridgeMenuType.SIMPLE);
        supportedCartridgeMenuTypes.add(CartridgeMenuType.EXTENDED);
        supportedContentTypes.clear();
        for (ContentType contentType : ContentType.getValues()) {
            switch (contentType.getTheCartMode()) {
                case 0: {
                    break;
                }
                default: {
                    supportedContentTypes.add(contentType);
                }
            }
        }
        exportFormats = new int[]{1, 2, 3, 4};
        THECART_32MB = FlashTargetType.add("THECART_32MB", sortKey++, CartridgeType.CARTRIDGE_THECART_32M, 4096, 8192, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        THECART_64MB = FlashTargetType.add("THECART_64MB", sortKey++, CartridgeType.CARTRIDGE_THECART_64M, 8192, 8192, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        THECART_128MB = FlashTargetType.add("THECART_128MB", sortKey++, CartridgeType.CARTRIDGE_THECART_128M, 0, 0, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        supportedCartridgeMenuTypes.clear();
        supportedCartridgeMenuTypes.add(CartridgeMenuType.NONE);
        supportedContentTypes.clear();
        supportedContentTypes.add(ContentType.CARTRIDGE_STD_8);
        supportedContentTypes.add(ContentType.CARTRIDGE_STD_16);
        supportedContentTypes.add(ContentType.CARTRIDGE_OSS_M091_16);
        supportedContentTypes.add(ContentType.CARTRIDGE_SDX_64);
        exportFormats = new int[]{1};
        TURBO_FREEZER_2005_448 = FlashTargetType.add("TURBO_FREEZER_2005_448", sortKey++, CartridgeType.UNKNOWN, 56, 8192, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        supportedCartridgeMenuTypes.clear();
        supportedCartridgeMenuTypes.add(CartridgeMenuType.NONE);
        supportedCartridgeMenuTypes.add(CartridgeMenuType.SIMPLE);
        supportedCartridgeMenuTypes.add(CartridgeMenuType.EXTENDED);
        supportedContentTypes.clear();
        supportedContentTypes.addAll(ContentType.getValues());
        exportFormats = new int[]{1, 2, 3, 4};
        USER_DEFINED = FlashTargetType.add("USER_DEFINED", sortKey++, CartridgeType.UNKNOWN, 128, 8192, supportedCartridgeMenuTypes, supportedContentTypes, exportFormats);
        values = Collections.unmodifiableList(values);
        FlashTargetType.initializeClass(FlashTargetType.class, ValueSets.class);
    }

    private FlashTargetType(String id, int sortKey, CartridgeType cartridgeType, int bankCount, int bankSize, List<CartridgeMenuType> supportedCartridgeMenuTypes, List<ContentType> supportedFileTypes, int[] supportedExportFormats) {
        super(id, sortKey);
        this.cartridgeType = cartridgeType;
        if (cartridgeType.getSizeInKB() > 0 && bankCount == 0 && bankSize == 0) {
            this.bankCount = cartridgeType.getSizeInKB() * 1024 / cartridgeType.getBankSize();
            this.bankSize = cartridgeType.getBankSize();
        } else {
            this.bankCount = bankCount;
            this.bankSize = bankSize;
        }
        this.supportedCartridgeMenuTypes = Collections.unmodifiableList(new ArrayList<CartridgeMenuType>(supportedCartridgeMenuTypes));
        this.supportedContentTypes = Collections.unmodifiableList(new ArrayList<ContentType>(supportedFileTypes));
        this.supportedExportFormats = supportedExportFormats;
    }

    private static FlashTargetType add(String id, int sortKey, CartridgeType cartridgeType, int bankCount, int bankSize, List<CartridgeMenuType> supportedCartridgeMenuTypes, List<ContentType> supportedFileTypes, int[] supportedExportFormats) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        if (cartridgeType.getSizeInKB() == 0 && bankCount < 1) {
            throw new IllegalArgumentException("Parameter 'bankCount' must be positive if the cartridge type does not specify the size. Specified value is " + bankCount + ".");
        }
        if (supportedFileTypes == null) {
            throw new IllegalArgumentException("Parameter 'supportedContentTypes' must not be null.");
        }
        if (supportedExportFormats == null) {
            throw new IllegalArgumentException("Parameter 'supportedExportFormats' must not be null.");
        }
        FlashTargetType result = new FlashTargetType(id, sortKey, cartridgeType, bankCount, bankSize, supportedCartridgeMenuTypes, supportedFileTypes, supportedExportFormats);
        values.add(result);
        map.put(id, result);
        return result;
    }

    public static List<FlashTargetType> getValues() {
        return values;
    }

    public static FlashTargetType getInstance(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        return map.get(id);
    }

    public CartridgeType getCartridgeType() {
        return this.cartridgeType;
    }

    public int getBankCount() {
        return this.bankCount;
    }

    public int getBankSize() {
        return this.bankSize;
    }

    public boolean isExportFormatSupported(int exportFormat) {
        int[] nArray = this.supportedExportFormats;
        int n = this.supportedExportFormats.length;
        int n2 = 0;
        while (n2 < n) {
            int supportedExportFormat = nArray[n2];
            if (supportedExportFormat == exportFormat) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isCartridgeMenuTypeSupported(CartridgeMenuType cartridgeMenuType) {
        if (cartridgeMenuType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeMenuType' must not be null.");
        }
        return this.supportedCartridgeMenuTypes.contains(cartridgeMenuType);
    }

    public List<CartridgeMenuType> getSupportedCartridgeMenuTypes() {
        return this.supportedCartridgeMenuTypes;
    }

    public boolean isContentTypeSupported(ContentType contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Parameter 'fileType' must not be null.");
        }
        return this.supportedContentTypes.contains(contentType);
    }
}

