/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.gui.DynamicMenuItemList;
import com.wudsn.tools.base.gui.ElementFactory;
import com.wudsn.tools.thecartstudio.Actions;
import com.wudsn.tools.thecartstudio.model.Preferences;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class MainMenu {
    public final JMenuBar menuBar;
    public final JMenuItem newMenuItem;
    public final JMenuItem openMenuItem;
    public final JMenuItem openFolderMenuItem;
    public final JMenuItem saveMenuItem;
    public final JMenuItem saveAsMenuItem;
    public final JMenuItem closeMenuItem;
    public final JMenu exportMenu;
    public final JMenuItem exportAsBinImageMenuItem;
    public final JMenuItem exportAsCarImageMenuItem;
    public final JMenuItem exportAsAtrImageMenuItem;
    public final JMenuItem exportAsAtrImagesMenuItem;
    public final DynamicMenuItemList recentWorkbooksMenuItemList;
    public final JMenuItem printMenuItem;
    public final JMenuItem exitMenuItem;
    public final JMenuItem addEntriesMenuItem;
    public final JMenuItem addUserSpaceEntryMenuItem;
    public final JMenuItem removeEntriesMenuItem;
    public final JMenuItem setGenreMenuItem;
    public final JMenuItem assignNewBanksMenuItem;
    public final JMenuItem workbookOptionsMenuItem;
    public final JMenuItem optionsMenuItem;
    public final JMenuItem testMenuItem;

    public MainMenu(final ActionListener actionListener, final Preferences preferences) {
        if (actionListener == null) {
            throw new IllegalArgumentException("Parameter 'actionListener' must not be null.");
        }
        if (preferences == null) {
            throw new IllegalArgumentException("Parameter 'preferences' must not be null.");
        }
        this.menuBar = new JMenuBar();
        JMenu menu = ElementFactory.createMenu(com.wudsn.tools.base.Actions.MainMenu_File);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                List<String> filePathsList = preferences.getRecentWorkbookFilePathsList();
                ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
                int i = 0;
                while (i < filePathsList.size()) {
                    String filePath = filePathsList.get(i);
                    File file = new File(filePath);
                    String fileName = file.getName();
                    String folderPath = file.getParent();
                    char number = (char)(49 + i);
                    String text = String.valueOf(number) + " " + fileName;
                    JMenuItem menuItem = new JMenuItem(text, number);
                    menuItem.setToolTipText(folderPath);
                    menuItem.setActionCommand("openRecent:" + filePath);
                    menuItem.addActionListener(actionListener);
                    menuItems.add(menuItem);
                    ++i;
                }
                MainMenu.this.recentWorkbooksMenuItemList.setMenuItems(menuItems, MainMenu.this.openMenuItem.isEnabled());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.menuBar.add(menu);
        this.newMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_New, "new");
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.addActionListener(actionListener);
        menu.add(this.newMenuItem);
        this.openMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_Open, "open");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.addActionListener(actionListener);
        menu.add(this.openMenuItem);
        this.openFolderMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_OpenFolder, "openFolder");
        this.openFolderMenuItem.addActionListener(actionListener);
        menu.add(this.openFolderMenuItem);
        this.saveMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_Save, "save");
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.addActionListener(actionListener);
        menu.add(this.saveMenuItem);
        this.saveAsMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_SaveAs, "saveAs");
        this.saveAsMenuItem.addActionListener(actionListener);
        menu.add(this.saveAsMenuItem);
        this.closeMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_Close, "close");
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        this.closeMenuItem.addActionListener(actionListener);
        menu.add(this.closeMenuItem);
        menu.addSeparator();
        this.exportMenu = ElementFactory.createMenu(Actions.MainMenu_File_Export);
        this.exportAsBinImageMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_ExportToBinImage, "exportToBinImage");
        this.exportAsBinImageMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        this.exportAsBinImageMenuItem.addActionListener(actionListener);
        this.exportAsCarImageMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_ExportToCarImage, "exportToCarImage");
        this.exportAsCarImageMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.exportAsCarImageMenuItem.addActionListener(actionListener);
        this.exportAsAtrImageMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_ExportToAtrImage, "exportToAtrImage");
        this.exportAsAtrImageMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.exportAsAtrImageMenuItem.addActionListener(actionListener);
        this.exportAsAtrImagesMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_ExportToAtrImages, "exportToAtrImages");
        this.exportAsAtrImagesMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 9));
        this.exportAsAtrImagesMenuItem.addActionListener(actionListener);
        this.exportMenu.add(this.exportAsBinImageMenuItem);
        this.exportMenu.add(this.exportAsCarImageMenuItem);
        this.exportMenu.add(this.exportAsAtrImageMenuItem);
        this.exportMenu.add(this.exportAsAtrImagesMenuItem);
        menu.add(this.exportMenu);
        this.recentWorkbooksMenuItemList = new DynamicMenuItemList(menu);
        menu.addSeparator();
        this.printMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_Print, "print");
        this.printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.printMenuItem.addActionListener(actionListener);
        menu.add(this.printMenuItem);
        menu.addSeparator();
        this.exitMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_File_Exit, "exit");
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.exitMenuItem.addActionListener(actionListener);
        menu.add(this.exitMenuItem);
        menu = ElementFactory.createMenu(com.wudsn.tools.base.Actions.MainMenu_Edit);
        this.menuBar.add(menu);
        this.addEntriesMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Edit_AddEntries, "addEntries");
        this.addEntriesMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        this.addEntriesMenuItem.addActionListener(actionListener);
        menu.add(this.addEntriesMenuItem);
        this.addUserSpaceEntryMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Edit_AddUserSpaceEntry, "addUserSpaceEntry");
        this.addUserSpaceEntryMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 1));
        this.addUserSpaceEntryMenuItem.addActionListener(actionListener);
        menu.add(this.addUserSpaceEntryMenuItem);
        this.removeEntriesMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Edit_RemoveEntries, "removeEntries");
        this.removeEntriesMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.removeEntriesMenuItem.addActionListener(actionListener);
        menu.add(this.removeEntriesMenuItem);
        this.setGenreMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Edit_SetGenre, "setGenre");
        this.setGenreMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 3));
        this.setGenreMenuItem.addActionListener(actionListener);
        menu.add(this.setGenreMenuItem);
        this.assignNewBanksMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Edit_AssignNewBanks, "assignNewBanks");
        this.assignNewBanksMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        this.assignNewBanksMenuItem.addActionListener(actionListener);
        menu.add(this.assignNewBanksMenuItem);
        menu.addSeparator();
        this.workbookOptionsMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Edit_WorkbookOptions, "workbookOptions");
        this.workbookOptionsMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 8));
        this.workbookOptionsMenuItem.addActionListener(actionListener);
        menu.add(this.workbookOptionsMenuItem);
        menu = ElementFactory.createMenu(com.wudsn.tools.base.Actions.MainMenu_Tools);
        this.menuBar.add(menu);
        this.optionsMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Tools_Options, "options");
        this.optionsMenuItem.addActionListener(actionListener);
        menu.add(this.optionsMenuItem);
        this.testMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Tools_Test, "test");
        this.testMenuItem.addActionListener(actionListener);
        menu.add(this.optionsMenuItem);
        menu = ElementFactory.createMenu(com.wudsn.tools.base.Actions.MainMenu_Help);
        this.menuBar.add(menu);
        JMenuItem helpMenuItem = ElementFactory.createMenuItem(com.wudsn.tools.base.Actions.MainMenu_Help_HelpContent, "helpContents");
        helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpMenuItem.addActionListener(actionListener);
        menu.add(helpMenuItem);
        helpMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Help_ContentTypes, "helpFileTypes");
        helpMenuItem.addActionListener(actionListener);
        menu.add(helpMenuItem);
        helpMenuItem = ElementFactory.createMenuItem(Actions.MainMenu_Help_About, "helpAbout");
        helpMenuItem.addActionListener(actionListener);
        menu.add(helpMenuItem);
    }
}

