/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.console;

import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.MessageQueueEntry;
import com.wudsn.tools.base.common.MessageQueueRenderer;

public final class Console
implements MessageQueueRenderer {
    @Override
    public void displayMessageQueue(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        for (MessageQueueEntry messageQueueEntry : messageQueue.getEntries()) {
            this.setStatus(messageQueueEntry);
        }
    }

    @Override
    public void displayStatusMessage(MessageQueueEntry messageQueueEntry) {
        if (messageQueueEntry == null) {
            throw new IllegalArgumentException("Parameter 'messageQueueEntry' must not be null.");
        }
        this.setStatus(messageQueueEntry);
    }

    private void setStatus(MessageQueueEntry messageQueueEntry) {
        String severityText;
        int severity = messageQueueEntry.getMessage().getSeverity();
        switch (severity) {
            case 1: 
            case 2: {
                severityText = "INFO :";
                break;
            }
            case 3: {
                severityText = "ERROR:";
                break;
            }
            default: {
                throw new IllegalStateException("Field 'severity' has illegal value " + severity + ".");
            }
        }
        this.println(String.valueOf(severityText) + " " + messageQueueEntry.getMessage().getId() + " - " + messageQueueEntry.getMessageText());
    }

    public void println(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter 'string' must not be null.");
        }
        System.out.println(string);
    }
}

