/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.console;

import com.wudsn.tools.base.console.ConsoleCommand;
import com.wudsn.tools.base.repository.Attribute;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ConsoleCommandExecution {
    private ConsoleCommand consoleCommand;
    private Map<String, List<String>> parameterValues;

    ConsoleCommandExecution(ConsoleCommand consoleCommand, Map<String, List<String>> parameterValues) {
        if (consoleCommand == null) {
            throw new IllegalArgumentException("Parameter 'consoleCommand' must not be null.");
        }
        if (parameterValues == null) {
            throw new IllegalArgumentException("Parameter 'parameterValues' must not be null.");
        }
        this.consoleCommand = consoleCommand;
        this.parameterValues = Collections.unmodifiableMap(parameterValues);
    }

    public ConsoleCommand getConsoleCommand() {
        return this.consoleCommand;
    }

    public List<String> getParameterValuesAsString(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        return this.parameterValues.get(attribute.getName());
    }

    public String getParameterValueAsString(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (this.getParameterValuesAsString(attribute).isEmpty()) {
            return "";
        }
        return this.getParameterValuesAsString(attribute).get(0);
    }

    public File getParameterValueAsFile(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (this.getParameterValuesAsString(attribute).isEmpty()) {
            return null;
        }
        return new File(this.getParameterValuesAsString(attribute).get(0));
    }

    public Integer getParameterValueAsInteger(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Parameter 'attribute' must not be null.");
        }
        if (this.getParameterValuesAsString(attribute).isEmpty()) {
            return null;
        }
        String stringValue = this.getParameterValuesAsString(attribute).get(0);
        try {
            int intValue = Integer.parseInt(stringValue);
            return intValue;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String toString() {
        String result = "-" + this.consoleCommand.getActionCommand();
        if (!this.parameterValues.isEmpty()) {
            result = String.valueOf(result) + ":" + this.parameterValues.toString();
        }
        return result;
    }
}

