/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari;

import com.wudsn.tools.base.atari.ValueSets;
import com.wudsn.tools.base.repository.ValueSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class Platform
extends ValueSet {
    public static final Platform UNKNOWN;
    public static final Platform ATARI_5200;
    public static final Platform ATARI_800;
    private static final Map<String, Platform> values;
    private String cartridgeTypeSampleCreatorPath;

    static {
        values = new TreeMap<String, Platform>();
        UNKNOWN = Platform.add("UNKNOWN", "");
        ATARI_5200 = Platform.add("ATARI_5200", "data/CartridgeTypeSampleCreator-Atari5200.xex");
        ATARI_800 = Platform.add("ATARI_800", "data/CartridgeTypeSampleCreator-Atari800.xex");
        Platform.initializeClass(Platform.class, ValueSets.class);
    }

    private Platform(String id, String cartridgeTypeSampleCreatorPath) {
        super(id, id, 0);
        this.cartridgeTypeSampleCreatorPath = cartridgeTypeSampleCreatorPath;
    }

    private static Platform add(String id, String cartridgeTypeSampleCreatorPath) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        if (cartridgeTypeSampleCreatorPath == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeTypeSampleCreatorPath' must not be null.");
        }
        Platform result = new Platform(id, cartridgeTypeSampleCreatorPath);
        values.put(result.getId(), result);
        return result;
    }

    public static List<Platform> getValues() {
        return Collections.unmodifiableList(new ArrayList<Platform>(values.values()));
    }

    public static Platform getInstance(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        return values.get(id);
    }

    public String getCartridgeTypeSampleCreatorPath() {
        return this.cartridgeTypeSampleCreatorPath;
    }
}

