/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.common.TextUtility;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JTable;

final class AttributeTablePrinter
implements Printable {
    private Printable tablePrintable;
    private String headerText;
    private String subHeaderText;
    private String footerText;
    private PageFormat tablePageFormat;

    AttributeTablePrinter(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Parameter 'table' must not be null.");
        }
        this.tablePrintable = table.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
    }

    boolean print(String headerText, String subHeaderText, String footerText) throws PrinterException {
        if (headerText == null) {
            throw new IllegalArgumentException("Parameter 'headerText' must not be null.");
        }
        if (subHeaderText == null) {
            throw new IllegalArgumentException("Parameter 'subHeaderText' must not be null.");
        }
        if (footerText == null) {
            throw new IllegalArgumentException("Parameter 'footerText' must not be null.");
        }
        this.headerText = headerText;
        this.subHeaderText = subHeaderText;
        this.footerText = footerText;
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        boolean printAccepted = job.printDialog(attr);
        if (printAccepted) {
            job.print(attr);
            return true;
        }
        return false;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g = (Graphics2D)graphics;
        int x1 = (int)pageFormat.getImageableX();
        int y1 = (int)pageFormat.getImageableY();
        int w1 = (int)pageFormat.getImageableWidth();
        int h1 = (int)pageFormat.getImageableHeight();
        if (this.tablePageFormat == null) {
            this.tablePageFormat = (PageFormat)pageFormat.clone();
            Paper paperJTable = this.tablePageFormat.getPaper();
            if (this.tablePageFormat.getOrientation() == 1) {
                paperJTable.setImageableArea(x1, y1 + 60, w1, h1 - 90);
            } else {
                paperJTable.setImageableArea(y1 + 60, x1, h1 - 90, w1);
            }
            this.tablePageFormat.setPaper(paperJTable);
        }
        String header = this.headerText;
        String subHeader = this.subHeaderText;
        Font f = g.getFont();
        g.setFont(g.getFont().deriveFont(15.0f));
        FontMetrics fm = g.getFontMetrics();
        g.drawString(header, x1 + (w1 - fm.stringWidth(header)) / 2, y1 + 15);
        g.setFont(f);
        fm = g.getFontMetrics();
        g.drawString(subHeader, x1 + (w1 - fm.stringWidth(subHeader)) / 2, y1 + 30);
        g.drawRect(x1, y1, w1, 40);
        String footer = TextUtility.format(this.footerText, TextUtility.formatAsDecimal(pageIndex + 1));
        g.drawString(footer, x1 + (w1 - fm.stringWidth(footer)) / 2, y1 + h1 - 10);
        Graphics gCopy = g.create();
        int retVal = this.tablePrintable.print(gCopy, this.tablePageFormat, pageIndex);
        gCopy.dispose();
        return retVal;
    }
}

