/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.gui.AttributeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

final class AttributeTableHeader {
    AttributeTableHeader() {
    }

    public static void install(JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Parameter 'table' must not be null.");
        }
        table.getColumnModel().addColumnModelListener(new CustomColumnModelListener(table));
        JTableHeader header = table.getTableHeader();
        MouseListener[] mouseListenerArray = header.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener ml = mouseListenerArray[n2];
            if (ml instanceof BasicTableHeaderUI.MouseInputHandler) {
                CustomTableHeaderListener altered = new CustomTableHeaderListener(table, (BasicTableHeaderUI.MouseInputHandler)ml);
                header.removeMouseListener(ml);
                header.addMouseListener(altered);
            }
            ++n2;
        }
        header.setDefaultRenderer(new CustomerTableHeaderRenderer());
    }

    private static final class AttributeSortKey
    extends RowSorter.SortKey {
        public AttributeSortKey(int column, SortOrder sortOrder) {
            super(column, sortOrder);
        }

        public String toString() {
            return "column=" + this.getColumn() + ", sortOrder=" + this.getSortOrder().toString();
        }
    }

    private static final class CustomColumnModelListener
    implements TableColumnModelListener {
        private final JTable table;

        public CustomColumnModelListener(JTable table) {
            this.table = table;
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            int to;
            int from = e.getFromIndex();
            if (from != (to = e.getToIndex())) {
                int fromModel = this.table.convertColumnIndexToModel(from);
                int toModel = this.table.convertColumnIndexToModel(to);
                RowSorter<? extends TableModel> sorter = this.table.getRowSorter();
                List<RowSorter.SortKey> oldKeys = sorter.getSortKeys();
                RowSorter.SortKey fromKey = this.getSortKeyWithColumn(fromModel, oldKeys);
                RowSorter.SortKey toKey = this.getSortKeyWithColumn(toModel, oldKeys);
                if (fromKey != null && toKey != null) {
                    ArrayList<RowSorter.SortKey> newKeys = new ArrayList<RowSorter.SortKey>();
                    for (RowSorter.SortKey k : oldKeys) {
                        if (fromModel == k.getColumn()) {
                            newKeys.add(this.getSortKeyWithColumn(toModel, oldKeys));
                            continue;
                        }
                        if (toModel == k.getColumn()) {
                            newKeys.add(this.getSortKeyWithColumn(fromModel, oldKeys));
                            continue;
                        }
                        newKeys.add(k);
                    }
                    sorter.setSortKeys(newKeys);
                }
            }
        }

        private RowSorter.SortKey getSortKeyWithColumn(int col, List<? extends RowSorter.SortKey> oldKeys) {
            if (oldKeys == null) {
                throw new IllegalArgumentException("Parameter 'oldKeys' must not be null.");
            }
            for (RowSorter.SortKey sortKey : oldKeys) {
                if (sortKey.getColumn() != col) continue;
                return sortKey;
            }
            return null;
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private static final class CustomTableHeaderListener
    implements MouseListener,
    MouseMotionListener {
        private JTable table;
        private MouseListener original;
        private MouseMotionListener originalMotion;

        public CustomTableHeaderListener(JTable table, BasicTableHeaderUI.MouseInputHandler original) {
            if (table == null) {
                throw new IllegalArgumentException("Parameter 'table' must not be null.");
            }
            if (original == null) {
                throw new IllegalArgumentException("Parameter 'original' must not be null.");
            }
            this.table = table;
            this.original = original;
            this.originalMotion = original;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn = this.table.columnAtPoint(e.getPoint());
            int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
            RowSorter<? extends TableModel> sorter = this.table.getRowSorter();
            List<RowSorter.SortKey> oldSortKeys = sorter.getSortKeys();
            boolean extend = e.isShiftDown() || e.isControlDown();
            ArrayList<RowSorter.SortKey> newSortKeys = new ArrayList<RowSorter.SortKey>();
            AttributeTableModel tableModel = (AttributeTableModel)this.table.getModel();
            if (tableModel.getColumn(modelColumn).isSortable()) {
                boolean toggled = false;
                for (RowSorter.SortKey sortKey : oldSortKeys) {
                    if (sortKey.getColumn() == modelColumn) {
                        SortOrder oldSortOrder = sortKey.getSortOrder();
                        SortOrder newSortOrder = oldSortOrder == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                        newSortKeys.add(new AttributeSortKey(modelColumn, newSortOrder));
                        toggled = true;
                        continue;
                    }
                    if (!extend) continue;
                    newSortKeys.add(sortKey);
                }
                if (!toggled) {
                    newSortKeys.add(new AttributeSortKey(modelColumn, SortOrder.ASCENDING));
                }
                sorter.setSortKeys(newSortKeys);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.original.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.original.mouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.original.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.original.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.originalMotion.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.originalMotion.mouseMoved(e);
        }
    }

    private static final class CustomerTableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private Icon ascendingSortIcon;
        private Icon descendingSortIcon;
        private Icon unsortedSortIcon;
        private Icon sortIcon;
        private EmptyIcon emptyIcon;

        public CustomerTableHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.emptyIcon = new EmptyIcon();
            this.ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
            this.descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");
            this.unsortedSortIcon = UIManager.getIcon("Table.naturalSortIcon");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Icon sortIcon = null;
            boolean isPaintingForPrint = false;
            if (table != null) {
                SortOrder sortOrder;
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    Color fgColor = null;
                    Color bgColor = null;
                    if (hasFocus) {
                        fgColor = UIManager.getColor("TableHeader.focusCellForeground");
                        bgColor = UIManager.getColor("TableHeader.focusCellBackground");
                    }
                    if (fgColor == null) {
                        fgColor = header.getForeground();
                    }
                    if (bgColor == null) {
                        bgColor = header.getBackground();
                    }
                    this.setForeground(fgColor);
                    this.setBackground(bgColor);
                    this.setFont(header.getFont());
                    isPaintingForPrint = header.isPaintingForPrint();
                }
                if (!isPaintingForPrint && table.getRowSorter() != null && (sortOrder = CustomerTableHeaderRenderer.getColumnSortOrder(table, column)) != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = this.ascendingSortIcon;
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = this.descendingSortIcon;
                            break;
                        }
                        case UNSORTED: {
                            sortIcon = this.unsortedSortIcon;
                        }
                    }
                }
            }
            this.setText(value == null ? "" : value.toString());
            this.setIcon(sortIcon);
            Border border = null;
            if (hasFocus) {
                border = UIManager.getBorder("TableHeader.focusCellBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("TableHeader.cellBorder");
            }
            this.setBorder(border);
            return this;
        }

        private static SortOrder getColumnSortOrder(JTable table, int viewColumn) {
            int modelColumn = table.convertColumnIndexToModel(viewColumn);
            List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
            SortOrder sortOrder = SortOrder.UNSORTED;
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey.getColumn() != modelColumn) continue;
                sortOrder = sortKey.getSortOrder();
            }
            return sortOrder;
        }

        @Override
        public void paintComponent(Graphics g) {
            boolean b = UIManager.getBoolean("TableHeader.rightAlignSortArrow");
            if (b && this.sortIcon != null) {
                this.emptyIcon.width = this.sortIcon.getIconWidth();
                this.emptyIcon.height = this.sortIcon.getIconHeight();
                this.setIcon(this.emptyIcon);
                super.paintComponent(g);
                Point position = this.computeIconPosition(g);
                this.sortIcon.paintIcon(this, g, position.x, position.y);
            } else {
                super.paintComponent(g);
            }
        }

        private Point computeIconPosition(Graphics g) {
            FontMetrics fontMetrics = g.getFontMetrics();
            Rectangle viewR = new Rectangle();
            Rectangle textR = new Rectangle();
            Rectangle iconR = new Rectangle();
            Insets i = this.getInsets();
            viewR.x = i.left;
            viewR.y = i.top;
            viewR.width = this.getWidth() - (i.left + i.right);
            viewR.height = this.getHeight() - (i.top + i.bottom);
            SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.sortIcon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, this.getIconTextGap());
            int x = this.getWidth() - i.right - this.sortIcon.getIconWidth();
            int y = iconR.y;
            return new Point(x, y);
        }

        private static final class EmptyIcon
        implements Icon,
        Serializable {
            int width = 0;
            int height = 0;

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }
        }
    }
}

