/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.thecartstudio.model.CartridgeDatabaseEntry;
import com.wudsn.tools.thecartstudio.model.ContentType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public final class CartridgeDatabase {
    private static final char QUOTE_CHAR = '\"';
    public static final String FILE_PATH = "data/CartridgeDatabase.csv";
    private static final char SEPARATOR_CHAR = ';';
    private static final String NEW_LINE_CHARS = "\r\n";
    private List<CartridgeDatabaseEntry> entries = new ArrayList<CartridgeDatabaseEntry>();
    private TreeMap<Long, CartridgeDatabaseEntry> entriesByCRC32 = new TreeMap();
    private TreeMap<String, CartridgeDatabaseEntry> entriesByMD5 = new TreeMap();
    private int knownContentTypesCount;

    private void clear() {
        this.entries.clear();
        this.entriesByCRC32.clear();
        this.entriesByMD5.clear();
        this.knownContentTypesCount = 0;
    }

    public List<CartridgeDatabaseEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int getKnownTitelsCount() {
        return this.entries.size();
    }

    public int getKnownContentTypesCount() {
        return this.knownContentTypesCount;
    }

    public CartridgeDatabaseEntry getEntryByCRC32(int sizeInKB, int crc32) {
        Long key = new Long(sizeInKB << 32 | crc32);
        return this.entriesByCRC32.get(key);
    }

    public CartridgeDatabaseEntry getEntryByMD5(String md5) {
        if (md5 == null) {
            throw new IllegalArgumentException("Parameter 'md5' must not be null.");
        }
        return this.entriesByMD5.get(md5);
    }

    public CartridgeDatabaseEntry addEntry(int sizeInKB, int crc32, String md5, String title, ContentType contentType, String source) {
        CartridgeDatabaseEntry entry = new CartridgeDatabaseEntry(sizeInKB, crc32, md5, title, contentType, source);
        this.entries.add(entry);
        if (entry.getCRC32() != 0) {
            this.entriesByCRC32.put(entry.getCRC32Key(), entry);
        }
        if (StringUtility.isSpecified(md5)) {
            this.entriesByMD5.put(entry.getMD5(), entry);
        }
        if (entry.getContentType() != ContentType.UNKNOWN) {
            ++this.knownContentTypesCount;
        }
        return entry;
    }

    public void load() {
        this.clear();
        String content = ResourceUtility.loadResourceAsString(FILE_PATH);
        if (content == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = "";
        try {
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                int index1 = line.indexOf(59);
                int index2 = line.indexOf(59, index1 + 1);
                int index3 = line.indexOf(59, index2 + 1);
                int index4 = line.indexOf(34, index3 + 2);
                int index5 = line.indexOf(59, index4 + 2);
                String sizeInKBValue = line.substring(0, index1);
                int sizeInKB = Integer.parseInt(sizeInKBValue);
                String crc32Value = line.substring(index1 + 2, index2);
                int crc32 = (int)Long.parseLong(crc32Value, 16);
                String md5 = line.substring(index2 + 2, index3);
                String title = line.substring(index3 + 2, index4);
                String contentTypeId = line.substring(index4 + 2, index5);
                ContentType contentType = ContentType.getInstance(contentTypeId);
                String source = line.substring(index5 + 1);
                this.addEntry(sizeInKB, crc32, md5, title, contentType, source);
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new RuntimeException("Error while processing line: '" + line + "'", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void save(File file) throws CoreException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("sep=;");
        try {
            for (CartridgeDatabaseEntry entry : this.entriesByCRC32.values()) {
                printWriter.print(entry.getSizeInKB());
                printWriter.print(';');
                printWriter.print("'");
                printWriter.print(entry.getCRC32String());
                printWriter.print(';');
                printWriter.print("'");
                printWriter.print(entry.getMD5());
                printWriter.print(';');
                printWriter.print('\"');
                printWriter.print(entry.getTitle());
                printWriter.print('\"');
                printWriter.print(';');
                printWriter.print(entry.getContentType().getId());
                printWriter.print(';');
                printWriter.print(entry.getSource());
                printWriter.print(NEW_LINE_CHARS);
            }
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error during serialization", ex);
        }
        FileUtility.writeString(file, writer.toString());
    }
}

