/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.repository.RepositoryValidation;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.WorkbookGenre;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;

public final class WorkbookGenreValidation {
    public static final WorkbookGenreValidation createInstance() {
        return new WorkbookGenreValidation();
    }

    public void validateSave(WorkbookRoot root, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        int size = root.getUnmodifiableGenresList().size();
        if (size > 128) {
            messageQueue.sendMessage(root, null, Messages.E427, TextUtility.formatAsDecimal(size), TextUtility.formatAsDecimal(128L));
        }
        for (WorkbookGenre genre : root.getUnmodifiableGenresList()) {
            this.validateSave(root, genre, messageQueue);
        }
    }

    public void validateSave(WorkbookRoot root, WorkbookGenre genre, MessageQueue messageQueue) {
        String name;
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (genre == null) {
            throw new IllegalArgumentException("Parameter 'genre' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        RepositoryValidation rv = RepositoryValidation.createInstance(messageQueue);
        if (rv.isStringSpecified(genre, WorkbookGenre.Attributes.NAME, name = genre.getName())) {
            if (name.equalsIgnoreCase("All")) {
                messageQueue.sendMessage(genre, WorkbookGenre.Attributes.NAME, Messages.E426, "All");
            } else {
                rv.isStringValid(genre, WorkbookGenre.Attributes.NAME, genre.getName());
            }
        }
    }

    public void validateExport(WorkbookRoot root, WorkbookGenre genre, MessageQueue messageQueue) {
        if (root == null) {
            throw new IllegalArgumentException("Parameter 'root' must not be null.");
        }
        if (genre == null) {
            throw new IllegalArgumentException("Parameter 'genre' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
    }
}

