/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model.maxflash;

import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.ByteArrayUtility;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.model.AtrProgrammingFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class MaxflashImporter {
    private static final int BANK_SIZE = 8192;
    private static final int ATR_MAX_MIN_FILE_SIZE = 10640;
    private static final int ATR_MAX_MAX_FILE_SIZE = 0x200000;
    private static final String BUILD_PREFIX = "ATARIMAX Flash Utility Build ";
    private static final byte[] BUILD_PREFIX_BYTES = ASCIIString.getBytes("ATARIMAX Flash Utility Build ");
    public static final int MODE_UNKNOWN_SIGNATURE = 1;
    private static final int MODE_FULL_IMAGE = 2;
    private static final int MODE_USAGE_MAP = 3;
    private List<AtrProgrammingFile.BuildInfo> buildInfos = new ArrayList<AtrProgrammingFile.BuildInfo>();

    public MaxflashImporter() {
        this.addBuildInfo("ATARIMAX Flash Utility Build 11032003", 1307, 2, 2064);
        this.addBuildInfo("ATARIMAX Flash Utility Build 11032003", 1312, 2, 2064);
        this.addBuildInfo("ATARIMAX Flash Utility Build 05292003", 1294, 2, 2064);
        this.addBuildInfo("ATARIMAX Flash Utility Build 08252004", 1552, 3, 1422);
        this.addBuildInfo("ATARIMAX Flash Utility Build 04092005", 1552, 3, 1422);
        this.addBuildInfo("ATARIMAX Flash Utility Build 04092005", 1555, 3, 1425);
        this.addBuildInfo("ATARIMAX Flash Utility Build 08152009", 1563, 3, 1433);
        this.addBuildInfo("ATARIMAX Flash Utility Build 10032011", 1571, 3, 1441);
        this.addBuildInfo("ATARIMAX Flash Utility Build 04072012", 1579, 3, 1449);
        this.buildInfos = Collections.unmodifiableList(this.buildInfos);
    }

    private void addBuildInfo(String signature, int signatureOffset, int mode, int modeOffset) {
        if (signature == null) {
            throw new IllegalArgumentException("Parameter 'signature' must not be null.");
        }
        if (signatureOffset < 0) {
            throw new IllegalArgumentException("Parameter 'signatureOffset' must not be negative. Specified value was " + signatureOffset + ".");
        }
        this.buildInfos.add(new AtrProgrammingFile.BuildInfo(signature, signatureOffset, mode, modeOffset));
    }

    public void determineCartridgeTypeAndBuild(AtrProgrammingFile atrProgrammingFile) {
        int signatureOffset;
        if (atrProgrammingFile == null) {
            throw new IllegalArgumentException("Parameter 'programmingImage' must not be null.");
        }
        CartridgeType cartridgeType = null;
        AtrProgrammingFile.BuildInfo buildInfo = null;
        if (atrProgrammingFile.getSourceFileContentSize() <= 131072) {
            cartridgeType = CartridgeType.CARTRIDGE_ATMAX_128;
        } else if (atrProgrammingFile.getSourceFileContentSize() <= 0x100000) {
            cartridgeType = CartridgeType.CARTRIDGE_ATMAX_1024;
        } else {
            return;
        }
        int i = 0;
        while (i < this.buildInfos.size() && buildInfo == null) {
            AtrProgrammingFile.BuildInfo currentBuildInfo = this.buildInfos.get(i);
            if (atrProgrammingFile.containsStringAt(atrProgrammingFile.getBootCode(), currentBuildInfo.signature, currentBuildInfo.signatureOffset - 16)) {
                buildInfo = currentBuildInfo;
            }
            ++i;
        }
        if (buildInfo == null && (signatureOffset = ByteArrayUtility.getIndexOf(atrProgrammingFile.getBootCode(), 0, 8191, BUILD_PREFIX_BYTES)) >= 0) {
            String signature = new String(atrProgrammingFile.getBootCode(), signatureOffset + BUILD_PREFIX_BYTES.length, 8);
            buildInfo = new AtrProgrammingFile.BuildInfo(signature, signatureOffset, 1, 0);
        }
        atrProgrammingFile.setCartridgeTypeAndBuildInfo(cartridgeType, buildInfo);
    }

    public byte[] createCartridgeContent(AtrProgrammingFile atrProgrammingFile) throws CoreException {
        if (atrProgrammingFile == null) {
            throw new IllegalArgumentException("Parameter 'programmingImage' must not be null.");
        }
        byte[] cartridgeContent = atrProgrammingFile.createCartridgeContent();
        AtrProgrammingFile.BuildInfo buildInfo = atrProgrammingFile.getBuildInfo();
        Log.logInfo("Processing {0}: {1}", new Object[]{atrProgrammingFile.getSourceFilePath(), buildInfo.toString()});
        switch (buildInfo.mode) {
            case 2: {
                int sourceFileOffset = atrProgrammingFile.getSourceFileContentOffset() - buildInfo.modeOffset;
                System.arraycopy(atrProgrammingFile.getSourceFileContent(), sourceFileOffset, cartridgeContent, 0, atrProgrammingFile.getSourceFileContentSize());
                break;
            }
            case 3: {
                int bootCodeUsageMapOffset = buildInfo.modeOffset - 16;
                int sourceFileContentOffset = 0;
                int cartridgeContentOffset = 0;
                int banksCount = cartridgeContent.length / 8192;
                int i = 0;
                while (i < banksCount) {
                    byte usage = atrProgrammingFile.getBootCode()[bootCodeUsageMapOffset + i];
                    if (usage == 0) {
                        System.arraycopy(atrProgrammingFile.getSourceFileContent(), sourceFileContentOffset, cartridgeContent, cartridgeContentOffset, 8192);
                        sourceFileContentOffset += 8192;
                    } else if (usage == -1) {
                        Arrays.fill(cartridgeContent, cartridgeContentOffset, cartridgeContentOffset + 8192, (byte)-1);
                    } else {
                        throw new CoreException(Messages.E503, TextUtility.formatAsHexaDecimal(usage, 256L), TextUtility.formatAsHexaDecimal(bootCodeUsageMapOffset, bootCodeUsageMapOffset), atrProgrammingFile.getSourceFilePath());
                    }
                    cartridgeContentOffset += 8192;
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Content creation for mode " + buildInfo.mode + " is not supported.");
            }
        }
        return cartridgeContent;
    }

    public boolean isRelevant(String fileName, long fileLength) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 'fileName' must not be null.");
        }
        boolean result = fileName.toLowerCase().endsWith(".atr") && fileLength > 10640L && fileLength < 0x200000L;
        return result;
    }
}

