;===============================================
;BINARY LOAD from T: device
;
;===============================================

;Minimalistic implementation of BINARY LOAD

BLSTART=3242
          .INCLUDE "equates.asm"

          *=3242
          
          jsr STARTUP
          jsr FOPEN               ;Call subroutine that opens T: file
          lda $353                ;Check for error
          bpl BLHEADER            ;No error, continue
          jmp ERRHNDL             ;If error occured, go to handle it               

;---------------------------------------------------------
; Segment data processing
;---------------------------------------------------------


BLDATA    lda #<FAKEINIT          ;Set INIT vector to RTS
          sta 738
          lda #>FAKEINIT
          sta 739


INSEG     jsr GETBYTE             ;Call subroutine that reads one byte
          lda BLSEGHEAD
          sta LTEMP
          lda BLSEGHEAD+1
          sta LTEMP+1
          lda BLBYTE
          ldy #0
          sta (LTEMP),Y           ;Store read byte to memory

CHCKSGE   lda BLSEGHEAD           ;Check for end of segment
          cmp BLSEGHEAD+2
          bne SEGINCR
          lda BLSEGHEAD+1
          cmp BLSEGHEAD+3
          bne SEGINCR

          jsr DOINIT              ;End of segment
          jmp BLHEADER

SEGINCR   inc BLSEGHEAD           ;Update current position in segment
          bne IS2
          inc BLSEGHEAD+1

IS2       jmp INSEG               ;Continue segment data processing


;---------------------------------------------------------
; Segment header processing
;---------------------------------------------------------
BLHEADER  jsr GETBYTE             ;Obtain first two header bytes
          lda BLBYTE
          sta BLSEGHEAD
          jsr GETBYTE
          lda BLBYTE
          sta BLSEGHEAD+1

          cmp #255                ;Check for 255 255
          bne BLH1
          lda BLSEGHEAD
          cmp #255
          bne BLH1
          
          lda #0                  ;255 255 header found
          sta BLNOBINFLAG         ;Indicate it
          jmp BLHEADER            

BLH1      lda BLNOBINFLAG         ;Check whether 255 255 flag was found
          cmp #1
          bne BLH2                ;If not found ,handle error
          jmp ERRNOBIN
            
BLH2      jsr GETBYTE             ;Obtain next two header bytes
          lda BLBYTE
          sta BLSEGHEAD+2
          jsr GETBYTE
          lda BLBYTE
          sta BLSEGHEAD+3

          lda BLFIRSTFLAG         ;Check whether this is first segment
          cmp #1
          bne BLHE                ;If not, continue

          lda BLSEGHEAD           ;Address of first segment is stored
          sta 736                 ;to 736,737
          lda BLSEGHEAD+1
          sta 737
          lda #0
          sta BLFIRSTFLAG


BLHE      jmp BLDATA              ;Done with header, process data

;====================================================
;Subroutine that gets byte using CIO
;====================================================
GETBYTE ldx #16                   ;16 represents offset for channel 1
        lda #7                    ;requesting cio read operation

        sta $0342,X               ;Requesting reading to BLBYTE
        lda #<BLBYTE
        sta $0344,X
        lda #>BLBYTE
        sta $0345,X

        lda #1                    ;Requesting 1 byte
        sta $0348,X
        lda #0
        sta $0349,X
        jsr CIOV                  ;Call CIO

        lda $353                  ;Check for error
        bmi GBERR                 ;Error occured - handle it
        rts

GBERR   tax                       ;Error code to X
        pla                       ;Pull A from stack - dirty return from
        txa                       ;subroutine and put error code back to A

        cmp #136                  ;Is this EOF ?
        bne ERRHNDL               ;No - handle error
        jsr FCLOSE                ;OK - close file
        jmp (736)                 ;RUN loaded binary file
 
;====================================================
;Emulation of JSR(738)
;====================================================
DOINIT    jmp (738)
FAKEINIT  rts

;====================================================
;Main data area
;====================================================
BLBYTE      .BYTE 0              ;Byte currently processed
BLSEGHEAD   .BYTE 0,0,0,0        ;Segment header and position pointer
BLFIRSTFLAG .BYTE 1              ;First segment indication
BLNOBINFLAG .BYTE 1

BLTITLE     .BYTE "T:",155       ;Program title and also file name
BLMSGNOBIN  .BYTE "B",155        ;X message indicates not binary file
BLMSGERR    .BYTE "E",155        ;E message indicates I/O error

;====================================================
;Subroutine that closes file
;====================================================

FCLOSE    ldx #16         ;16 represent offset for channel 1
          lda #12         ;Requesting CIO CLOSE operation with code 12
          sta $0342,X     
          jsr CIOV        ;Call CIO
          rts             

;====================================================
;Subroutine that opens file
;====================================================
FOPEN     ldx #16                ;16 represents offset for channel 1
          lda #3                 ;Requesting CIO OPEN operation with code 3
          sta $0342,X     
          lda #4                 ;Auxiliary value 4 - open for reading
          sta $034A,X  
   
          lda #<BLTITLE          ;Setting address of buffer
          sta $0344,X
          lda #>BLTITLE
          sta $0345,X
          jsr CIOV               ;Call CIO

          lda #1
          sta BLFIRSTFLAG        ;First segment of binary file to be loaded
          sta BLNOBINFLAG        ;Not binary file flag - no 255 255 header reached yet
          rts 

;====================================================
;Error handling
;====================================================
ERRHNDL  ldx #<BLMSGERR
         ldy #>BLMSGERR
         jsr $C642
         jmp BLSTART

ERRNOBIN ldx #<BLMSGERR
         ldy #>BLMSGERR
         jsr $C642
         jmp BLSTART

;=====================================================
; Loader startup
;=====================================================
STARTUP   lda #0                  ;Reset cold start flag
          sta 580
          lda #1                  ;Indicate disk boot succeded
          sta 9
          
          ldx #<BLTITLE           ;Show title          
          ldy #>BLTITLE
          jsr $C642
          rts
           
         *=736                  ;RUN segment
         .BYTE <BLSTART,>BLSTART
