;===============================================
;ROTDEV   (Turbo 2000 - kilobyte blocks, 
;         Czechoslovakia)
;===============================================

;Turbo 2000 - kilobyte blocks read only CIO handler 
;T: device that supports only READ operation
  

LOADER = 2818                     ;Handler address
KBLOCK = 1792                     ;Address of kilobyte block
NAMEBUFFER=1792                   ;There will be file name
                                  ;placed

HANDLERINIT=2750                  ;T: handler initialization routine
                                  ;Address

          .INCLUDE "equates.asm"
          *=LOADER

;================================================
;Turbo block loading
;================================================

LOADBLOCK jsr SETBUFFER           ;Call subroutine that sets up buffer

          lda #255                ;Load kilobyte block
          jsr L0631
          
          bcc FAILED              ;If error occured, go to handle it

          ldy #0                  ;No error, Y=0
          rts

FAILED    ldy #128                ;Error, Y=128
          rts  

;====================================================
;Buffer setup
;====================================================
SETBUFFER lda #<KBLOCK
          sta BUFRLO
          lda #>KBLOCK
          sta BUFRHI
          lda #<[KBLOCK+1024]
          sta BFENLO
          lda #>[KBLOCK+1024]
          sta BFENHI
          rts
;====================================================
;Buffer ranges setup for user data
;====================================================
SETDATABUFFER jsr SETBUFFER       ;Set as for full block
              
              ldx RECVDN          ;EOF block ?                                 
              cpx #5
              beq SDBEOF          ;Yes, handle EOF block

              cpx #0              ;Full block ?
              bne SDBPB           ;No, branch to handle partial block
              rts                 ;Yes, we are done

SDBPB         stx LTEMP           ;Partial block
              lda #4
              sec
              sbc LTEMP           ;A holds number of pages
              clc
              adc #>KBLOCK
              tax                 ;X holds BFENHI without correction

              clc                 ;Calculating BFENLO
              lda #<KBLOCK
              adc [KBLOCK+1023]   
              sta BFENLO
              bcc SDBPB1          ;Correction of BFENHI
              inx  
SDBPB1        stx BFENHI
              rts   

SDBEOF        lda #>KBLOCK        ;EOF block
              sta BFENHI          ;Buffer ends at its start
              lda #<KBLOCK
              sta BFENLO
              rts

;====================================================
;One byte reading
;====================================================

GETBYTE   lda BUFRLO              ;Past end of block ?
          cmp BFENLO              
          bne FROMBUF             ;No, get byte from buffer
          lda BUFRHI              
          cmp BFENHI               
          bne FROMBUF             ;No, get byte from buffer

GBPEB     lda RECVDN              ;Past end of block
          cmp #0                  ;Full block ?
          bne DOEOF               ;No, run binary file

GBNB      jsr LOADBLOCK           ;Past end and not EOF or partial block, load block

          cpy #0                  ;Block loaded OK ?
          bne FB2                 ;No - Y holds error code and we are bailing out

          jsr SETDATABUFFER           

FROMBUF   ldy #0                  ;Reading byte from buffer
          lda (BUFRLO),Y          ;Buffer is stored in accumulator
          inc BUFRLO
          bne FB2
          inc BUFRHI              

FB2       rts          

DOEOF     ldy #136                ;EOF - Y holds EOR 'error code'
          rts 


;==============================================
;Block decoding subroutine
;Block is placed from: BUFRLO+256*BUFRHI
;                to:   (BFENLO+256*BFENHI)-1
;First byte of the block should be in
;acumulator register before subroutine
;is called        

;Mapping 4Z - 67
;        6Z - 68

;==============================================     
L0631       sta LTEMP
            lda #52
            sta PACTL
            sta PBCTL
            lda #128
            sta POKMSK
            sta IRQEN
            clc
            ldy #0
            sty STATUS
            sty CHKSUM
            sty NMIEN
            sty DMACLT
            php
L0650       bne L06C2
L0652       jsr L06DB
            bcc L0650
            lda #0
            sta 67
            sta LTEMP+1
L065D       ldy #180
L065F       jsr L06D6
            bcc L0650
            cpy #216
            bcc L0652
            inc 67
            bne L065D
            dec LTEMP+1
L066E       ldy #209
            jsr L06DB
            bcc L0650
            cpy #222
            bcs L066E
            jsr L06DB
            bcc L06C2
            ldy #198
            jmp L069D
L0683       plp
            bne L068E
            lda LTEMP
            eor 68
LXXX        sta RECVDN
            jmp L069A
L068E       ldy #0
            lda 68
            sta (BUFRLO),Y
            inc BUFRLO
            bne L069A
            inc BUFRHI
L069A       ldy #200
            php
L069D       lda #1
            sta 68
L06A1       jsr L06D6
            bcc L06C2
            cpy #227
            rol 68
            ldy #198
            bcc L06A1
            lda CHKSUM
            eor 68
            sta CHKSUM
            lda BUFRLO
            cmp BFENLO
            lda BUFRHI
            sbc BFENHI
            bcc L0683
            lda #0
            cmp CHKSUM
L06C2       pla
L06C3       lda #192
            sta NMIEN
            sta POKMSK
            sta IRQEN
            lda #60
            sta PACTL
            sta PBCTL
            rts
L06D6       jsr L06DB
            bcc L06FF
L06DB       ldx #4
L06DD       dex
            bne L06DD
            lda STATUS
            lsr A 
            and LTEMP+1
            sta COLBK
L06E8       iny
            beq L06FE
            lda BRKKEY
            beq L06FC
            lda SKSTAT
            and #16
            cmp STATUS
            beq L06E8
            sta STATUS
            sec
            rts
L06FC       dec BRKKEY
L06FE       clc
L06FF       rts


;============================================================================
;Tape beep
;============================================================================
BEEP      lda #255
          sta 764
          lda #1
          jsr 65020
          rts

;=============================================================================
;Opening file
;=============================================================================

OPEN      LDA ICAX1Z             ;Determining type of operation
          AND #12
          CMP #4       
          BNE QUITOPEN           ;No READ operation, quit silently   

          jsr BEEP               ;Beep and wait for key

RDNM      lda #<NAMEBUFFER       ;Set buffer for reading name
          sta BUFRLO
          lda #>NAMEBUFFER
          sta BUFRHI
          lda #<[NAMEBUFFER+17]
          sta BFENLO
          lda #>[NAMEBUFFER+17]
          sta BFENHI
          
          lda #0                 ;Decode turbo block

          jsr L0631
          bcc RDNM               ;Reading header failed, try again

PRTHD     lda #155               ;Print file name
          sta [NAMEBUFFER+17]
          ldx #<[NAMEBUFFER+1]
          ldy #>[NAMEBUFFER+1]
         
;EXPRNT    jsr $C642

FRCRDB    lda #<[KBLOCK+1024]   ;Open succesfull, force GETBYTE
          sta BUFRLO            ;to read block at the beginning
          sta BFENLO
          lda #>[KBLOCK+1024]
          sta BUFRHI
          sta BFENHI

QUITOPEN  ldy #0                ;Indicate OPEN succesfull
          sty RECVDN
          rts

;================================================================
;Closing file
;================================================================
CLOSE     ldy #1
          rts  

FAKEFUN   ldy #0
          rts

;================================================================
;HATABS entry
;================================================================
HTBENT  .WORD OPEN-1              ;OPEN routine
        .WORD CLOSE-1             ;CLOSE routine
        .WORD GETBYTE-1           ;GETBYTE routine
        .WORD FAKEFUN-1           ;PUTBYTE routine - not implemented
        .WORD $FDCB               ;GETSTATUS routine
        .WORD $FCE4               ;SPECIAL routine
        jmp CLOSE                 ;Jump to the initialization



;================================================================
;CIO handler initialization.
;================================================================

        *=HANDLERINIT 

STARTUP ldy  #0                   ;Handler table initialization

NF      lda 794,Y                 ;Empty field found ?
        beq PF                    ;Yes - jump to PF
        iny                       ;Move to next field
        iny
        iny
        cpy  #33                  ;At end of table
        bcc NF                    ;No - continue

PF      lda  #'T                  ;T: device
        sta 794,Y
        lda  #<HTBENT             ;Links to handler routines
        sta 795,Y
        lda  #>HTBENT
        sta 796,Y
        
        rts 
         
        *=738                     ;INIT segment
        .WORD HANDLERINIT         