;==============================================
;Universal turbo (Czechoslovakia) loader
;==============================================


            *= 1183
            .INCLUDE "equates.asm"


L049F       jsr BOOTINIT        ;Setup DOS vector

            lda #<TITLE         ;Display title
            ldy #>TITLE
            jsr L0587
    
L04A6       jsr L054F           ;Beep

            lda #52             ;Tape motor switched on
            sta PACTL
            sta PBCTL

;----------------------------------------------
;Turbo header decoding
;----------------------------------------------

L04B1       jsr L0634           ;Call subroutine for clearing status variables. Disable interrupts.
            jsr L0645           ;Call subroutine for speed detection (T2K or ST)
                            
            jsr L05FC           ;Enable interrupts

L04BA       lda BUFRFL
            cmp #180            ;Check T2K/ST
            bcc L0513           ;T2K - jump, ST - continue

            lda #155            ;Setup address where ST header will be placed
            sta BFENLO          ;ST header has 28 bytes
            lda #128
            sta BUFRLO
            asl A
            sta BUFRHI
            sta BFENHI

            lda #183            ;First byte if the block should be 183
            jsr L059C           ;Call subroutine for block decoding

            bcc L04B1           ;If error occured, try to decode the header again

            lda L0095           ;Setup address where main block will be placed
            sta BUFRLO
            clc
            adc L0097
            sta BFENLO
            lda L0096
            sta BUFRHI
            adc L0098
            sta BFENHI
            lda #155
            sta L0095          ;Augment the file name string with EOL
            jsr L056F          ;Call subroutine that displays the file name

;----------------------------------------------
;Main block decoding (Super turbo)
;----------------------------------------------

            lda #237           ;First byte of block should be 237
            jsr L059C          ;Call subroutine for block decoding

            bcc L050D          ;If error occured, jump (issue error message)

            lda L0099          ;Setup RUN address
            sta CASINI
            lda L009A
            sta CASINI+1
L04FB       lda #60            ;Switch off tape motor
            sta PACTL
            sta PBCTL
            lda #0
            sta WARMST
            sta CRSINH
            jmp ($099)         ;Jump to RUN address



L050D       jsr L0583          ;Issue error message
            jmp L04A6          ;Return to the beginning


;----------------------------------------------
;Turbo 2000 handling
;----------------------------------------------

L0513       lda #145           ;Setup address where T2K header will be placed
            sta BFENLO
            lda #128
            sta BUFRLO
            asl A
            sta BUFRHI
            sta BFENHI

            jsr L0605          ;Call subroutine for block decoding that will be set up for T2K
            bcc L04B1          ;If error occured, try to decode the header again

            lda L008B          ;Setup address where the main block will be placed
            sta BUFRLO
            clc
            adc L008D
            sta BFENLO
            lda L008C
            sta BUFRHI
            adc L008E
            sta BFENHI
            lda #155          ;Augment the file name string with EOL
            sta L008B
            jsr L056F         ;Call subroutine that displays file name

            lda #255          ;First byte of the block should be 255
            jsr L0605         ;Call subroutine for block decoding that will be set up for T2K  
            bcc L050D         ;If error occured, jump (issue error message)

            lda L008F         ;Jump to RUN address
            sta CASINI
            lda L0090
            sta CASINI+1
            jmp (CASINI)

;----------------------------------------------
;Beep
;----------------------------------------------

L054F       lda #30
            sta AUDF1
            lda #174
            sta AUDC1
            lda #10
            jsr L057C
            lda #0
            sta AUDF1
            sta AUDC1
            lda LE425
            pha
            lda LE424
            pha
            rts

;----------------------------------------------
;Display text
;----------------------------------------------
L056F       lda #125
            sta LOMEM
            lda #128
            ldy #0
            jsr L0587
            lda #50
L057C       adc RTCLOK+2
L057E       cmp RTCLOK+2
            bne L057E
            rts

L0583       lda #<ERRORTEXT
            ldy #>ERRORTEXT

L0587       ldx #0		
            sta IOCB0+ICBAL
            sty IOCB0+ICBAH
            lda #9
            sta IOCB0+ICCOM
            lda #255
            sta IOCB0+ICBLL
            jmp CIOV

;==============================================
;Block decoding subroutine
;Block is placed from: BUFRLO+256*BUFRHI
;                to:   (BFENLO+256*BFENHI)-1
;First byte of the block should be in
;acumulator register before subroutine
;is called        
;==============================================

L059C       sta LTEMP
            jsr L0634           ;Call subroutine for clearing status variables. Disable interrupts.
            php

L05A2       jsr L0692           ;Measure length of pulse
L05A5       ldy RECVDN          ;Count from MED
            jsr L0697           ;Wait for edge
            bcc L05A2           ;If Y wrapped, repeat
            cpy XMTDON
            bcs L05A5           ;If Y>HIGH repeat
            jsr L0697           ;Wait for edge
            bcc L05FB           ;If Y wrapped, end block decoding
            ldy BUFRFL
            jmp L05D6

L05BA       plp                 ;Store data to memory
            bne L05C5
            lda LTEMP
            eor NOCKSM
            bne L05FC
            beq L05D1
L05C5       ldy #0
            lda NOCKSM
            sta (BUFRLO),Y
            inc BUFRLO
            bne L05D1
            inc BUFRHI
L05D1       ldy BUFRFL
            iny
            iny
            php

L05D6       lda #1
            sta NOCKSM
L05DA       jsr L0692          ;Measure length of pulse
            bcc L05FB          ;If pulse is too long, end block decoding
            cpy RECVDN         ;Compate to MED
            rol NOCKSM         ;Rotate NOCKSM with carry, length >MED "1", length <MED "0"
            ldy BUFRFL
            bcc L05DA          ;If bit 7 was 0, repeat
            lda CHKSUM         ;Update checksum
            eor NOCKSM
            sta CHKSUM

            lda BUFRLO         ;Write number to buffer
            cmp BFENLO
            lda BUFRHI
            sbc BFENHI
            bcc L05BA
            lda #0
            cmp CHKSUM
L05FB       pla


L05FC       lda #64            ;Enable interrupts
            sta NMIEN
            sta IRQEN
            rts



;----------------------------------------------
;Turbo 2000 setup
;----------------------------------------------
L0605       sta LTEMP          ;Setup LO,MED,HI
            jsr L0634
            php
            lda #176
            sta BUFRFL
            lda #214
            sta RECVDN
            jsr L0692
            bcc L05FB
            ldy #0
            jsr L0692
            bcc L05FB
L061F       ldy #200
            jsr L0697
            bcc L05FB
            cpy #215
            bcs L061F
            jsr L0697
            bcc L05FB
            ldy #176
            jmp L05D6

;-----------------------------------------------
;Clear status variables, disable interrupts
;-----------------------------------------------
L0634       ldy #0
            sty STATUS
            sty CHKSUM
            sty NMIEN
            sty DMACLT
            sty IRQEN
            clc
            rts

;-----------------------------------------------
;ST speed detection
;-----------------------------------------------
L0645       jsr L0692           ;Measure length of pulse
            bcc L0645           ;If no CF, repeat
            lda #3
            sta LTEMP+1

L064E       ldy #0
            sty FREQ            ;{{

            ldx #3
L0654       jsr L0692           ;Measure length of 3 pulses {
            bcc L0645           ;No CF, => return to  L0645
            dex
            bne L0654           ;}
            tya                 ;A now holds number of measuring loop passes
            lsr A               ;A=A/2
            pha
            eor #255            ;A = 255-A
            sta BUFRFL          ;LO
            pla
            lsr A
            pha
            eor #255
            sta RECVDN          ;MED
            pla
            lsr A
            eor #255
            sta XMTDON          ;HI
            ldy #0
            jsr L0697           ;Wait for edge
            bcc L0645
L0677       ldy BUFRFL          ;Star from LO
            jsr L0692           ;Measure length of pulse
            bcc L0645
            cpy RECVDN          ;Compare with MED
            bcc L0645           ;If Y<MED, measure speed again
            inc FREQ
            bne L0677           ;256 pulses must have appropriate length
            dec LTEMP+1
            bpl L064E           ;Repeat 4 times }}

            ldy #0
            jsr L0697           ;Wait for edge
            bcc L0645           ;No CF, measure speed again
            rts


;-----------------------------------------------
;Measure length of pulse
;-----------------------------------------------
L0692       jsr L0697           ;Call wait for edge
            bcc L06B4           ;No CF, return

;-----------------------------------------------
;Wait for edge + colour effect
;-----------------------------------------------
L0697       lda RANDOM
            and #228
            ora STATUS
            lsr A
            and LTEMP+1
            sta COLBK

L06A4       iny                 ;Measuring loop
            beq L06B4
            lda SKSTAT
            and #16
            cmp STATUS
            beq L06A4
            sta STATUS
            sec
            rts
L06B4       clc
            rts


;-----------------------------------------------
;Strings
;-----------------------------------------------
TITLE	    .byte "UniTurbo",155
ERRORTEXT   .byte "Error",155
LDBGCOLOR   .byte 226


;-----------------------------------------------
;Initialization of DOS vectors
;-----------------------------------------------
BOOTINIT    lda #<L049F
            sta DOSINI
            lda #>L049F
            sta DOSINI+1
            lda #0
            sta WARMST
            rts
