;==============================================
;TURBO 2000 (Czechoslovakia) loader
;==============================================


            .INCLUDE "equates.asm"
            *=1024

L05D2       jsr DOSINIT       ;Setup DOS vectors   
            ldx #<TITLE       ;Display title
            ldy #>TITLE
            jsr LC642
            lda #1            ;One tape beep
            jsr LFDFC  


L05D7       lda #4            ;Setup address where turbo header will be placed
            sta BUFRHI
            sta BFENHI
            lda #17
            sta BFENLO
            lda #0            ;First byte of the block should be 0 
            sta BUFRLO
            jsr L0631         ;Call Turbo 2000 block decoding subroutine
            bcc L05D7         ;If error occured, try to decode the header again
 
            lda L040B         ;Setup address where main block will be placed
            sta BUFRLO
            clc
            adc L040D
            sta BFENLO
            lda L040C
            sta BUFRHI
            adc L040E
            sta BFENHI

            lda #125          ;Display file name
            sta L0400
            lda #155
            sta L040B
            ldx #0
            ldy #4
            jsr LC642	      
            lda #1            ;One tape beep
            jsr LFDFC

            lda #255          ;First byte should be 255
            jsr L0631         ;Call Turbo 2000 block decoding subroutine
            bcs L0622         ;No error - jump
            jsr LC63E         ;Error - call "BOOT ERROR" ROM routine
            jmp L05D2         ;Back to the beginning

L0622       nop               

            jmp (L040F)       ;Run loaded program

;==============================================
;Block decoding subroutine
;Block is placed from: BUFRLO+256*BUFRHI
;                to:   (BFENLO+256*BFENHI)-1
;First byte of the block should be in
;acumulator register before subroutine
;is called        
;==============================================
    
L0631       sta LTEMP
            lda #52
            sta PACTL
            sta PBCTL
            lda #128
            sta POKMSK
            sta IRQEN
            clc
            ldy #0
            sty STATUS
            sty CHKSUM
            sty NMIEN
            sty DMACLT
            php
L0650       bne L06C2
L0652       jsr L06DB
            bcc L0650
            lda #0
            sta ICAX5Z
            sta LTEMP+1
L065D       ldy #180
L065F       jsr L06D6
            bcc L0650
            cpy #216
            bcc L0652
            inc ICAX5Z
            bne L065D
            dec LTEMP+1
L066E       ldy #209
            jsr L06DB
            bcc L0650
            cpy #222
            bcs L066E
            jsr L06DB
            bcc L06C2
            ldy #198
            jmp L069D
L0683       plp
            bne L068E
            lda LTEMP
            eor ICAX6Z
            bne L06C3
            beq L069A
L068E       ldy #0
            lda ICAX6Z
            sta (BUFRLO),Y
            inc BUFRLO
            bne L069A
            inc BUFRHI
L069A       ldy #200
            php
L069D       lda #1
            sta ICAX6Z
L06A1       jsr L06D6
            bcc L06C2
            cpy #227
            rol ICAX6Z
            ldy #198
            bcc L06A1
            lda CHKSUM
            eor ICAX6Z
            sta CHKSUM
            lda BUFRLO
            cmp BFENLO
            lda BUFRHI
            sbc BFENHI
            bcc L0683
            lda #0
            cmp CHKSUM
L06C2       pla
L06C3       lda #192
            sta NMIEN
            sta POKMSK
            sta IRQEN
            lda #60
            sta PACTL
            sta PBCTL
            rts
L06D6       jsr L06DB
            bcc L06FF
L06DB       ldx #4
L06DD       dex
            bne L06DD
            lda STATUS
            lsr A 
            and LTEMP+1
            sta COLBK
L06E8       iny
            beq L06FE
            lda BRKKEY
            beq L06FC
            lda SKSTAT
            and #16
            cmp STATUS
            beq L06E8
            sta STATUS
            sec
            rts
L06FC       dec BRKKEY
L06FE       clc
L06FF       rts


;-----------------------------------------------
;Strings
;-----------------------------------------------
TITLE       .BYTE "TURBO 2000",$9B

;-----------------------------------------------
;Initialization of DOS vectors
;-----------------------------------------------
DOSINIT     ldx #<1024
            stx DOSINI
            ldx #>1024
            stx DOSINI+1
            ldx #0
            sta WARMST
            rts 