;===============================================
;Chainloader (Turbo 2000, Czechoslovakia)
;===============================================

;Binary load emulation
;Binary file being loaded is required to have a RUN segment

;This loader loads sequence of turbo files. Almost each turbo
;file represents one segment from the binary file.

;Information for the loader is stored in the NAME
;part of turbo 2000 header

;Turbo 2000 header
;Offset Meaning
;00     Always 0
;01     File type
;02-11    File name, specially interpreted
;   02    R - RUN  segment
;         I - INIT segment
;         D - DATA segment
;         X - DATA segment, followed by RUN. Loader performs JMP to RUN address  
;         Y - DATA Segment, followed by INIT. Loader emulates JSR(RUN address)
;         K - RUNINIT Segment
;   03-08 Informative number of segment
;   09    Sequential number of segment     
;   10-11 Blank
;12-13  LOAD address
;14-15  LENGTH of file
;16-17  RUN address (Used only for X and Y segment types)
;18     Checksum

;Note: Inverse letter at offset 2 indicates last file
;      X and Y segment types were designed to save pilot tones

;If error occurs, 4 tape beeps are emitted
;If file is not loaded in sequence, 1 tape beep is emitted imediattely after
;loading the turbo 2000 header


.INCLUDE c_equates.asm


            *=1800



            jsr SHOWTITLE     ;Call subroutine that shows program title
            jmp L05D7         ;Continue to header decoding


L05D2       ldx #255          ;Swap keypress
            stx CH
            jsr LFDFC         ;Tape beep, count depends on A contents

;----------------------------------------------
;Header decoding
;----------------------------------------------
L05D7       lda #>HEADBUF     ;Setup buffer
            sta BUFRHI
            sta BFENHI
            lda #<HEADBUF+17
            sta BFENLO
            lda #<HEADBUF
            sta BUFRLO

            lda #0            ;Firts byte in the block is 0
            jsr L0631         ;Call Turbo 2000 block decoding subroutine

            bcc L05D7         ;If error occured, return back

            clc               ;Clear carry flag in order to not skew compare
            lda HEADBUF+10    ;Expected segment is read ?
            cmp EXPECTED      
            beq SETMBUF       ;Segment match, jump to main block decoding

BADSECT     lda #1            ;One tape beep
            jmp L05D2         ;Go back

;----------------------------------------------
;Main block decoding
;---------------------------------------------- 
SETMBUF     lda HEADBUF+11    ;Setup buffer
            sta BUFRLO
            clc
            adc HEADBUF+13
            sta BFENLO
            lda HEADBUF+12
            sta BUFRHI
            adc HEADBUF+14
            sta BFENHI


            lda #255           ;First byte in the block is 255
            jsr L0631          ;Call Turbo 2000 block decoding subroutine

            bcs L0622          ;If no error occured, handle loaded block

            lda #4             ;4 tape beeps
            jmp L05D2          ;Go back

;----------------------------------------------
;Handling loaded block
;----------------------------------------------

L0622       nop

            lda HEADBUF+1      ;Check the segment type
            and #127           ;Get rid of MSB

            cmp #82            ;Is it RUN ?
            beq NEXTCHAIN
            cmp #68            ;Is it DATA ?
            beq NEXTCHAIN 
            cmp #73            ;Is it INIT ?
            beq DOINIT
            cmp #88            ;Is it DATA+RUN ?
            beq DATARUN
            cmp #89            ;Is it DATA+INIT ?
            beq DATAINIT

RUNINIT     jmp DOINIT         ;RUN+INIT


DATARUN     lda HEADBUF+15     ;DATA+RUN, store RUN address to 736,337
            sta 736
            lda HEADBUF+16
            sta 737
            jmp NEXTCHAIN

DATAINIT    lda HEADBUF+15     ;DATA+INIT, store INIT address to 738,739 
            sta 738            ;and perform init
            lda HEADBUF+16
            sta 739

DOINIT      jsr TRICK          ;Emulating JSR(738)
            jmp NEXTCHAIN      ;Go to load next file
TRICK       jmp (738)


NEXTCHAIN   lda HEADBUF+1      ;Last segment ?
            and #128
            beq NXC            ;Not last segment, continue

            jmp (736)          ;Run loaded program

NXC         inc EXPECTED       ;Increase number of expected segment
            jmp L05D7          ;Continue


;==============================================
;Block decoding subroutine
;Block is placed from: BUFRLO+256*BUFRHI
;                to:   (BFENLO+256*BFENHI)-1
;First byte of the block should be in
;acumulator register before subroutine
;is called        
;==============================================
    
L0631       sta LTEMP
            lda #52
            sta PACTL
            sta PBCTL
            lda #128
            sta POKMSK
            sta IRQEN
            clc
            ldy #0
            sty STATUS
            sty CHKSUM
            sty NMIEN
            sty DMACLT
            php
L0650       bne L06C2
L0652       jsr L06DB
            bcc L0650
            lda #0
            sta ICAX5Z
            sta LTEMP+1
L065D       ldy #180
L065F       jsr L06D6
            bcc L0650
            cpy #216
            bcc L0652
            inc ICAX5Z
            bne L065D
            dec LTEMP+1
L066E       ldy #209
            jsr L06DB
            bcc L0650
            cpy #222
            bcs L066E
            jsr L06DB
            bcc L06C2
            ldy #198
            jmp L069D
L0683       plp
            bne L068E
            lda LTEMP
            eor ICAX6Z
            bne L06C3
            beq L069A
L068E       ldy #0
            lda ICAX6Z
            sta (BUFRLO),Y
            inc BUFRLO
            bne L069A
            inc BUFRHI
L069A       ldy #200
            php
L069D       lda #1
            sta ICAX6Z
L06A1       jsr L06D6
            bcc L06C2
            cpy #227
            rol ICAX6Z
            ldy #198
            bcc L06A1
            lda CHKSUM
            eor ICAX6Z
            sta CHKSUM
            lda BUFRLO
            cmp BFENLO
            lda BUFRHI
            sbc BFENHI
            bcc L0683
            lda #0
            cmp CHKSUM
L06C2       pla
L06C3       lda #192
            sta NMIEN
            sta POKMSK
            sta IRQEN
            lda #60
            sta PACTL
            sta PBCTL
            rts
L06D6       jsr L06DB
            bcc L06FF
L06DB       ldx #4
L06DD       dex
            bne L06DD
            lda STATUS
            lsr A 
            and LTEMP+1
            sta COLBK
L06E8       iny
            beq L06FE
            lda BRKKEY
            beq L06FC
            lda SKSTAT
            and #16
            cmp STATUS
            beq L06E8
            sta STATUS
            sec
            rts
L06FC       dec BRKKEY
L06FE       clc
L06FF       rts


EXPECTED    .BYTE 0             ;Expected segment

;-----------------------------------------------
;Space for strings
;-----------------------------------------------

HEADBUF     .BYTE 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
HEADBFEN    .BYTE 0,
TITLE       .BYTE "TS CHAINLOADER",$9B      ;Program title

;-----------------------------------------------
;Subroutine that shows title
;-----------------------------------------------
SHOWTITLE   ldx #<TITLE
            ldy #>TITLE
            jsr $C642
            lda #1
            sta 764
            jsr 65020   
            lda #0            ;Reset coldstart flag
            sta 580        
            lda #1            ;Indicate disk boot ok
            sta 9
            rts

