/* XEX2CAS 2.0
 * CAS File generator by Gienek plug@poczta.fm
 * Support for partial (0xFA) records added by Michael Kalouš
 */

using namespace std;

#include <iostream> 
#include <fstream>  
#include <cstring>

ifstream xexfile;
ofstream casfile;

/* "baud" tape image chunk - 600 bps*/
unsigned char heading[] = {0x62, 0x61, 0x75, 0x64, 0x00, 0x00, 0x58, 0x02};

/* Binary loader - Exclamation mark (!) loader */
unsigned char exma[560] = {
    0x20, 0x05, 0x00, 0x07, 0x20, 0x07, 0x20, 0xF4, 0x08, 0x4C, 0xED, 0xF2, 0x56, 0xFF, 0x55, 0x57,
    0x52, 0x03, 0x40, 0x2F, 0xEF, 0x17, 0x2F, 0x07, 0x37, 0x2F, 0x0A, 0x56, 0xFE, 0x72, 0x03, 0x40,
    0x52, 0x03, 0x40, 0x0F, 0xF9, 0xE7, 0x97, 0x97, 0xB3, 0xAF, 0xF8, 0x56, 0xFE, 0x72, 0x0F, 0xFD,
    0x56, 0xF8, 0x72, 0xAD, 0xFF, 0x56, 0xF5, 0x72, 0xAA, 0xFF, 0x72, 0xAB, 0xFF, 0x5D, 0x01, 0x5F,
    0xF7, 0xDF, 0x7A, 0x0C, 0xDF, 0x1D, 0x09, 0x36, 0xE4, 0x2F, 0x06, 0x97, 0x97, 0xB3, 0xA4, 0xF8,
    0x56, 0xA4, 0x72, 0xF5, 0xFF, 0x56, 0xF8, 0x72, 0xF4, 0xFF, 0x15, 0x56, 0xFD, 0x72, 0xAD, 0xFF,
    0x56, 0xFF, 0x72, 0x0F, 0xFD, 0x56, 0x82, 0xDF, 0x5B, 0x09, 0xDF, 0x1A, 0xF7, 0x5D, 0xEF, 0x56,
    0xFC, 0x62, 0xBD, 0xFC, 0x56, 0x04, 0x62, 0xBB, 0xFC, 0x56, 0xF7, 0x62, 0xBA, 0xFC, 0x56, 0xFB,
    0x62, 0xB5, 0xFC, 0x56, 0x7F, 0x62, 0xB4, 0xFC, 0x56, 0xF3, 0x72, 0x03, 0xFD, 0xDF, 0xA9, 0x1B,
    0x56, 0xFF, 0x72, 0xC9, 0xF6, 0x5D, 0xEF, 0x56, 0xCB, 0x62, 0xBB, 0xFC, 0x56, 0xF6, 0x62, 0xBA,
    0xFC, 0x56, 0xFD, 0x62, 0xB7, 0xFC, 0x56, 0xFF, 0x62, 0xB6, 0xFC, 0x56, 0xF8, 0x62, 0xBD, 0xFC,
    0xDF, 0xA9, 0x1B, 0xCF, 0xDA, 0x5D, 0xEF, 0x56, 0xCF, 0x62, 0xBB, 0xFC, 0x56, 0xF6, 0x62, 0xBA,
    0xFC, 0x56, 0xFB, 0x62, 0xB7, 0xFC, 0x56, 0xFF, 0x62, 0xB6, 0xFC, 0xDF, 0xA9, 0x1B, 0xEF, 0xE6,
    0x3F, 0x77, 0x2F, 0xF9, 0xDF, 0x1A, 0xF7, 0xB3, 0x82, 0xF7, 0x67, 0xB7, 0xDF, 0x1A, 0xF7, 0x97,
    0x57, 0x0F, 0xF9, 0xDF, 0x7E, 0x0C, 0xB3, 0x82, 0xF7, 0x52, 0xC9, 0xF6, 0x2F, 0xF0, 0x52, 0xCF,
    0xF6, 0x72, 0x1F, 0xFD, 0x52, 0xCE, 0xF6, 0x72, 0x1E, 0xFD, 0x31, 0xC9, 0xF6, 0x5D, 0xEF, 0x52,
    0xCF, 0xF6, 0x62, 0xBB, 0xFC, 0xB7, 0x52, 0xCE, 0xF6, 0x62, 0xBA, 0xFC, 0x57, 0x97, 0x37, 0x2F,
    0xE0, 0x57, 0x37, 0x2F, 0xE4, 0x52, 0xCD, 0xF6, 0x72, 0xCF, 0xF6, 0x52, 0xCC, 0xF6, 0x72, 0xCE,
    0xF6, 0x56, 0xCD, 0x62, 0xBB, 0xFC, 0x56, 0xF6, 0x62, 0xBA, 0xFC, 0x56, 0xFD, 0xB3, 0x3C, 0xF8,
    0x52, 0xCD, 0xF6, 0xC7, 0x12, 0xCF, 0xF6, 0x62, 0xB7, 0xFC, 0x52, 0xCC, 0xF6, 0x12, 0xCE, 0xF6,
    0x62, 0xB6, 0xFC, 0x52, 0xCE, 0xF6, 0x01, 0xB7, 0xFC, 0x2F, 0xFC, 0x01, 0xB6, 0xFC, 0x5D, 0xEF,
    0x56, 0x0C, 0x72, 0x1D, 0xFD, 0x56, 0xF7, 0x72, 0x1C, 0xFD, 0xDF, 0xA9, 0x1B, 0xEF, 0xFC, 0xB3,
    0x25, 0xF8, 0x56, 0xFF, 0x72, 0xBB, 0xFD, 0x56, 0xFE, 0x7A, 0xF6, 0x15, 0x15, 0x15, 0xDF, 0x6D,
    0xF7, 0xDF, 0x85, 0xF7, 0xDF, 0x30, 0xF7, 0xB3, 0x4A, 0xF8, 0x93, 0x1D, 0xFD, 0x56, 0xFF, 0x72,
    0xBB, 0xFD, 0x56, 0xFE, 0x7A, 0xF6, 0x15, 0x15, 0x15, 0xDF, 0x6D, 0xF7, 0xDF, 0x30, 0xF7, 0x93,
    0x1F, 0xFD, 0x56, 0x63, 0x72, 0xFD, 0xFF, 0x56, 0x0C, 0x72, 0xFC, 0xFF, 0x60, 0xA9, 0x0C, 0x8D,
    0xD0, 0x00, 0xA9, 0x07, 0x8D, 0xD1, 0x00, 0xA0, 0x00, 0xB1, 0xD0, 0x49, 0xFF, 0x91, 0xD0, 0xEE,
    0xD0, 0x00, 0xD0, 0x03, 0xEE, 0xD1, 0x00, 0xAD, 0xD1, 0x00, 0xC9, 0x08, 0xD0, 0xE9, 0xAD, 0xD0,
    0x00, 0xC9, 0x9C, 0xD0, 0xE2, 0xA9, 0x00, 0x8D, 0xD0, 0x00, 0x8D, 0xD1, 0x00, 0xEA, 0x60, 0xA9,
    0x3C, 0x8D, 0x02, 0xD3, 0x60, 0xA9, 0x20, 0x8D, 0x09, 0x07, 0xA9, 0x9D, 0x8D, 0x0A, 0x07, 0xA9,
    0x08, 0x8D, 0x0B, 0x07, 0x60, 0xA2, 0x10, 0xA9, 0x0C, 0x20, 0x56, 0xE4, 0xA2, 0x20, 0xA9, 0x0C,
    0x20, 0x56, 0xE4, 0x60, 0x20, 0xCF, 0x08, 0x20, 0xD5, 0x08, 0x60, 0x43, 0x3A, 0x9B, 0xFD, 0xE3,
    0xE1, 0xF2, 0xF4, 0xF2, 0xE9, 0xE4, 0xE7, 0xE5, 0xA0, 0xE9, 0xEE, 0xF3, 0xF4, 0xE1, 0xEC, 0xEC,
    0xE5, 0xE4, 0x1D, 0x9C, 0xF4, 0xF9, 0xF0, 0xE5, 0xA0, 0xBC, 0xC5, 0xD3, 0xC3, 0xBE, 0xA0, 0xF4,
    0xEF, 0xA0, 0xE3, 0xEF, 0xEE, 0xF4, 0xE9, 0xF5, 0xE5, 0xA0, 0xE2, 0xEF, 0xEF, 0xF4, 0xFD, 0x9B,
};

/*Output buffer*/
unsigned char buf[128];

/*Buffers for file names*/
char xex_name[128];
char cas_name[128];

/*Counters and indicators*/
unsigned int count = 0;
unsigned char start = 1;
unsigned char add_exma = 1;

/* Output first portion of a data chunk to the tape image*/
void casstan(unsigned char t = 0) {

    casfile << "data";
    /*133 bytes*/
    casfile.put(0x84);
    casfile.put(0x00);
    if (t) {
        /*Leader is 20 seconds*/
        casfile.put(0xa8);
        casfile.put(0x61);
    } else {
        /*Short IRG is 0.25 seconds*/
        casfile.put(0xFA);
        casfile.put(0x00);
    };
    /*Atari Synchro*/
    casfile.put(0x55);
    casfile.put(0x55);
}

/*Output a full data chunk to the tape image*/
void putbuf() {

    /*Output first portion of a data chunk*/
    if (start) {
        start = 0;
        casstan(1);
    } else {
        casstan();
    };

    unsigned int sum;
    
    /*Output full (0xFC) or partial (0xFA) block*/
    if (count == 128) {
        sum = 0xA7;
        casfile.put(0xFC);
    }
    else {
        sum = 0xA5;
        casfile.put(0xFA);
        buf[127]=count;
    }

    for (int i = 0; i < 128; i++) {
        casfile.put(buf[i]);
        sum += (unsigned int) buf[i];
        if (sum > 255) {
            sum &= 0x00ff;
            sum++;
        };
        
        /*Clear buffer for later use*/
        buf[i] = 0;
    };
    casfile.put((unsigned char) sum);
    
    /*Reset counter*/
    count=0;
    
}

/* Output EOF block*/
void puteof() {

    /*If there are remaining bytes, flush them*/
    if (count) {
        putbuf();
    };

    /*Output EOF block*/
    casstan();
    casfile.put(0xFE);
    for (int i = 0; i < 128; i++) {
        casfile.put(0x00);
    }
    casfile.put(0xA9);
}

/*Put one byte to the tape image - high level function*/
void copy(unsigned char b) {
    buf[count] = b;
    count++;
    if (count > 127) {
        putbuf();
    }
}


void printusage() {
    cout << endl;
    cout << "Usage: xex2cas file.xex file.cas [/b]" << endl;
    cout << "/b - Do not prepend the Exclamation mark binary loader" << endl << endl;
}

/* Mainline code*/
int main(int argc, char *argv[]) {
    
    cout << "XEX2CAS 2.0 by Gienek plug@poczta.fm, updated by Michael Kalous" << endl;
    
    /*When invoked without bad number of arguments, display usage information*/
    if (argc < 3 || argc > 4) {
        printusage();
        return 0;
    }
        
    /*Determine whether to prepend the binary loader*/
    add_exma=1;
    if (argc==4) {
        if (strcmp(argv[3],"/b")!=0) {
            printusage();
            return -1;
        }
        add_exma=0;
    }
    
    /*Display the file specifiers*/
    cout << "Convert " << argv[1] << " to " << argv[2] << endl;
    
    /*Try to open input file*/
    xexfile.open(argv[1], ios::binary | ios::in);
    if (!xexfile) {
        cout << "Error - Unable to open input file" << endl;
        return -1;
    } 
    
    /*Try to open output file*/
    casfile.open(argv[2], ios::binary | ios::out);
    if (!casfile) {
        cout << "Error - Unable to open output file" << endl;
        return -1;
    }
    
    /*Output FUJI chunk*/
    casfile << "FUJI";
    casfile.put(0x19);
    casfile.put(0x00);
    casfile.put(0x00);
    casfile.put(0x00);
    casfile << "File generated by XEX2CAS";
    
    /*Output baud chunk*/
    casfile << "baud";
    casfile.put(0x00);
    casfile.put(0x00);
    casfile.put(0x58);
    casfile.put(0x02);
    
    /*Prepend the binary loader*/
    if (add_exma) {
        cout << "Prepending Exclamation mark binary loader" << endl;
        start = 1;
        for (unsigned int e = 0; e < 560; e++) {
            copy(exma[e]);
        };
        puteof();
        
    };
    
    /*Convert the binary file*/
    start = 1;
    char r;
    while (xexfile.get(r)) {
        copy(r);
    };
    puteof();
    
    casfile.close();
    xexfile.close();
    
    cout << "Done" << endl;
    return 0;
}
