#ifndef OPTIONS_H
#define	OPTIONS_H

#include <string>

using namespace std;

namespace xex2cas {

    class Options {
    public:
        
        /*Mode*/
        int operationMode;
        
        /*Common options*/
        bool overwriteOutputs;
        bool useShorterLeader;
        bool useFasterTransferSpeed;
        bool useEmptyFUJIChunk;
        
        /*BINARY mode options*/
        int loaderType;
        int elongateInitIRGs;
        string programName;
        string companyName;
        bool useLongerIRGs;
        
        /*BOOTBASIC mode options*/
        int basicInitializerType;
        
        /*PLAIN mode options*/
        int eofTrickType;
        bool useLongIRGs;
        
        /*Input and output files*/
        string inputFile;
        string outputFile;
        
        /*Constants*/
        static const int OPTIONS_OK = 0;
        static const int OPTIONS_ERROR = 1;
        static const int OPTIONS_HELP = 2;

        static const int LDR_NONE = 0;
        static const int LDR_MODERN_STDBLOAD2 = 1;
        static const int LDR_XL_FIXED_EXMA = 2;
        static const int LDR_ORIGINAL_EXMA = 3;
        static const int LDR_LKAVALON_BL = 4;
        static const int LDR_FANCY = 5;
        static const int LDR_SIECOD = 6;
        
        static const int BINIT_LAUNCHBAS = 0;
        static const int BINIT_BAS2CAS = 1;
        
        static const int EOF_TRICK_NONE = 0;
        static const int EOF_TRICK_DATA_IN_EOF = 1;
        static const int EOF_TRICK_LAST_FULL = 2;
        
        static const int MODE_BINARY = 0;
        static const int MODE_BOOTBASIC = 1;
        static const int MODE_PLAIN =2;

        Options();
        int parse(int argc, char* argv[]);
        void displayUsage();
    };

}

#endif	/* OPTIONS_H */

