#include "dos2binary.h"
#include <iomanip>
#include <sstream>

using namespace std;
using namespace xex2cas;

DOS2BinaryFile::DOS2BinaryFile() {
    parseError = "";
    parseRBA = 0;
}

bool DOS2BinaryFile::coversMemory(int beginAddr, int endAddr) {
    vector<Segment>::iterator it = segments.begin();
    while (it != segments.end()) {
        Segment s = *it;
        if (
                !(
                (s.begin < beginAddr && s.end < endAddr) ||
                (s.begin > endAddr && s.end > endAddr)
                )
                ) {
            return true;
        }
        it++;
    }
}

int DOS2BinaryFile::parse(unsigned char* data, int dataLen) {

    int dataIndex = 0;
    segments.clear();
    bool checkHeader = true;
    parseError = "";
    parseRBA = 0;

    while (dataIndex < dataLen) {

        int bytesToGo = dataLen - dataIndex;

        /*Is there enough bytes left to constitute at least 0xFF,0xFF*/
        if (bytesToGo < 2) {
            if (checkHeader == true) return D2BF_ALIEN;
            parseError = "Trailing byte near end of file";
            parseRBA = dataIndex;
            return D2BF_CORRUPT;
        }

        /*Get segment header*/
        int byte1 = data[dataIndex];
        int byte2 = data[dataIndex + 1];
        int startRBA = dataIndex;

        dataIndex += 2;
        bytesToGo = dataLen - dataIndex;

        /*Check for 255 255 and skip it*/
        if ((byte1 == 0xFF) && (byte2 == 0xFF)) {
            checkHeader = false;
            continue;
        }

        if (checkHeader == true) {
            return D2BF_ALIEN;
        }


        if (bytesToGo < 2) {
            parseError = "Trailing byte near end of file";
            parseRBA = dataIndex;
        }

        /*We have segment header*/
        int begin = byte1 + (byte2 * 256);
        int end = data[dataIndex]+(data[dataIndex + 1]*256);

        /*If the segment has negative size, the binary file is corrupt*/
        if (begin > end) {
            parseError = "Negative segment size";
            parseRBA = dataIndex;
            return D2BF_CORRUPT;
        }

        /*Skip past segment end address*/
        dataIndex += 2;
        bytesToGo = dataLen - dataIndex;

        /*Check if there is enough data for the segment*/
        if (bytesToGo < (end - begin + 1)) {
            parseError = "Segment end address is beyond end of file";
            parseRBA = dataIndex;
            return D2BF_CORRUPT;
        }

        /*Create segment and add it to the list*/
        Segment seg(begin, end, startRBA);
        segments.push_back(seg);

        /*Move past segment data*/
        dataIndex += (end - begin + 1);
    }

    return D2BF_OK;

}

string DOS2BinaryFile::getParseError() {

    stringstream ss;
    ss << uppercase << setw(4) << hex << parseRBA;
    return parseError + " at offset " + ss.str();
}

void DOS2BinaryFile::dump() {
    vector<Segment>::iterator it = segments.begin();
    
    while (it != segments.end()) {
        (*it).dump();
        it++;
    }
}

vector<int> DOS2BinaryFile::getInitRBAs() {
    vector<int> RBAs;

    vector<Segment>::iterator it = segments.begin();
    while (it != segments.end()) {
        Segment seg = (*it);
        if (seg.isInit == true) {
            RBAs.push_back(seg.endRBA);
        }
        it++;
    }

    return RBAs;
}

