#ifndef DOS2BINARY_H
#define	DOS2BINARY_H

#include <vector>
#include "segment.h"
#include <string>

using namespace std;

namespace xex2cas {
    class DOS2BinaryFile {
    public:
        static const int D2BF_OK = 0;
        static const int D2BF_ALIEN = 1;
        static const int D2BF_CORRUPT = 2;
        vector<Segment> segments;
        int parse(unsigned char* data, int dataLen);
        bool coversMemory(int beginAddr, int endAddr);
        void dump();
        vector<int> getInitRBAs();
        DOS2BinaryFile();
        string getParseError();
    private:
        string parseError;
        int parseRBA;
    };
}

#endif	/* DOS2BINARY_H */

