#ifndef OPTIONS_H
#define	OPTIONS_H

#include <string>

using namespace std;

namespace xex2cas {

    class Options {
    public:
        
        bool doNotPrependLoader;
        bool useShorterLeader;
        bool useFasterTransferSpeed;
        bool useLongerIRGs;
        bool useEmptyFUJIChunk;
        int initIRGs;
        bool overwriteOutputs;
        int loaderType;
        
        string filename;
        string inputFile;
        string outputFile;

        static const int OPTIONS_OK = 0;
        static const int OPTIONS_ERROR = 1;
        static const int OPTIONS_HELP = 2;

        static const int LDR_MODERN_EXMA = 0;
        static const int LDR_XL_FIXED_EXMA = 1;
        static const int LDR_ORIGINAL_EXMA = 2;

        Options();
        int parse(int argc, char* argv[]);
        void displayUsage();
        void dump();

    };

}

#endif	/* OPTIONS_H */

