#ifndef f_SECTORPARSER_H
#define f_SECTORPARSER_H

class SectorParser {
public:
	SectorParser();

	void Init(int track, const std::vector<uint32_t> *indexTimes, float samplesPerCell, TrackInfo *dstTrack, uint32_t streamTime);

	bool Parse(uint32_t stream_time, uint8_t clock_bits, uint8_t data_bits);

protected:
	TrackInfo *mpDstTrack;
	int mTrack;
	int mSector;
	int mSectorSize;
	int mReadPhase;
	int mBitPhase;
	int mDAMBitCounter;
	uint32_t mDAMMinTime;
	uint32_t mDAMTimeoutTime;
	uint32_t mRawStart;
	float mRotPos;
	float mSamplesPerCell;

	uint8_t mBuf[1024 + 4];
	uint8_t mClockBuf[1024 + 4];
	uint32_t mStreamTimes[1024 + 4];

	const std::vector<uint32_t> *mpIndexTimes;
};

class SectorParserMFM {
public:
	SectorParserMFM();

	void Init(int track, const std::vector<uint32_t> *indexTimes, float samplesPerCell, TrackInfo *dstTrack, uint32_t streamTime);

	bool Parse(uint32_t stream_time, uint8_t clock_bits, uint8_t data_bits);

protected:
	TrackInfo *mpDstTrack;
	int mTrack;
	int mSector;
	int mSectorSize;
	int mReadPhase;
	int mBitPhase;
	uint32_t mRawStart;
	float mRotPos;
	float mSamplesPerCell;

	uint8_t mBuf[1024 + 3];

	const std::vector<uint32_t> *mpIndexTimes;
};

#endif
